/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.ide;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.common.ICallback;
import org.eclipse.jem.internal.proxy.common.IVMCallbackServer;
import org.eclipse.jem.internal.proxy.core.ExpressionProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.ICallbackRegistry;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IProxy;
import org.eclipse.jem.internal.proxy.core.IProxyMethod;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.ide.IDEProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.ide.IDEVMServer;
import org.eclipse.jem.internal.proxy.ide.IIDEBeanProxy;

public class IDECallbackRegistry
implements ICallbackRegistry {
    IDEVMServer fVMServer;
    int fNextCallbackID;
    IDEProxyFactoryRegistry fProxyFactoryRegistry;
    Map fCallbackIDToCallback = new HashMap(25);
    Map fBeanProxyToCallbackID = new HashMap(25);
    Map fCallbackIDToStream = new HashMap(25);
    private IProxyMethod initializeCallbackMethodProxy;
    private IBeanProxy vmServerProxy;

    IDECallbackRegistry(IDEProxyFactoryRegistry aRegistry) {
        this.fProxyFactoryRegistry = aRegistry;
        this.fVMServer = new IDEVMServer(this);
        this.vmServerProxy = aRegistry.getBeanProxy(this.fVMServer.getClass(), this.fVMServer);
        try {
            Method initializeCallbackMethod = ICallback.class.getMethod("initializeCallback", IVMCallbackServer.class, Integer.TYPE);
            this.initializeCallbackMethodProxy = (IProxyMethod)((Object)aRegistry.getBeanProxy(Method.class, initializeCallbackMethod));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void registerCallback(IBeanProxy aBeanProxy, org.eclipse.jem.internal.proxy.core.ICallback aCallback) {
        ICallback vmCallback = (ICallback)((IIDEBeanProxy)aBeanProxy).getBean();
        ++this.fNextCallbackID;
        int callbackID = this.fNextCallbackID;
        vmCallback.initializeCallback(this.fVMServer, callbackID);
        Integer callbackIntegerID = new Integer(callbackID);
        this.fCallbackIDToCallback.put(callbackIntegerID, aCallback);
        this.fBeanProxyToCallbackID.put(aBeanProxy, callbackIntegerID);
    }

    @Override
    public void registerCallback(IProxy callbackProxy, org.eclipse.jem.internal.proxy.core.ICallback cb, IExpression expression) {
        final Integer callbackID = new Integer(++this.fNextCallbackID);
        this.fCallbackIDToCallback.put(callbackID, cb);
        if (callbackProxy.isBeanProxy()) {
            this.fBeanProxyToCallbackID.put(callbackProxy, callbackID);
        } else {
            ((ExpressionProxy)callbackProxy).addProxyListener(new ExpressionProxy.ProxyAdapter(){

                @Override
                public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                    IDECallbackRegistry.this.fBeanProxyToCallbackID.put(event.getProxy(), callbackID);
                }
            });
        }
        expression.createSimpleMethodInvoke(this.initializeCallbackMethodProxy, callbackProxy, new IProxy[]{this.vmServerProxy, this.fProxyFactoryRegistry.getBeanProxyFactory().createBeanProxyWith((int)callbackID)}, false);
    }

    OutputStream requestStream(final int aCallbackID, final int aMsgID) {
        PipedOutputStream result = new PipedOutputStream();
        PipedInputStream tempStream = null;
        try {
            tempStream = new PipedInputStream(result);
        }
        catch (IOException exc) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)exc));
            return null;
        }
        final PipedInputStream inputStream = tempStream;
        Thread streamProcessor = new Thread(){

            @Override
            public void run() {
                org.eclipse.jem.internal.proxy.core.ICallback ideCallback = (org.eclipse.jem.internal.proxy.core.ICallback)IDECallbackRegistry.this.fCallbackIDToCallback.get(new Integer(aCallbackID));
                if (ideCallback != null) {
                    try {
                        ideCallback.calledBackStream(aMsgID, inputStream);
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException exc) {
                            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)exc));
                        }
                    }
                }
            }
        };
        streamProcessor.start();
        return result;
    }

    Object vmCallback(int aCallbackID, int aMsgID, Object[] parms) {
        org.eclipse.jem.internal.proxy.core.ICallback ideCallback = (org.eclipse.jem.internal.proxy.core.ICallback)this.fCallbackIDToCallback.get(new Integer(aCallbackID));
        Object callbackResult = null;
        callbackResult = parms.length == 1 ? ideCallback.calledBack(aMsgID, (IBeanProxy)parms[0]) : ideCallback.calledBack(aMsgID, parms);
        return callbackResult;
    }

    Object vmCallback(int aCallbackID, int aMsgID, Object parm) {
        org.eclipse.jem.internal.proxy.core.ICallback ideCallback = (org.eclipse.jem.internal.proxy.core.ICallback)this.fCallbackIDToCallback.get(new Integer(aCallbackID));
        return ideCallback.calledBack(aMsgID, parm);
    }

    @Override
    public void deregisterCallback(IBeanProxy aBeanProxy) {
        Integer callbackID = (Integer)this.fBeanProxyToCallbackID.remove(aBeanProxy);
        this.fCallbackIDToCallback.remove(callbackID);
    }
}

