/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.junit4.ui.util;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class DisplayHelperTestRule
implements TestRule {
    private boolean displayOwner;
    private Display display;
    private Shell shell;

    public Display getDisplay() {
        if (this.display == null) {
            this.displayOwner = Display.getCurrent() == null;
            this.display = Display.getDefault();
        }
        return this.display;
    }

    public Shell getShell() {
        if (this.shell == null) {
            this.shell = this.createShell();
        }
        return this.shell;
    }

    public Shell createShell() {
        return this.createShell(0);
    }

    public Shell createShell(int style) {
        return new Shell(this.getDisplay(), style);
    }

    public void flushPendingEvents() {
        while (this.display != null && !this.display.isDisposed() && this.display.readAndDispatch()) {
        }
    }

    public void dispose() {
        this.flushPendingEvents();
        this.disposeShell();
        this.disposeDisplay();
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                finally {
                    DisplayHelperTestRule.this.dispose();
                }
            }
        };
    }

    private void disposeShell() {
        if (this.shell != null) {
            this.shell.dispose();
        }
    }

    private void disposeDisplay() {
        if (this.display != null && this.displayOwner) {
            if (this.display.isDisposed()) {
                this.display.dispose();
            }
            this.display = null;
        }
    }
}

