/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.egit.ui.internal.merge;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.merge.MergeInputMode;
import org.eclipse.emf.compare.egit.internal.merge.DirCacheResourceVariantTreeProvider;
import org.eclipse.emf.compare.egit.internal.merge.GitResourceVariantTreeProvider;
import org.eclipse.emf.compare.egit.internal.merge.GitResourceVariantTreeSubscriber;
import org.eclipse.emf.compare.egit.internal.merge.LogicalModels;
import org.eclipse.emf.compare.egit.ui.internal.EMFCompareEGitUIMessages;
import org.eclipse.emf.compare.egit.ui.internal.merge.GitMergeEditorInput;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberMergeContext;
import org.eclipse.team.core.subscribers.SubscriberResourceMappingContext;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.ui.mapping.ISynchronizationCompareAdapter;

public class ModelGitMergeEditorInput
extends GitMergeEditorInput {
    private final boolean useWS;
    private final IPath[] paths;

    public ModelGitMergeEditorInput(MergeInputMode mode, IPath ... locations) {
        super(mode, locations);
        this.useWS = !MergeInputMode.STAGE_2.equals((Object)mode);
        this.paths = locations;
    }

    @Override
    protected ICompareInput prepareCompareInput(Repository repository, Collection<String> filterPaths, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            DirCacheResourceVariantTreeProvider variantTreeProvider = new DirCacheResourceVariantTreeProvider(repository, this.useWS);
            GitResourceVariantTreeSubscriber subscriber = new GitResourceVariantTreeSubscriber((GitResourceVariantTreeProvider)variantTreeProvider);
            this.checkCanceled(monitor);
            LinkedHashSet<IProject> projects = new LinkedHashSet<IProject>();
            IResource[] iResourceArray = subscriber.roots();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource root = iResourceArray[n2];
                projects.add(root.getProject());
                ++n2;
            }
            LinkedHashSet<IResource> resourcesInOperation = new LinkedHashSet<IResource>();
            boolean outOfWS = false;
            IPath[] iPathArray = this.paths;
            int n3 = this.paths.length;
            int n4 = 0;
            while (n4 < n3) {
                IPath path = iPathArray[n4];
                boolean foundMatchInWS = false;
                Iterator projectIterator = projects.iterator();
                while (!foundMatchInWS && projectIterator.hasNext()) {
                    IProject project = (IProject)projectIterator.next();
                    IPath projectLocation = project.getLocation();
                    if (projectLocation.equals((Object)path)) {
                        resourcesInOperation.addAll(this.getConflictingFilesFrom((IContainer)project));
                        foundMatchInWS = true;
                        continue;
                    }
                    if (!project.getLocation().isPrefixOf(path)) continue;
                    IResource resource = ResourceUtil.getResourceForLocation((IPath)path, (boolean)false);
                    if (resource instanceof IContainer) {
                        resourcesInOperation.addAll(this.getConflictingFilesFrom((IContainer)resource));
                    } else {
                        resourcesInOperation.add(resource);
                    }
                    foundMatchInWS = true;
                }
                if (!foundMatchInWS) {
                    if (!resourcesInOperation.isEmpty()) break;
                    outOfWS = true;
                } else if (outOfWS) break;
                ++n4;
            }
            this.checkCanceled(monitor);
            if (!resourcesInOperation.isEmpty() && outOfWS) {
                throw new InvocationTargetException(new IllegalStateException(EMFCompareEGitUIMessages.getString("GitMergeEditorInput_OutOfWSResources")));
            }
            if (!resourcesInOperation.isEmpty()) {
                ISynchronizationCompareAdapter compareAdapter;
                SubscriberResourceMappingContext remoteMappingContext = new SubscriberResourceMappingContext((Subscriber)subscriber, true);
                Set model = null;
                for (IResource comparedResource : resourcesInOperation) {
                    model = LogicalModels.discoverModel((IResource)comparedResource, (ResourceMappingContext)remoteMappingContext);
                    if (model.isEmpty()) continue;
                    if (model.containsAll(resourcesInOperation)) break;
                    throw new RuntimeException(EMFCompareEGitUIMessages.getString("GitMergeEditorInput_MultipleModels"));
                }
                if ((compareAdapter = (ISynchronizationCompareAdapter)LogicalModels.findAdapter(model, ISynchronizationCompareAdapter.class)) != null) {
                    Set allMappings = LogicalModels.getResourceMappings((Set)model, (ResourceMappingContext)remoteMappingContext);
                    this.checkCanceled(monitor);
                    ISynchronizationContext synchronizationContext = this.prepareSynchronizationContext(repository, (Subscriber)subscriber, allMappings, (RemoteResourceMappingContext)remoteMappingContext);
                    Object modelObject = ((ResourceMapping)allMappings.iterator().next()).getModelObject();
                    if (compareAdapter.hasCompareInput(synchronizationContext, modelObject)) {
                        return compareAdapter.asCompareInput(synchronizationContext, modelObject);
                    }
                }
            }
        }
        catch (IOException | CoreException e) {
            throw new InvocationTargetException(e);
        }
        return null;
    }

    private void checkCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private Set<IResource> getConflictingFilesFrom(IContainer container) throws IOException {
        LinkedHashSet<IResource> conflictingResources = new LinkedHashSet<IResource>();
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)container);
        if (mapping == null) {
            return conflictingResources;
        }
        IndexDiffCacheEntry indexDiffCacheEntry = IndexDiffCache.INSTANCE.getIndexDiffCacheEntry(mapping.getRepository());
        if (indexDiffCacheEntry == null) {
            return conflictingResources;
        }
        IndexDiffData indexDiffData = indexDiffCacheEntry.getIndexDiff();
        if (indexDiffData != null) {
            IPath containerPath = container.getLocation();
            File workTree = mapping.getWorkTree();
            if (workTree != null) {
                Path workDirPrefix = new Path(workTree.getCanonicalPath());
                for (String conflicting : indexDiffData.getConflicting()) {
                    IPath resourcePath = workDirPrefix.append(conflicting);
                    if (!containerPath.isPrefixOf(resourcePath)) continue;
                    IPath containerRelativePath = resourcePath.removeFirstSegments(containerPath.segmentCount());
                    conflictingResources.add((IResource)container.getFile(containerRelativePath));
                }
            }
        }
        return conflictingResources;
    }

    private ISynchronizationContext prepareSynchronizationContext(Repository repository, Subscriber subscriber, Set<ResourceMapping> allModelMappings, RemoteResourceMappingContext mappingContext) throws CoreException, OperationCanceledException, InterruptedException {
        ResourceMapping[] mappings = allModelMappings.toArray(new ResourceMapping[allModelMappings.size()]);
        InternalSubscriberScopeManager manager = new InternalSubscriberScopeManager(subscriber.getName(), mappings, subscriber, mappingContext, true, repository);
        manager.initialize((IProgressMonitor)new NullProgressMonitor());
        GitSynchronizationContext context = new GitSynchronizationContext(subscriber, (ISynchronizationScopeManager)manager);
        Job.getJobManager().join((Object)context, (IProgressMonitor)new NullProgressMonitor());
        return context;
    }

    private static class GitSynchronizationContext
    extends SubscriberMergeContext {
        public GitSynchronizationContext(Subscriber subscriber, ISynchronizationScopeManager scopeManager) {
            super(subscriber, scopeManager);
            this.initialize();
        }

        public void markAsMerged(IDiff node, boolean inSyncHint, IProgressMonitor monitor) throws CoreException {
        }

        public void reject(IDiff diff, IProgressMonitor monitor) throws CoreException {
        }

        protected void makeInSync(IDiff diff, IProgressMonitor monitor) throws CoreException {
        }

        public void dispose() {
            super.dispose();
        }
    }

    private static final class InternalSubscriberScopeManager
    extends SubscriberScopeManager {
        private final Repository repository;

        public InternalSubscriberScopeManager(String name, ResourceMapping[] inputMappings, Subscriber subscriber, RemoteResourceMappingContext context, boolean consultModels, Repository repository) {
            super(name, inputMappings, subscriber, context, consultModels);
            this.repository = repository;
        }

        public ISchedulingRule getSchedulingRule() {
            return RuleUtil.getRule((Repository)this.repository);
        }
    }
}

