/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.merge.java.facade.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.codegen.merge.java.facade.JEnum;
import org.eclipse.emf.codegen.merge.java.facade.JNode;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJAbstractType;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJAnnotation;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJEnumConstant;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJMember;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJNode;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;

public class ASTJEnum
extends ASTJAbstractType<EnumDeclaration>
implements JEnum {
    protected List<String> addedSuperInterfaces = null;
    protected String[] superInterfaces = EMPTY_STRING_ARRAY;

    public ASTJEnum(EnumDeclaration enumDeclaration) {
        super(enumDeclaration);
    }

    @Override
    public void dispose() {
        if (this.addedSuperInterfaces != null) {
            this.addedSuperInterfaces.clear();
            this.addedSuperInterfaces = null;
        }
        this.superInterfaces = null;
        super.dispose();
    }

    @Override
    public void addSuperInterface(String superInterface) {
        if (this.addedSuperInterfaces == null) {
            this.addedSuperInterfaces = new ArrayList<String>();
        }
        this.addedSuperInterfaces.add(superInterface);
        this.addValueToListProperty((ASTNode)this.getASTNode(), superInterface, EnumDeclaration.SUPER_INTERFACE_TYPES_PROPERTY, 43);
    }

    @Override
    public String[] getSuperInterfaces() {
        if (this.superInterfaces == EMPTY_STRING_ARRAY) {
            this.superInterfaces = this.convertASTNodeListToStringArray(((EnumDeclaration)this.getASTNode()).superInterfaceTypes());
        }
        this.superInterfaces = this.combineArrayAndList(this.superInterfaces, this.addedSuperInterfaces);
        return this.superInterfaces;
    }

    @Override
    public void setSuperInterfaces(String[] superInterfaces) {
        this.superInterfaces = superInterfaces;
        this.addedSuperInterfaces = null;
        this.setListNodeProperty((ASTNode)this.getASTNode(), superInterfaces, EnumDeclaration.SUPER_INTERFACE_TYPES_PROPERTY, 43);
    }

    @Override
    public boolean insertSibling(ASTJNode<?> node, ASTJNode<?> newSibling, boolean before) {
        if (newSibling.getParent() != null || node.getParent() != this) {
            return false;
        }
        if (newSibling instanceof ASTJEnumConstant) {
            if (node instanceof ASTJEnumConstant) {
                this.insert(newSibling, EnumDeclaration.ENUM_CONSTANTS_PROPERTY, node, before);
            } else if (node instanceof ASTJAnnotation) {
                this.insertFirst(newSibling, EnumDeclaration.ENUM_CONSTANTS_PROPERTY);
            } else {
                this.insertLast(newSibling, EnumDeclaration.ENUM_CONSTANTS_PROPERTY);
            }
            return true;
        }
        if (node instanceof ASTJEnumConstant) {
            if (newSibling instanceof ASTJAnnotation) {
                this.insertLastAnnotation((ASTJAnnotation)newSibling);
                return true;
            }
            if (newSibling instanceof ASTJMember) {
                this.insertFirst(newSibling, ((EnumDeclaration)this.getASTNode()).getBodyDeclarationsProperty());
                return true;
            }
        }
        return super.insertSibling(node, newSibling, before);
    }

    @Override
    public boolean addChild(ASTJNode<?> child) {
        if (child.getParent() != null) {
            return false;
        }
        if (child instanceof ASTJEnumConstant) {
            this.insertLast(child, EnumDeclaration.ENUM_CONSTANTS_PROPERTY);
            return true;
        }
        return super.addChild(child);
    }

    @Override
    public boolean remove(ASTJNode<?> node) {
        if (node.getParent() != this) {
            return false;
        }
        if (node instanceof ASTJEnumConstant) {
            this.remove(node, EnumDeclaration.ENUM_CONSTANTS_PROPERTY);
            return true;
        }
        return super.remove(node);
    }

    @Override
    public List<JNode> getChildren() {
        if (!this.isDisposed()) {
            ArrayList<JNode> children = new ArrayList<JNode>();
            children.addAll(this.getAnnotationList());
            children.addAll(this.getEnumConstants());
            children.addAll(this.getMembers());
            if (!children.isEmpty()) {
                return Collections.unmodifiableList(children);
            }
        }
        return Collections.emptyList();
    }

    protected List<JNode> getEnumConstants() {
        ArrayList<JNode> constants = new ArrayList<JNode>();
        ListRewrite listRewrite = this.rewriter.getListRewrite(this.getASTNode(), EnumDeclaration.ENUM_CONSTANTS_PROPERTY);
        for (Object enumConstant : listRewrite.getRewrittenList()) {
            JNode node = this.getFacadeHelper().convertToNode(enumConstant);
            if (node == null) continue;
            constants.add(node);
        }
        return constants;
    }
}

