/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer.resources;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.refresh.IRefreshMonitor;
import org.eclipse.core.resources.refresh.IRefreshResult;
import org.eclipse.core.resources.refresh.RefreshProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckoutManager;
import org.eclipse.emf.cdo.internal.explorer.resources.CDOCheckoutRefreshMonitor;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.container.IContainerEventVisitor;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;

public class CDOCheckoutRefreshProvider
extends RefreshProvider
implements IListener {
    private final Map<String, CDOCheckoutRefreshMonitor> monitors = new HashMap<String, CDOCheckoutRefreshMonitor>();

    public CDOCheckoutRefreshProvider() {
        CDOExplorerUtil.getCheckoutManager().addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRefreshMonitor installMonitor(IResource resource, IRefreshResult result, IProgressMonitor progressMonitor) {
        CDOCheckoutRefreshMonitor monitor;
        String checkoutID = this.getCheckoutID(resource);
        if (checkoutID == null) {
            return null;
        }
        Map<String, CDOCheckoutRefreshMonitor> map = this.monitors;
        synchronized (map) {
            monitor = this.monitors.computeIfAbsent(checkoutID, id -> new CDOCheckoutRefreshMonitor((String)id, result));
        }
        monitor.monitor(resource);
        return monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMonitors(IResource resource, IProgressMonitor progressMonitor) {
        String checkoutID = this.getCheckoutID(resource);
        if (checkoutID == null) {
            super.resetMonitors(resource, progressMonitor);
            return;
        }
        Map<String, CDOCheckoutRefreshMonitor> map = this.monitors;
        synchronized (map) {
            CDOCheckoutRefreshMonitor monitor = this.monitors.get(checkoutID);
            if (monitor != null) {
                monitor.unmonitor(resource);
                if (monitor.isIdle()) {
                    this.monitors.remove(checkoutID);
                    monitor.setCheckout(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEvent(IEvent event) {
        if (event instanceof CDOCheckoutManager.CheckoutStateEvent) {
            CDOCheckoutRefreshMonitor monitor;
            CDOCheckoutManager.CheckoutStateEvent e = (CDOCheckoutManager.CheckoutStateEvent)event;
            CDOCheckout checkout = e.getCheckout();
            Map<String, CDOCheckoutRefreshMonitor> map = this.monitors;
            synchronized (map) {
                monitor = this.monitors.get(checkout.getID());
            }
            if (monitor != null) {
                monitor.setCheckout(e.getNewState() == CDOCheckout.State.Open ? checkout : null);
            }
        } else if (event instanceof IContainerEvent) {
            IContainerEvent e = (IContainerEvent)event;
            e.accept((IContainerEventVisitor)new IContainerEventVisitor<CDOCheckout>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void added(CDOCheckout checkout) {
                    CDOCheckoutRefreshMonitor monitor;
                    Map map = CDOCheckoutRefreshProvider.this.monitors;
                    synchronized (map) {
                        monitor = (CDOCheckoutRefreshMonitor)CDOCheckoutRefreshProvider.this.monitors.get(checkout.getID());
                    }
                    if (monitor != null) {
                        monitor.setCheckout(checkout);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void removed(CDOCheckout checkout) {
                    CDOCheckoutRefreshMonitor monitor;
                    Map map = CDOCheckoutRefreshProvider.this.monitors;
                    synchronized (map) {
                        monitor = (CDOCheckoutRefreshMonitor)CDOCheckoutRefreshProvider.this.monitors.get(checkout.getID());
                    }
                    if (monitor != null) {
                        monitor.setCheckout(null);
                    }
                }
            });
        }
    }

    private String getCheckoutID(IResource resource) {
        if (!resource.exists()) {
            return null;
        }
        URI uri = resource.getLocationURI();
        if (uri == null || !"cdo.checkout".equals(uri.getScheme())) {
            return null;
        }
        return uri.getAuthority();
    }
}

