/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.enablement.ase.JDBCASEProfileMessages;
import org.osgi.framework.BundleContext;

public class JDBCASEPlugin
extends Plugin {
    private static final int INTERNAL_ERROR = 0;
    private static JDBCASEPlugin plugin;

    public JDBCASEPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static JDBCASEPlugin getDefault() {
        return plugin;
    }

    public static String makeDriverURL(String host, String port, String dbName) {
        String driverURL = "jdbc:sybase:Tds:" + host + ":" + port;
        if (dbName != null && dbName.trim().length() > 0) {
            driverURL = String.valueOf(driverURL) + "/" + dbName + "?ServiceName=" + dbName;
        }
        return driverURL;
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public void log(String message) {
        this.log(this.createErrorStatus(message));
    }

    public void log(Throwable e) {
        this.log(this.createErrorStatus(e));
    }

    public IStatus createErrorStatus(String message) {
        return new Status(4, this.getBundle().getSymbolicName(), 0, message, null);
    }

    public IStatus createErrorStatus(Throwable e) {
        return new Status(4, this.getBundle().getSymbolicName(), 0, JDBCASEProfileMessages.plugin_internal_error, e);
    }

    public IStatus createErrorStatus(String message, Throwable e) {
        return new Status(4, this.getBundle().getSymbolicName(), 0, message, e);
    }

    public void log(String message, Throwable e) {
        this.log(this.createErrorStatus(message, e));
    }
}

