/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.gdb.internal.ProcStatCoreLoads;
import org.eclipse.cdt.dsf.gdb.internal.ProcStatCounters;

public class ProcStatParser {
    private ProcStatCounters cpuCoreCounters;
    private ProcStatCounters cpuCoreCountersOld;

    public void parseStatFile(String fileName) throws FileNotFoundException, NumberFormatException {
        this.cpuCoreCountersOld = this.cpuCoreCounters;
        File statFile = new File(fileName);
        if (!statFile.exists()) {
            throw new FileNotFoundException();
        }
        this.cpuCoreCounters = new ProcStatCounters();
        BufferedReader reader = null;
        try {
            try {
                String line;
                InputStreamReader r = new InputStreamReader(new FileInputStream(statFile));
                reader = new BufferedReader(r);
                Pattern patternCpu = Pattern.compile("^(cpu[0-9]+)(.*)$");
                while ((line = reader.readLine()) != null) {
                    Matcher matcherCpu = patternCpu.matcher(line = line.trim());
                    if (!matcherCpu.find()) continue;
                    Vector<Integer> ticks = new Vector<Integer>();
                    String coreId = matcherCpu.group(1);
                    String[] stringArray = matcherCpu.group(2).trim().split("\\s+");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String tick = stringArray[n2];
                        ticks.add(Integer.parseInt(tick));
                        ++n2;
                    }
                    this.cpuCoreCounters.addTickCounters(coreId, ticks.toArray(new Integer[ticks.size()]));
                }
            }
            catch (IOException iOException) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                reader = null;
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            reader = null;
        }
    }

    public ProcStatCoreLoads getCpuLoad() {
        return this.cpuCoreCounters.computeLoads(this.cpuCoreCountersOld);
    }
}

