/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.docker.launcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.eclipse.cdt.internal.docker.launcher.BaseDatabindingModel;
import org.eclipse.core.runtime.Assert;

public class ExposedPortModel
extends BaseDatabindingModel
implements Comparable<ExposedPortModel> {
    private static final String SEPARATOR = ":";
    private static final String CONTAINER_TYPE_SEPARATOR = "/";
    public static final String SELECTED = "selected";
    public static final String CONTAINER_PORT = "containerPort";
    public static final String PORT_TYPE = "portType";
    public static final String HOST_ADDRESS = "hostAddress";
    public static final String HOST_PORT = "hostPort";
    private final String id = UUID.randomUUID().toString();
    private boolean selected;
    private String containerPort;
    private String portType;
    private String hostAddress;
    private String hostPort;

    public static List<ExposedPortModel> fromStrings(Collection<String> exposedPortInfos) {
        ArrayList<ExposedPortModel> exposedPorts = new ArrayList<ExposedPortModel>();
        for (String exposedPortInfo : exposedPortInfos) {
            ExposedPortModel exposedPort = ExposedPortModel.fromString(exposedPortInfo);
            if (exposedPort == null) continue;
            exposedPorts.add(exposedPort);
        }
        return exposedPorts;
    }

    public static List<String> toArrayString(Collection<ExposedPortModel> exposedPorts) {
        ArrayList<String> exposedPortList = new ArrayList<String>();
        for (ExposedPortModel exposedPort : exposedPorts) {
            if (exposedPort == null) continue;
            String exposedPortString = exposedPort.toString();
            exposedPortList.add(exposedPortString);
        }
        return exposedPortList;
    }

    public static ExposedPortModel fromString(String exposedPortInfo) {
        String privatePort = exposedPortInfo.substring(0, exposedPortInfo.indexOf(CONTAINER_TYPE_SEPARATOR));
        int firstColumnSeparator = exposedPortInfo.indexOf(SEPARATOR);
        if (firstColumnSeparator == -1 && exposedPortInfo.indexOf(CONTAINER_TYPE_SEPARATOR) != -1) {
            String type = exposedPortInfo.substring(exposedPortInfo.indexOf(CONTAINER_TYPE_SEPARATOR));
            ExposedPortModel exposedPort = new ExposedPortModel(privatePort, type, "", privatePort);
            return exposedPort;
        }
        int secondColumnSeparator = exposedPortInfo.indexOf(SEPARATOR, firstColumnSeparator + 1);
        String type = exposedPortInfo.substring(exposedPortInfo.indexOf(CONTAINER_TYPE_SEPARATOR), firstColumnSeparator);
        String hostIP = exposedPortInfo.substring(firstColumnSeparator + 1, secondColumnSeparator);
        String hostPort = exposedPortInfo.substring(secondColumnSeparator + 1);
        ExposedPortModel exposedPort = new ExposedPortModel(privatePort, type, hostIP, hostPort);
        return exposedPort;
    }

    public ExposedPortModel(String privatePort, String type, String hostAddress, String hostPort) {
        Assert.isNotNull((Object)privatePort, (String)"Port Mapping privatePort cannot be null");
        Assert.isNotNull((Object)type, (String)"Port Mapping portType cannot be null");
        this.containerPort = privatePort;
        this.hostPort = hostPort;
        this.portType = type;
        this.hostAddress = hostAddress;
    }

    public static ExposedPortModel createPortModel(String stringValue) {
        String[] elements = stringValue.split(SEPARATOR);
        String[] containerPortElements = elements[0].split(CONTAINER_TYPE_SEPARATOR);
        ExposedPortModel model = new ExposedPortModel(containerPortElements[0], containerPortElements[1], elements[1], elements[2]);
        model.selected = elements.length == 4 ? Boolean.valueOf(elements[3]) : true;
        return model;
    }

    public String getContainerPort() {
        return this.containerPort;
    }

    public void setContainerPort(String containerPort) {
        this.containerPort = containerPort;
        this.firePropertyChange(CONTAINER_PORT, this.containerPort, this.containerPort);
    }

    public String getPortType() {
        return this.portType;
    }

    public void setPortType(String type) {
        this.portType = type;
        this.firePropertyChange(PORT_TYPE, this.portType, this.portType);
    }

    public boolean getSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.firePropertyChange(SELECTED, this.selected, this.selected);
    }

    public String getHostPort() {
        return this.hostPort;
    }

    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
        this.firePropertyChange(HOST_PORT, this.hostPort, this.hostPort);
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
        this.firePropertyChange(HOST_ADDRESS, this.hostAddress, this.hostAddress);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExposedPortModel other = (ExposedPortModel)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public int compareTo(ExposedPortModel other) {
        return this.containerPort.compareTo(other.containerPort);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.containerPort + CONTAINER_TYPE_SEPARATOR + this.portType + SEPARATOR + (this.hostAddress != null ? this.hostAddress : "") + SEPARATOR + this.hostPort + SEPARATOR + this.selected);
        return buffer.toString();
    }
}

