/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.iterable;

import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.iterable.IterableObjectHelper;

public class Properties
extends ConcurrentHashMap<Object, Object> {
    private static final long serialVersionUID = -350748766178421942L;
    private Set<Listener> listeners;
    private String defaultValuesSeparator;

    public Properties() {
    }

    public Properties(Map<?, ?> defaults, String defaultValuesSeparator) {
        super(defaults);
        this.defaultValuesSeparator = defaultValuesSeparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Listener> getListeners() {
        if (this.listeners == null) {
            Properties properties = this;
            synchronized (properties) {
                if (this.listeners == null) {
                    this.listeners = Properties.newKeySet();
                }
            }
        }
        return this.listeners;
    }

    public Properties load(Supplier<InputStream> inputStreamSupplier) {
        StaticComponentContainer.Streams.feelPropertiesMap(inputStreamSupplier, this);
        return this;
    }

    public Properties load(InputStream inputStream) {
        StaticComponentContainer.Streams.feelPropertiesMap(inputStream, this);
        return this;
    }

    public String getDefaultValuesSeparator() {
        return this.defaultValuesSeparator != null ? this.defaultValuesSeparator : StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator();
    }

    public Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    public String getProperty(String key) {
        return (String)this.get(key);
    }

    public <T> T resolveValue(String key) {
        return StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(key).on(this)).withDefaultValueSeparator(this.defaultValuesSeparator));
    }

    public <T> Collection<T> resolveValues(String key) {
        return StaticComponentContainer.IterableObjectHelper.resolveValues((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(key).on(this)).withDefaultValueSeparator(this.defaultValuesSeparator));
    }

    public String resolveStringValue(String key) {
        return StaticComponentContainer.IterableObjectHelper.resolveStringValue((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(key).on(this)).withDefaultValueSeparator(this.defaultValuesSeparator));
    }

    public Collection<String> resolveStringValues(String key) {
        return StaticComponentContainer.IterableObjectHelper.resolveStringValues((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(key).on(this)).withDefaultValueSeparator(this.defaultValuesSeparator));
    }

    public <T> T resolveValue(String key, Map<?, ?> defaultValues) {
        return StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(key).on(this)).withDefaultValueSeparator(this.defaultValuesSeparator)).withDefaultValues(defaultValues));
    }

    public <T> Collection<T> resolveValues(String key, Map<?, ?> defaultValues) {
        return StaticComponentContainer.IterableObjectHelper.resolveValues((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(key).on(this)).withDefaultValueSeparator(this.defaultValuesSeparator)).withDefaultValues(defaultValues));
    }

    public String resolveStringValue(String key, Map<?, ?> defaultValues) {
        return StaticComponentContainer.IterableObjectHelper.resolveStringValue((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(key).on(this)).withDefaultValueSeparator(this.defaultValuesSeparator)).withDefaultValues(defaultValues));
    }

    public Collection<String> resolveStringValues(String key, Map<?, ?> defaultValues) {
        return StaticComponentContainer.IterableObjectHelper.resolveStringValues((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(key).on(this)).withDefaultValueSeparator(this.defaultValuesSeparator)).withDefaultValues(defaultValues));
    }

    public <T> T resolveValue(String key, String valuesSeparator) {
        return StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(key).on(this)).withValuesSeparator(valuesSeparator)).withDefaultValueSeparator(this.defaultValuesSeparator));
    }

    public <T> Collection<T> resolveValues(String key, String valuesSeparator) {
        return StaticComponentContainer.IterableObjectHelper.resolveValues((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(key).on(this)).withValuesSeparator(valuesSeparator)).withDefaultValueSeparator(this.defaultValuesSeparator));
    }

    public String resolveStringValue(String key, String valuesSeparator) {
        return StaticComponentContainer.IterableObjectHelper.resolveStringValue((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(key).on(this)).withValuesSeparator(valuesSeparator)).withDefaultValueSeparator(this.defaultValuesSeparator));
    }

    public Collection<String> resolveStringValues(String key, String valuesSeparator) {
        return StaticComponentContainer.IterableObjectHelper.resolveStringValues((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(key).on(this)).withValuesSeparator(valuesSeparator)).withDefaultValueSeparator(this.defaultValuesSeparator));
    }

    public <T> T resolveValue(String key, String valuesSeparator, boolean deleteUnresolvedPlaceHolder) {
        return StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(key).on(this)).withValuesSeparator(valuesSeparator)).withDefaultValueSeparator(this.defaultValuesSeparator)).deleteUnresolvedPlaceHolder(deleteUnresolvedPlaceHolder));
    }

    public <T> Collection<T> resolveValues(String key, String valuesSeparator, boolean deleteUnresolvedPlaceHolder) {
        return StaticComponentContainer.IterableObjectHelper.resolveValues((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(key).on(this)).withValuesSeparator(valuesSeparator)).withDefaultValueSeparator(this.defaultValuesSeparator)).deleteUnresolvedPlaceHolder(deleteUnresolvedPlaceHolder));
    }

    public String resolveStringValue(String key, String valuesSeparator, boolean deleteUnresolvedPlaceHolder) {
        return StaticComponentContainer.IterableObjectHelper.resolveStringValue((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(key).on(this)).withValuesSeparator(valuesSeparator)).withDefaultValueSeparator(this.defaultValuesSeparator)).deleteUnresolvedPlaceHolder(deleteUnresolvedPlaceHolder));
    }

    public Collection<String> resolveStringValues(String key, String valuesSeparator, boolean deleteUnresolvedPlaceHolder) {
        return StaticComponentContainer.IterableObjectHelper.resolveStringValues((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(key).on(this)).withValuesSeparator(valuesSeparator)).withDefaultValueSeparator(this.defaultValuesSeparator)).deleteUnresolvedPlaceHolder(deleteUnresolvedPlaceHolder));
    }

    public Collection<String> getAllPlaceHolders(String propertyName) {
        return StaticComponentContainer.IterableObjectHelper.getAllPlaceHolders(this, propertyName);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        Object oldValue = null;
        oldValue = value != null ? super.put(key, value) : (Object)super.remove(key);
        this.notifyChange(Event.PUT, key, value, oldValue);
        return oldValue;
    }

    @Override
    public synchronized Object remove(Object key) {
        Object removed = super.remove(key);
        this.notifyChange(Event.REMOVE, key, null, removed);
        return removed;
    }

    public Map<Object, Object> toMap(Supplier<Map<Object, Object>> mapSupplier) {
        Map<Object, Object> allValues = mapSupplier.get();
        allValues.putAll(this);
        return allValues;
    }

    public String toSimplePrettyString() {
        return this.toSimplePrettyString(0);
    }

    public String toSimplePrettyString(int marginTabCount) {
        return StaticComponentContainer.IterableObjectHelper.toString(this.toMap(TreeMap::new), marginTabCount);
    }

    public String toPrettyString() {
        return this.toPrettyString(0);
    }

    public String toPrettyString(int marginTabCount) {
        return StaticComponentContainer.IterableObjectHelper.toPrettyString(this.toMap(TreeMap::new), this.getDefaultValuesSeparator(), marginTabCount);
    }

    private void notifyChange(Event event, Object key, Object newValue, Object oldValue) {
        for (Listener listener : this.getListeners()) {
            try {
                listener.processChangeNotification(this, event, key, newValue, oldValue);
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, "Exception occurred while notifying: " + event.name() + " -> (" + key + " - " + newValue + ") to " + listener, exc);
            }
        }
    }

    public static enum Event {
        PUT,
        REMOVE;

    }

    public static interface Listener {
        default public <L extends Listener> L listenTo(Properties properties) {
            properties.getListeners().add(this);
            return (L)this;
        }

        default public <L extends Listener> L unregister(Properties properties) {
            properties.getListeners().remove(this);
            return (L)this;
        }

        default public <L extends Listener> L checkAndListenTo(Map<?, ?> map) {
            if (map instanceof Properties) {
                this.listenTo((Properties)map);
                return (L)this;
            }
            return null;
        }

        default public <L extends Listener> L checkAndUnregister(Map<?, ?> map) {
            if (map instanceof Properties) {
                this.unregister((Properties)map);
                return (L)this;
            }
            return null;
        }

        default public <K, V> void processChangeNotification(Properties properties, Event event, K key, V newValue, V previousValue) {
        }
    }
}

