/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.concurrent;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.burningwave.core.Closeable;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.concurrent.QueuedTaskExecutor;
import org.burningwave.core.concurrent.Thread;

public class TasksMonitorer
implements Closeable {
    Map<QueuedTaskExecutor.TaskAbst<?, ?>, StackTraceElement[]> waitingTasksAndLastStackTrace = new HashMap();
    QueuedTaskExecutor.Group queuedTasksExecutorGroup;
    Config config;

    TasksMonitorer(QueuedTaskExecutor.Group queuedTasksExecutorGroup, Config config) {
        this.queuedTasksExecutorGroup = queuedTasksExecutorGroup;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkAndHandleProbableDeadLockedTasks(long minimumElapsedTimeToConsiderATaskAsProbablyDeadLocked, boolean markAsProbableDeadLocked, Consumer<QueuedTaskExecutor.TaskAbst<?, ?>> terminateProbableDeadLockedTasksFunction) {
        Iterator<Map.Entry<QueuedTaskExecutor.TaskAbst<?, ?>, StackTraceElement[]>> tasksAndStackTracesIterator = this.waitingTasksAndLastStackTrace.entrySet().iterator();
        while (tasksAndStackTracesIterator.hasNext()) {
            QueuedTaskExecutor.TaskAbst<?, ?> task = tasksAndStackTracesIterator.next().getKey();
            if (!task.hasFinished()) continue;
            tasksAndStackTracesIterator.remove();
        }
        long currentTime = System.currentTimeMillis();
        for (QueuedTaskExecutor.TaskAbst<?, ?> task : this.queuedTasksExecutorGroup.getAllTasksInExecution()) {
            if (currentTime - task.startTime <= minimumElapsedTimeToConsiderATaskAsProbablyDeadLocked) continue;
            Thread taskThread = task.executor;
            Thread.State threadState = Optional.ofNullable(taskThread).map(java.lang.Thread::getState).orElseGet(() -> null);
            if (taskThread == null || !Thread.State.BLOCKED.equals((Object)threadState) && !Thread.State.WAITING.equals((Object)threadState) && !Thread.State.TIMED_WAITING.equals((Object)threadState)) continue;
            StackTraceElement[] previousRegisteredStackTrace = this.waitingTasksAndLastStackTrace.get(task);
            StackTraceElement[] currentStackTrace = taskThread.getStackTrace();
            if (previousRegisteredStackTrace != null) {
                if (this.areStrackTracesEquals(previousRegisteredStackTrace, currentStackTrace)) {
                    if (task.hasFinished()) continue;
                    StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Possible deadlock detected for task:{}", task.getInfoAsString());
                    if (markAsProbableDeadLocked) {
                        task.markAsProbablyDeadLocked();
                    }
                    if (terminateProbableDeadLockedTasksFunction != null && !task.hasFinished()) {
                        StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Trying to terminate task {}", task.hashCode());
                        terminateProbableDeadLockedTasksFunction.accept(task);
                    }
                    if (markAsProbableDeadLocked) {
                        task.clear();
                        QueuedTaskExecutor.TaskAbst<?, ?> taskAbst = task;
                        synchronized (taskAbst) {
                            task.notifyAll();
                        }
                    }
                    StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, StaticComponentContainer.Synchronizer.getAllThreadsInfoAsString(true));
                    StaticComponentContainer.Synchronizer.logAllThreadsState(true);
                    continue;
                }
                this.waitingTasksAndLastStackTrace.put(task, currentStackTrace);
                continue;
            }
            this.waitingTasksAndLastStackTrace.put(task, currentStackTrace);
        }
    }

    private boolean areStrackTracesEquals(StackTraceElement[] stackTraceOne, StackTraceElement[] stackTraceTwo) {
        if (stackTraceOne.length == stackTraceTwo.length) {
            for (int i = 0; i < stackTraceOne.length; ++i) {
                if (stackTraceOne[i].toString().equals(stackTraceTwo[i].toString())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private String getName() {
        return Optional.ofNullable(this.queuedTasksExecutorGroup.name).map(nm -> nm + " - ").orElseGet(() -> "") + "All tasks monitorer";
    }

    public TasksMonitorer start() {
        StaticComponentContainer.ManagedLoggerRepository.logInfo(() -> this.getClass().getName(), "Starting {}", this.getName());
        StaticComponentContainer.ThreadHolder.startLooping(this.getName(), true, 1, thread -> {
            Thread.waitFor(this.config.getInterval());
            if (thread.isLooping()) {
                if (this.config.isAllTasksLoggerEnabled()) {
                    this.queuedTasksExecutorGroup.logInfo();
                }
                try {
                    this.checkAndHandleProbableDeadLockedTasks(this.config.getMinimumElapsedTimeToConsiderATaskAsProbablyDeadLocked(), this.config.isMarkAsProablyDeadLockedEnabled(), this.config.getTerminateProablyDeadLockedTasksFunction());
                }
                catch (Throwable exc) {
                    StaticComponentContainer.ManagedLoggerRepository.logError(() -> this.getClass().getName(), "Exception occurred while checking dead locked tasks", exc);
                }
            }
        });
        return this;
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean waitThreadToFinish) {
        StaticComponentContainer.ManagedLoggerRepository.logInfo(() -> this.getClass().getName(), "Starting {}", this.getName());
        StaticComponentContainer.ThreadHolder.stop(this.getName());
    }

    @Override
    public void close() {
        this.close(false);
    }

    public void close(boolean waitForTasksTermination) {
        this.stop(waitForTasksTermination);
        this.queuedTasksExecutorGroup = null;
        this.waitingTasksAndLastStackTrace.clear();
        this.waitingTasksAndLastStackTrace = null;
    }

    public static class Config {
        private long interval;
        private long minimumElapsedTimeToConsiderATaskAsProbablyDeadLocked;
        private boolean markAsProbableDeadLocked;
        private Consumer<QueuedTaskExecutor.TaskAbst<?, ?>> terminateProbableDeadLockedTasksFunction;
        private boolean allTasksLoggerEnabled;

        public long getInterval() {
            return this.interval;
        }

        public Config setInterval(long interval) {
            this.interval = interval;
            return this;
        }

        public long getMinimumElapsedTimeToConsiderATaskAsProbablyDeadLocked() {
            return this.minimumElapsedTimeToConsiderATaskAsProbablyDeadLocked;
        }

        public Config setMinimumElapsedTimeToConsiderATaskAsProbablyDeadLocked(long minimumElapsedTimeToConsiderATaskAsProbablyDeadLocked) {
            this.minimumElapsedTimeToConsiderATaskAsProbablyDeadLocked = minimumElapsedTimeToConsiderATaskAsProbablyDeadLocked;
            return this;
        }

        public boolean isMarkAsProablyDeadLockedEnabled() {
            return this.markAsProbableDeadLocked;
        }

        public Config setMarkAsProbableDeadLocked(String policy) {
            this.markAsProbableDeadLocked = policy.toLowerCase().contains("mark as probable dead locked");
            return this;
        }

        public boolean isTerminateProablyDeadLockedTasksEnabled() {
            return this.terminateProbableDeadLockedTasksFunction != null;
        }

        public Consumer<QueuedTaskExecutor.TaskAbst<?, ?>> getTerminateProablyDeadLockedTasksFunction() {
            return this.terminateProbableDeadLockedTasksFunction;
        }

        public Config setTerminateProbableDeadLockedTasksOperation(String policy) {
            this.terminateProbableDeadLockedTasksFunction = policy.toLowerCase().contains("interrupt") ? QueuedTaskExecutor.TaskAbst::interrupt : (policy.toLowerCase().contains("kill") ? QueuedTaskExecutor.TaskAbst::kill : null);
            return this;
        }

        public boolean isAllTasksLoggerEnabled() {
            return this.allTasksLoggerEnabled;
        }

        public Config setAllTasksLoggerEnabled(boolean allTasksLoggerEnabled) {
            this.allTasksLoggerEnabled = allTasksLoggerEnabled;
            return this;
        }
    }
}

