/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.AnnotationBasedArgumentsProvider;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.NullEnum;
import org.junit.jupiter.params.support.ParameterDeclaration;
import org.junit.jupiter.params.support.ParameterDeclarations;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;

class EnumArgumentsProvider
extends AnnotationBasedArgumentsProvider<EnumSource> {
    EnumArgumentsProvider() {
    }

    @Override
    protected Stream<? extends Arguments> provideArguments(ParameterDeclarations parameters, ExtensionContext context, EnumSource enumSource) {
        Set<Enum> constants = this.getEnumConstants(parameters, enumSource);
        EnumSource.Mode mode = enumSource.mode();
        String[] declaredConstantNames = enumSource.names();
        if (declaredConstantNames.length > 0) {
            Set<String> uniqueNames = Arrays.stream(declaredConstantNames).collect(Collectors.toSet());
            Preconditions.condition((uniqueNames.size() == declaredConstantNames.length ? 1 : 0) != 0, () -> "Duplicate enum constant name(s) found in " + String.valueOf(enumSource));
            mode.validate(enumSource, constants, uniqueNames);
            constants.removeIf(constant -> !mode.select((Enum<?>)constant, uniqueNames));
        }
        return constants.stream().map(xva$0 -> Arguments.of(xva$0));
    }

    private <E extends Enum<E>> Set<? extends E> getEnumConstants(ParameterDeclarations parameters, EnumSource enumSource) {
        Class<E> enumClass = this.determineEnumClass(parameters, enumSource);
        Enum[] constants = (Enum[])enumClass.getEnumConstants();
        if (constants.length == 0) {
            Preconditions.condition((enumSource.from().isEmpty() && enumSource.to().isEmpty() ? 1 : 0) != 0, (String)("No enum constant in " + enumClass.getSimpleName() + ", but 'from' or 'to' is not empty."));
            return EnumSet.noneOf(enumClass);
        }
        Enum from = enumSource.from().isEmpty() ? constants[0] : Enum.valueOf(enumClass, enumSource.from());
        Object to = enumSource.to().isEmpty() ? constants[constants.length - 1] : Enum.valueOf(enumClass, enumSource.to());
        Preconditions.condition((from.compareTo(to) <= 0 ? 1 : 0) != 0, () -> "Invalid enum range: 'from' (%s) must come before 'to' (%s) in the natural order of enum constants.".formatted(from, to));
        return EnumSet.range(from, to);
    }

    private <E extends Enum<E>> Class<E> determineEnumClass(ParameterDeclarations parameters, EnumSource enumSource) {
        Class enumClass = enumSource.value();
        if (enumClass.equals(NullEnum.class)) {
            enumClass = parameters.getFirst().map(ParameterDeclaration::getParameterType).map(parameterType -> {
                Preconditions.condition((boolean)Enum.class.isAssignableFrom((Class<?>)parameterType), () -> "First parameter must reference an Enum type (alternatively, use the annotation's 'value' attribute to specify the type explicitly): " + parameters.getSourceElementDescription());
                return parameterType;
            }).orElseThrow(() -> new PreconditionViolationException("There must be at least one declared parameter for " + parameters.getSourceElementDescription()));
        }
        return enumClass;
    }
}

