/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.catalog.GetDeclaredMethodsFunction;
import io.github.toolfactory.jvm.function.template.ThrowingTriFunction;
import io.github.toolfactory.jvm.util.ObjectProvider;
import io.github.toolfactory.jvm.util.Strings;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;

public interface GetDeclaredMethodFunction
extends ThrowingTriFunction<Class<?>, String, Class<?>[], Method, Throwable> {

    public static class ForJava7
    implements GetDeclaredMethodFunction {
        protected GetDeclaredMethodsFunction getDeclaredMethodsFunction;

        public ForJava7(Map<Object, Object> context) {
            ObjectProvider functionProvider = ObjectProvider.get(context);
            this.getDeclaredMethodsFunction = functionProvider.getOrBuildObject(GetDeclaredMethodsFunction.class, context);
        }

        @Override
        public Method apply(Class<?> cls, String name, Class<?>[] paramTypes) throws Throwable {
            if (paramTypes == null) {
                paramTypes = new Class[]{};
            }
            for (Method method : (Method[])this.getDeclaredMethodsFunction.apply(cls)) {
                if (!method.getName().equals(name) || paramTypes.length != method.getParameterTypes().length) continue;
                Method toRet = method;
                Class<?>[] parameterTypes = method.getParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (parameterTypes[i].equals(paramTypes[i])) continue;
                    toRet = null;
                    break;
                }
                if (toRet == null) continue;
                return toRet;
            }
            ArrayList<String> classNames = new ArrayList<String>();
            for (Class<?> paramType : paramTypes) {
                classNames.add(paramType.getName());
            }
            throw new NoSuchMethodException(Strings.compile("Method {}({}) not found in the class {}", name, Strings.join(", ", classNames), cls.getName()));
        }
    }
}

