/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.stream.Stream;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.TypeCache;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.auxiliary.AuxiliaryType;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.assertj.core.api.AbstractBigDecimalAssert;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.api.AbstractMapAssert;
import org.assertj.core.api.Assert;
import org.assertj.core.api.AssertJProxySetup;
import org.assertj.core.api.AssertionErrorCollector;
import org.assertj.core.api.BigDecimalScaleAssert;
import org.assertj.core.api.ClassLoadingStrategyFactory;
import org.assertj.core.api.ErrorCollector;
import org.assertj.core.api.FileSizeAssert;
import org.assertj.core.api.IterableSizeAssert;
import org.assertj.core.api.MapSizeAssert;
import org.assertj.core.api.ProxifyMethodChangingTheObjectUnderTest;
import org.assertj.core.api.RecursiveComparisonAssert;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;

class SoftProxies {
    private static final ElementMatcher.Junction<MethodDescription> METHODS_CHANGING_THE_OBJECT_UNDER_TEST = SoftProxies.methodsChangingTheObjectUnderTestNamed("asBase64Decoded", "asBase64Encoded", "asBoolean", "asByte", "asDouble", "asFloat", "asInstanceOf", "asInt", "asLong", "asShort", "asString", "asHexString", "binaryContent", "cause", "content", "extracting", "extractingByKey", "extractingByKeys", "extractingFromEntries", "extractingResultOf", "filteredOn", "filteredOnAssertions", "filteredOnNull", "flatExtracting", "flatMap", "get", "getCause", "getRootCause", "map", "message", "newAbstractIterableAssert", "rootCause", "scale", "size", "succeedsWithin", "toAssert", "usingRecursiveComparison");
    static final ElementMatcher.Junction<MethodDescription> METHODS_NOT_TO_PROXY = SoftProxies.methodsNamed("as").or((ElementMatcher)ElementMatchers.named((String)"clone")).or((ElementMatcher)ElementMatchers.named((String)"describedAs")).or((ElementMatcher)ElementMatchers.named((String)"descriptionText")).or((ElementMatcher)ElementMatchers.named((String)"getWritableAssertionInfo")).or((ElementMatcher)ElementMatchers.named((String)"inBinary")).or((ElementMatcher)ElementMatchers.named((String)"inHexadecimal")).or((ElementMatcher)ElementMatchers.named((String)"newAbstractIterableAssert")).or((ElementMatcher)ElementMatchers.named((String)"newObjectArrayAssert")).or((ElementMatcher)ElementMatchers.named((String)"overridingErrorMessage")).or((ElementMatcher)ElementMatchers.named((String)"removeCustomAssertRelatedElementsFromStackTraceIfNeeded")).or((ElementMatcher)ElementMatchers.named((String)"succeedsWithin")).or((ElementMatcher)ElementMatchers.named((String)"failsWithin")).or((ElementMatcher)ElementMatchers.named((String)"usingComparator")).or((ElementMatcher)ElementMatchers.named((String)"usingDefaultComparator")).or((ElementMatcher)ElementMatchers.named((String)"usingElementComparator")).or((ElementMatcher)ElementMatchers.named((String)"withAssertionInfo")).or((ElementMatcher)ElementMatchers.named((String)"withAssertionState")).or((ElementMatcher)ElementMatchers.named((String)"withComparatorsForElementPropertyOrFieldNames")).or((ElementMatcher)ElementMatchers.named((String)"withComparatorsForElementPropertyOrFieldTypes")).or((ElementMatcher)ElementMatchers.named((String)"withFailMessage")).or((ElementMatcher)ElementMatchers.named((String)"withIterables")).or((ElementMatcher)ElementMatchers.named((String)"withRepresentation")).or((ElementMatcher)ElementMatchers.named((String)"withThreadDumpOnError")).or((ElementMatcher)ElementMatchers.named((String)"withTypeComparators"));
    private static final ByteBuddy BYTE_BUDDY = new ByteBuddy().with((AuxiliaryType.NamingStrategy)new AuxiliaryType.NamingStrategy.SuffixingRandom("AssertJ$SoftProxies")).with(TypeValidation.DISABLED);
    private static final Implementation PROXIFY_METHOD_CHANGING_THE_OBJECT_UNDER_TEST = MethodDelegation.to(ProxifyMethodChangingTheObjectUnderTest.class);
    private static final Implementation ERROR_COLLECTOR = MethodDelegation.to(ErrorCollector.class);
    private static final TypeCache<TypeCache.SimpleKey> CACHE = new TypeCache.WithInlineExpunction(TypeCache.Sort.SOFT);
    private ErrorCollector collector;

    public SoftProxies(AssertionErrorCollector assertionErrorCollector) {
        this.collector = new ErrorCollector(assertionErrorCollector);
    }

    <SELF extends Assert<? extends SELF, ? extends ACTUAL>, ACTUAL> SELF createSoftAssertionProxy(Class<SELF> assertClass, Class<ACTUAL> actualClass, ACTUAL actual) {
        try {
            Class<SELF> proxyClass = SoftProxies.createSoftAssertionProxyClass(assertClass);
            Constructor<SELF> constructor = proxyClass.getConstructor(actualClass);
            Assert proxiedAssert = (Assert)constructor.newInstance(actual);
            ((AssertJProxySetup)((Object)proxiedAssert)).assertj$setup(new ProxifyMethodChangingTheObjectUnderTest(this), this.collector);
            return (SELF)proxiedAssert;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static <ASSERT extends Assert<?, ?>> Class<ASSERT> createSoftAssertionProxyClass(Class<ASSERT> assertClass) {
        TypeCache.SimpleKey cacheKey = new TypeCache.SimpleKey(assertClass, new Class[0]);
        return CACHE.findOrInsert(assertClass.getClassLoader(), (Object)cacheKey, () -> SoftProxies.generateProxyClass(assertClass));
    }

    FileSizeAssert<?> createFileSizeAssertProxy(FileSizeAssert<?> fileSizeAssert) {
        Class<FileSizeAssert> proxyClass = SoftProxies.createSoftAssertionProxyClass(FileSizeAssert.class);
        try {
            Constructor<FileSizeAssert> constructor = proxyClass.getConstructor(AbstractFileAssert.class);
            FileSizeAssert proxiedAssert = constructor.newInstance(fileSizeAssert.returnToFile());
            ((AssertJProxySetup)((Object)proxiedAssert)).assertj$setup(new ProxifyMethodChangingTheObjectUnderTest(this), this.collector);
            return proxiedAssert;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    BigDecimalScaleAssert<?> createBigDecimalScaleAssertProxy(BigDecimalScaleAssert<?> bigDecimalScaleAssert) {
        Class<BigDecimalScaleAssert> proxyClass = SoftProxies.createSoftAssertionProxyClass(BigDecimalScaleAssert.class);
        try {
            Constructor<BigDecimalScaleAssert> constructor = proxyClass.getConstructor(AbstractBigDecimalAssert.class);
            BigDecimalScaleAssert proxiedAssert = constructor.newInstance(bigDecimalScaleAssert.returnToBigDecimal());
            ((AssertJProxySetup)((Object)proxiedAssert)).assertj$setup(new ProxifyMethodChangingTheObjectUnderTest(this), this.collector);
            return proxiedAssert;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    IterableSizeAssert<?> createIterableSizeAssertProxy(IterableSizeAssert<?> iterableSizeAssert) {
        Class<IterableSizeAssert> proxyClass = SoftProxies.createSoftAssertionProxyClass(IterableSizeAssert.class);
        try {
            Constructor<IterableSizeAssert> constructor = proxyClass.getConstructor(AbstractIterableAssert.class, Integer.class);
            IterableSizeAssert proxiedAssert = constructor.newInstance(iterableSizeAssert.returnToIterable(), iterableSizeAssert.actual);
            ((AssertJProxySetup)((Object)proxiedAssert)).assertj$setup(new ProxifyMethodChangingTheObjectUnderTest(this), this.collector);
            return proxiedAssert;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    MapSizeAssert<?, ?> createMapSizeAssertProxy(MapSizeAssert<?, ?> mapSizeAssert) {
        Class<MapSizeAssert> proxyClass = SoftProxies.createSoftAssertionProxyClass(MapSizeAssert.class);
        try {
            Constructor<MapSizeAssert> constructor = proxyClass.getConstructor(AbstractMapAssert.class, Integer.class);
            MapSizeAssert proxiedAssert = constructor.newInstance(mapSizeAssert.returnToMap(), mapSizeAssert.actual);
            ((AssertJProxySetup)((Object)proxiedAssert)).assertj$setup(new ProxifyMethodChangingTheObjectUnderTest(this), this.collector);
            return proxiedAssert;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    RecursiveComparisonAssert<?> createRecursiveComparisonAssertProxy(RecursiveComparisonAssert<?> recursiveComparisonAssert) {
        Class<RecursiveComparisonAssert> proxyClass = SoftProxies.createSoftAssertionProxyClass(RecursiveComparisonAssert.class);
        try {
            Constructor<RecursiveComparisonAssert> constructor = proxyClass.getConstructor(Object.class, RecursiveComparisonConfiguration.class);
            RecursiveComparisonAssert proxiedAssert = constructor.newInstance(recursiveComparisonAssert.actual, recursiveComparisonAssert.getRecursiveComparisonConfiguration());
            ((AssertJProxySetup)((Object)proxiedAssert)).assertj$setup(new ProxifyMethodChangingTheObjectUnderTest(this), this.collector);
            return proxiedAssert;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static <V> Class<? extends V> generateProxyClass(Class<V> assertClass) {
        ClassLoadingStrategyFactory.ClassLoadingStrategyPair strategy = ClassLoadingStrategyFactory.classLoadingStrategy(assertClass);
        return BYTE_BUDDY.subclass(assertClass).defineField("dispatcher", ProxifyMethodChangingTheObjectUnderTest.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).method(METHODS_CHANGING_THE_OBJECT_UNDER_TEST).intercept(PROXIFY_METHOD_CHANGING_THE_OBJECT_UNDER_TEST).defineField("errorCollector", ErrorCollector.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).method((ElementMatcher)ElementMatchers.any().and((ElementMatcher)ElementMatchers.not(METHODS_CHANGING_THE_OBJECT_UNDER_TEST)).and((ElementMatcher)ElementMatchers.not(METHODS_NOT_TO_PROXY))).intercept(ERROR_COLLECTOR).implement(new Type[]{AssertJProxySetup.class}).intercept((Implementation)FieldAccessor.ofField((String)"dispatcher").setsArgumentAt(0).andThen(FieldAccessor.ofField((String)"errorCollector").setsArgumentAt(1))).make().load(strategy.getClassLoader(), strategy.getClassLoadingStrategy()).getLoaded();
    }

    private static ElementMatcher.Junction<MethodDescription> methodsNamed(String ... names) {
        return ElementMatchers.namedOneOf((String[])names);
    }

    private static ElementMatcher.Junction<MethodDescription> methodsChangingTheObjectUnderTestNamed(String ... names) {
        ElementMatcher.Junction publicMethods = ElementMatchers.namedOneOf((String[])names).and((ElementMatcher)ElementMatchers.isPublic());
        String[] forProxyMethodNames = (String[])Stream.of(names).map(name -> name + "ForProxy").toArray(String[]::new);
        ElementMatcher.Junction forProxyProtectedMethods = ElementMatchers.namedOneOf((String[])forProxyMethodNames).and((ElementMatcher)ElementMatchers.isProtected());
        return publicMethods.or((ElementMatcher)forProxyProtectedMethods);
    }
}

