/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wildwebdeveloper.SchemaAssociation;
import org.eclipse.wildwebdeveloper.SchemaAssociationsMessages;

public class SchemaAssociationDialog
extends TitleAreaDialog {
    private static final String JSON_BASE_TYPE = "org.eclipse.wildwebdeveloper.json";
    private static final String YAML_BASE_TYPE = "org.eclipse.wildwebdeveloper.yaml";
    private Combo contentTypeData;
    private Text schemaLocationData;
    private Button okButton;
    private SchemaAssociation preSelectedAssociation;
    private Set<SchemaAssociation> existingAssociations;
    private SchemaAssociation currentAssociation;

    public SchemaAssociationDialog(Shell parentShell, Set<SchemaAssociation> existingAssociations) {
        super(parentShell);
        this.existingAssociations = existingAssociations;
    }

    public SchemaAssociationDialog(Shell parentShell, Set<SchemaAssociation> existingAssociations, SchemaAssociation preSelectedAssociation) {
        this(parentShell, existingAssociations);
        this.preSelectedAssociation = preSelectedAssociation;
    }

    public void create() {
        super.create();
        if (this.preSelectedAssociation == null) {
            this.setTitle(SchemaAssociationsMessages.SchemaAssociationDialog_Add_title);
            this.setMessage(SchemaAssociationsMessages.SchemaAssociationDialog_Add_subtitle);
        } else {
            this.setTitle(SchemaAssociationsMessages.SchemaAssociationDialog_Edit_title);
            this.setMessage(SchemaAssociationsMessages.SchemaAssociationDialog_Edit_subtitle);
        }
        this.validateDialog();
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentArea = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(parentArea, 4);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        container.setLayout((Layout)layout);
        this.createContentTypeEditor(container);
        this.createSchemaLocationEditor(container);
        return parentArea;
    }

    private void createContentTypeEditor(Composite container) {
        Label contentTypeLabel = new Label(container, 0);
        contentTypeLabel.setText(SchemaAssociationsMessages.ContentType + ":");
        contentTypeLabel.setToolTipText(SchemaAssociationsMessages.ContentTypeId_Tooltip);
        this.contentTypeData = new Combo(container, 2052);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fillContentTypeCombo(this.contentTypeData);
        this.contentTypeData.setLayoutData((Object)gridData);
        if (this.preSelectedAssociation == null) {
            this.contentTypeData.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SchemaAssociationDialog.this.validateDialog();
                }
            });
        } else {
            this.contentTypeData.setText(this.getTextFromSchemaAssociation(this.preSelectedAssociation));
            this.contentTypeData.setEnabled(false);
        }
    }

    private void fillContentTypeCombo(Combo combo) {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType[] iContentTypeArray = contentTypeManager.getAllContentTypes();
        int n = iContentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            if (contentType.getBaseType() != null && (contentType.getBaseType().getId().equals(JSON_BASE_TYPE) || contentType.getBaseType().getId().equals(YAML_BASE_TYPE))) {
                combo.add(this.getTextFromContentType(contentType));
            }
            ++n2;
        }
        Object[] items = combo.getItems();
        Arrays.sort(items);
        combo.setItems((String[])items);
    }

    private void createSchemaLocationEditor(Composite container) {
        Label schemaLocationLabel = new Label(container, 0);
        schemaLocationLabel.setText(SchemaAssociationsMessages.SchemaLocation + ":");
        schemaLocationLabel.setToolTipText(SchemaAssociationsMessages.SchemaLocation_Tooltip);
        this.schemaLocationData = new Text(container, 2052);
        GridData gridData = new GridData(768);
        this.schemaLocationData.setLayoutData((Object)gridData);
        if (this.preSelectedAssociation != null) {
            this.schemaLocationData.setText(this.preSelectedAssociation.getSchemaLocation());
        }
        this.schemaLocationData.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SchemaAssociationDialog.this.validateDialog();
            }
        });
        Button browseButton = new Button(container, 8);
        browseButton.setText(SchemaAssociationsMessages.Browse);
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(SchemaAssociationDialog.this.getShell(), 4);
                dialog.setFilterPath(System.getProperty("user.home"));
                String result = dialog.open();
                if (result == null || result.trim().length() == 0) {
                    return;
                }
                try {
                    SchemaAssociationDialog.this.schemaLocationData.setText("file://" + new File(result).getAbsolutePath());
                }
                catch (NullPointerException e) {
                    return;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateDialog() {
        Object schemaLocation;
        this.currentAssociation = null;
        if (this.contentTypeData.getText().trim().length() <= 0) {
            this.setErrorMessage(SchemaAssociationsMessages.SchemaAssociationDialog_Error_ContentType_required);
            return this.updateOkButton(false);
        }
        Set<SchemaAssociation> list = this.existingAssociations;
        for (SchemaAssociation e : list) {
            if (e.equals(this.preSelectedAssociation) || !this.getContentTypeIdFromText().equals(e.getContentTypeId())) continue;
            this.setErrorMessage(SchemaAssociationsMessages.SchemaAssociationDialog_Error_ContentType_already_exists);
            return this.updateOkButton(false);
        }
        if (this.schemaLocationData.getText().trim().length() <= 0) {
            this.setErrorMessage(SchemaAssociationsMessages.SchemaAssociationDialog_Error_SchemaLocation_required);
            return this.updateOkButton(false);
        }
        try {
            URL locationURL = new URL(this.schemaLocationData.getText());
            if (locationURL.getProtocol().equals("file")) {
                File file = new File(locationURL.getPath());
                if (!file.exists()) {
                    this.setErrorMessage(SchemaAssociationsMessages.SchemaAssociationDialog_Error_SchemaLocation_invalid);
                    return this.updateOkButton(false);
                }
                schemaLocation = "file://" + file.getAbsolutePath();
            } else {
                schemaLocation = locationURL.toURI().toString();
            }
        }
        catch (NullPointerException | MalformedURLException | URISyntaxException e) {
            this.setErrorMessage(SchemaAssociationsMessages.SchemaAssociationDialog_Error_SchemaLocation_invalid);
            return this.updateOkButton(false);
        }
        this.currentAssociation = new SchemaAssociation(this.getContentTypeFromText(), this.getContentTypeIdFromText(), (String)schemaLocation);
        this.setErrorMessage(null);
        return this.updateOkButton(true);
    }

    private boolean updateOkButton(boolean enabled) {
        if (this.okButton != null) {
            this.okButton.setEnabled(enabled);
            return true;
        }
        return false;
    }

    private String getTextFromSchemaAssociation(SchemaAssociation schemaAssociation) {
        return schemaAssociation.getContentTypeId() + " (" + schemaAssociation.getContentType() + ")";
    }

    private String getTextFromContentType(IContentType contentType) {
        return contentType.getId() + " (" + contentType.getName() + ")";
    }

    private String getContentTypeIdFromText() {
        return this.contentTypeData.getText().split(" ")[0];
    }

    private String getContentTypeFromText() {
        return this.contentTypeData.getText().split("[\\(\\)]")[1];
    }

    public String getContentType() {
        return this.currentAssociation.getContentType();
    }

    public String getContentTypeId() {
        return this.currentAssociation.getContentTypeId();
    }

    public String getSchemaLocation() {
        return this.currentAssociation.getSchemaLocation();
    }
}

