/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.db.evolution.phased;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.evolution.phased.Context;
import org.eclipse.emf.cdo.server.db.evolution.phased.PhasedModelEvolutionSupport;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.DBStoreTables;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBRowHandler;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.util.factory.AnnotationFactory;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

public class FolderContextManager
extends Lifecycle
implements Context.Manager {
    public static final String FACTORY_TYPE = "folder";
    private static final String EVOLUTION_PROPERTIES_FILE = "evolution.properties";
    private static final String PROP_MODEL_PREFIX = "model.";
    private PhasedModelEvolutionSupport support;
    private boolean saveNewModels;

    @Override
    public PhasedModelEvolutionSupport getSupport() {
        return this.support;
    }

    @Override
    public void setSupport(PhasedModelEvolutionSupport support) {
        this.support = support;
    }

    public boolean isSaveNewModels() {
        return this.saveNewModels;
    }

    @AnnotationFactory.InjectAttribute(name="saveNewModels")
    public void setSaveNewModels(boolean saveNewModels) {
        this.checkInactive();
        this.saveNewModels = saveNewModels;
    }

    @Override
    public Context createContext() throws Exception {
        List<Context.Model> models = this.loadModelsFromDatabase(this.support.getStore());
        return new Context(this.support, models);
    }

    @Override
    public Context loadContext() throws Exception {
        File folder = this.support.getEvolutionFolder();
        if (folder == null || !folder.isDirectory()) {
            throw new IllegalStateException("Evolution folder not found for evolution ID " + this.support.getEvolutionID());
        }
        List<Context.Model> models = this.loadModelsFromDisk(folder);
        return new Context(this.support, models);
    }

    @Override
    public void saveContext(Context context) throws Exception {
        File folder = this.support.getEvolutionFolder();
        if (folder != null) {
            folder.mkdirs();
        }
        Set<Context.Model> models = context.getChangeInfos().keySet();
        this.saveModelsToDisk(folder, models);
    }

    protected List<Context.Model> loadModelsFromDatabase(IDBStore store) throws SQLException {
        ArrayList<Context.Model> models = new ArrayList<Context.Model>();
        InternalCDOPackageRegistry oldPackageRegistry = this.support.getOldPackageRegistry();
        ResourceSet resourceSet = EMFUtil.newEcoreResourceSet((EPackage.Registry)oldPackageRegistry);
        InternalCDOPackageRegistry newPackageRegistry = this.support.getNewPackageRegistry();
        IDBRowHandler modelRowHandler = (arg_0, arg_1) -> FolderContextManager.lambda$0(resourceSet, (CDOPackageRegistry)newPackageRegistry, models, oldPackageRegistry, arg_0, arg_1);
        Throwable throwable = null;
        Object var8_9 = null;
        try (Connection connection = store.getConnection();){
            DBStoreTables.PackageUnitsTable packageUnitsTable = ((DBStore)store).tables().packageUnits();
            DBUtil.select((Connection)connection, (IDBRowHandler)modelRowHandler, (String)"", (IDBField[])new IDBField[]{packageUnitsTable.id(), packageUnitsTable.originalType(), packageUnitsTable.timeStamp(), packageUnitsTable.packageData()});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return models;
    }

    protected List<Context.Model> loadModelsFromDisk(File folder) throws IOException {
        ArrayList<Context.Model> models = new ArrayList<Context.Model>();
        InternalCDOPackageRegistry oldPackageRegistry = this.support.getOldPackageRegistry();
        ResourceSet resourceSet = EMFUtil.newEcoreResourceSet((EPackage.Registry)oldPackageRegistry);
        Properties properties = IOUtil.loadProperties((File)FolderContextManager.getEvolutionPropertiesFile(folder));
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String fileName = (String)entry.getKey();
            if (!fileName.startsWith(PROP_MODEL_PREFIX)) continue;
            fileName = fileName.substring(PROP_MODEL_PREFIX.length());
            String[] parts = ((String)entry.getValue()).split(",");
            CDOPackageUnit.Type originalType = CDOPackageUnit.Type.valueOf((String)parts[0]);
            long timeStamp = Long.parseLong(parts[1]);
            URI uri = URI.createFileURI((String)new File(folder, fileName).getAbsolutePath());
            Resource resource = resourceSet.getResource(uri, true);
            EPackage oldPackage = (EPackage)resource.getContents().get(0);
            String id = oldPackage.getNsURI();
            EPackage newPackage = this.support.getNewPackageRegistry().getEPackage(id);
            Context.Model model = new Context.Model(id, originalType, timeStamp, oldPackage, newPackage);
            models.add(model);
            InternalCDOPackageUnit packageUnit = (InternalCDOPackageUnit)CDOModelUtil.createPackageUnit((EPackage)oldPackage, (CDOPackageUnit.Type)originalType, (long)timeStamp, (CDOPackageRegistry)oldPackageRegistry);
            oldPackageRegistry.putPackageUnit(packageUnit);
        }
        return models;
    }

    protected void saveModelsToDisk(File folder, Collection<Context.Model> models) throws IOException {
        Properties properties = new Properties();
        for (Context.Model model : models) {
            String encodedFileName = IOUtil.encodeFileName((String)model.getID());
            String fileName = String.valueOf(encodedFileName) + ".ecore";
            properties.setProperty(PROP_MODEL_PREFIX + fileName, String.valueOf(model.getOriginalType().name()) + "," + model.getTimeStamp());
            IOUtil.writeText((File)new File(folder, fileName), (boolean)false, (String)model.getOldXMI());
            if (!this.saveNewModels) continue;
            IOUtil.writeText((File)new File(folder, String.valueOf(encodedFileName) + "_new.ecore"), (boolean)false, (String)model.getNewXMI());
        }
        IOUtil.saveProperties((File)FolderContextManager.getEvolutionPropertiesFile(folder), (Properties)properties, null);
    }

    private static File getEvolutionPropertiesFile(File folder) {
        return new File(folder, EVOLUTION_PROPERTIES_FILE);
    }

    private static /* synthetic */ boolean lambda$0(ResourceSet resourceSet, CDOPackageRegistry cDOPackageRegistry, List list, InternalCDOPackageRegistry internalCDOPackageRegistry, int row, Object[] values) {
        EcorePackage oldPackage;
        String id = (String)values[0];
        CDOPackageUnit.Type originalType = CDOPackageUnit.Type.values()[DBUtil.asInt((Object)values[1])];
        long timeStamp = DBUtil.asLong((Object)values[2]);
        if ("http://www.eclipse.org/emf/2002/Ecore".equals(id)) {
            oldPackage = EcorePackage.eINSTANCE;
        } else {
            byte[] packageData = (byte[])values[3];
            oldPackage = EMFUtil.createEPackage((String)id, (byte[])packageData, (ResourceSet)resourceSet, (boolean)false);
        }
        EPackage newPackage = cDOPackageRegistry.getEPackage(id);
        Context.Model model = new Context.Model(id, originalType, timeStamp, (EPackage)oldPackage, newPackage);
        list.add(model);
        CDOModelUtil.createPackageUnit((EPackage)oldPackage, (CDOPackageUnit.Type)originalType, (long)timeStamp, (CDOPackageRegistry)internalCDOPackageRegistry);
        return true;
    }
}

