/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.DBVersionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.FunctionHelper;

public class FunctionHelperDB2
extends FunctionHelper {
    public static final String CAT_LABEL_DATALINK_FUNCTIONS = Messages._UI_FCN_DATALINK;
    public static final String CAT_LABEL_DB2_FUNCTIONS = Messages._UI_FCN_DB2;
    public static final String CAT_LABEL_MMDB_EXTENDER_FUNCTIONS = Messages._UI_FCN_AIV_EXTENDERS;
    public static final String CAT_LABEL_MQ_EXTENDER_FUNCTIONS = Messages._UI_FCN_MQ_EXTENDER;
    public static final String CAT_LABEL_SQLXML_FUNCTIONS = Messages._UI_FCN_XMLFUNCTIONS;
    public static final String CAT_LABEL_TEXT_EXTENDER_FUNCTIONS = Messages._UI_FCN_TEXT_EXTENDERS;
    protected List fDatalinkFunctionNamesList;
    protected List fDB2FunctionNamesList;
    protected List fMMDBExtenderFunctionNamesList;
    protected List fMQExtenderFunctionNamesList;
    protected List fSQLXMLFunctionNamesList;
    protected List fTextExtenderFunctionNamesList;

    protected FunctionHelperDB2() {
    }

    public FunctionHelperDB2(Database db) {
        super(db);
    }

    @Override
    public List getBuiltinFunctionCategories() {
        List catList = super.getBuiltinFunctionCategories();
        DBVersionHelper versionHelper = this.getVersionHelper();
        if (versionHelper.isDB2_LUW()) {
            catList.add(CAT_LABEL_DATALINK_FUNCTIONS);
            catList.add(CAT_LABEL_MMDB_EXTENDER_FUNCTIONS);
            catList.add(CAT_LABEL_TEXT_EXTENDER_FUNCTIONS);
        }
        catList.add(CAT_LABEL_DB2_FUNCTIONS);
        if (versionHelper.isDB2_LUW() && versionHelper.isAtLeast(8, 2) || versionHelper.isDB2_zOS() && versionHelper.isAtLeast(9)) {
            catList.add(CAT_LABEL_SQLXML_FUNCTIONS);
        }
        return catList;
    }

    @Override
    public List getFunctionNames(String category) {
        List funcNames = super.getFunctionNames(category);
        if (funcNames.size() == 0) {
            if (category.equals(CAT_LABEL_DATALINK_FUNCTIONS)) {
                funcNames = this.getDatalinkFunctionNames();
            } else if (category.equals(CAT_LABEL_DB2_FUNCTIONS)) {
                funcNames = this.getDB2FunctionNames();
            } else if (category.equals(CAT_LABEL_MMDB_EXTENDER_FUNCTIONS)) {
                funcNames = this.getMMDBExtenderFunctionNames();
            } else if (category.equals(CAT_LABEL_MQ_EXTENDER_FUNCTIONS)) {
                funcNames = this.getMQExtenderFunctionNames();
            } else if (category.equals(CAT_LABEL_SQLXML_FUNCTIONS)) {
                funcNames = this.getSQLXMLFunctionNames();
            } else if (category.equals(CAT_LABEL_TEXT_EXTENDER_FUNCTIONS)) {
                funcNames = this.getTextExtenderFunctionNames();
            }
        }
        return funcNames;
    }

    public List getDatalinkFunctionNames() {
        if (this.fDatalinkFunctionNamesList == null) {
            this.initDatalinkFunctions();
        }
        return this.fDatalinkFunctionNamesList;
    }

    public List getDB2FunctionNames() {
        if (this.fDB2FunctionNamesList == null) {
            this.initDB2Functions();
        }
        return this.fDB2FunctionNamesList;
    }

    public List getMMDBExtenderFunctionNames() {
        if (this.fMMDBExtenderFunctionNamesList == null) {
            this.initMMDBExtenderFunctions();
        }
        return this.fMMDBExtenderFunctionNamesList;
    }

    public List getMQExtenderFunctionNames() {
        if (this.fMQExtenderFunctionNamesList == null) {
            this.initMQExtenderFunctions();
        }
        return this.fMQExtenderFunctionNamesList;
    }

    public List getSQLXMLFunctionNames() {
        if (this.fSQLXMLFunctionNamesList == null) {
            this.initSQLXMLFunctions();
        }
        return this.fSQLXMLFunctionNamesList;
    }

    public List getTextExtenderFunctionNames() {
        if (this.fTextExtenderFunctionNamesList == null) {
            this.initTextExtenderFunctions();
        }
        return this.fTextExtenderFunctionNamesList;
    }

    @Override
    protected String[][] getFunctionSignatures(int sigListNum) {
        String[][] list = new String[0][0];
        switch (sigListNum) {
            case 0: {
                list = new String[4][2];
                list[0][0] = "DOUBLE";
                list[0][1] = "DOUBLE";
                list[1][0] = "INTEGER";
                list[1][1] = "INTEGER";
                list[2][0] = "SMALLINT";
                list[2][1] = "SMALLINT";
                list[3][0] = "BIGINT";
                list[3][1] = "BIGINT";
                break;
            }
            case 10: {
                list = new String[4][2];
                list[0][0] = "DATE";
                list[0][1] = "DATE";
                list[1][0] = "DATE";
                list[1][1] = "TIMESTAMP";
                list[2][0] = "DATE";
                list[2][1] = "DOUBLE";
                list[3][0] = "DATE";
                list[3][1] = "VARCHAR";
                break;
            }
            case 20: {
                list = new String[4][2];
                list[0][0] = "INTEGER";
                list[0][1] = "VARCHAR";
                list[1][0] = "INTEGER";
                list[1][1] = "DATE";
                list[2][0] = "INTEGER";
                list[2][1] = "TIMESTAMP";
                list[3][0] = "INTEGER";
                list[3][1] = "DECIMAL";
                break;
            }
            case 30: {
                list = new String[4][2];
                list[0][0] = "INTEGER";
                list[0][1] = "VARCHAR";
                list[1][0] = "INTEGER";
                list[1][1] = "TIME";
                list[2][0] = "INTEGER";
                list[2][1] = "TIMESTAMP";
                list[3][0] = "INTEGER";
                list[3][1] = "DECIMAL";
                break;
            }
            case 40: {
                list = new String[1][2];
                list[0][0] = "DOUBLE";
                list[0][1] = "DOUBLE";
                break;
            }
            case 50: {
                list = new String[1][3];
                list[0][0] = "DOUBLE";
                list[0][1] = "DOUBLE";
                list[0][2] = "DOUBLE";
                break;
            }
            case 60: {
                list = new String[3][3];
                list[0][0] = "INTEGER";
                list[0][1] = "INTEGER";
                list[0][2] = "INTEGER";
                list[1][0] = "SMALLINT";
                list[1][1] = "SMALLINT";
                list[1][2] = "SMALLINT";
                list[2][0] = "BIGINT";
                list[2][1] = "BIGINT";
                list[2][2] = "BIGINT";
                break;
            }
            case 70: {
                list = new String[4][3];
                list[0][0] = "DOUBLE";
                list[0][1] = "DOUBLE";
                list[0][2] = "DOUBLE";
                list[1][0] = "DOUBLE";
                list[1][1] = "DOUBLE";
                list[1][2] = "INTEGER";
                list[2][0] = "INTEGER";
                list[2][1] = "INTEGER";
                list[2][2] = "INTEGER";
                list[3][0] = "BIGINT";
                list[3][1] = "BIGINT";
                list[3][2] = "BIGINT";
                break;
            }
            case 80: {
                list = new String[][]{new String[1], new String[2]};
                list[0][0] = "DOUBLE";
                list[1][0] = "DOUBLE";
                list[1][1] = "INTEGER";
                break;
            }
            case 90: {
                list = new String[][]{new String[1]};
                list[0][0] = "CHARACTER";
                break;
            }
            case 100: {
                list = new String[][]{new String[2], new String[3]};
                list[0][0] = "VARCHAR";
                list[0][1] = "VARCHAR";
                list[1][0] = "VARCHAR";
                list[1][1] = "VARCHAR";
                list[1][2] = "VARCHAR";
                break;
            }
            case 110: {
                list = new String[][]{new String[2], new String[3], new String[4]};
                list[0][0] = "DATALINK";
                list[0][1] = "VARCHAR";
                list[1][0] = "DATALINK";
                list[1][1] = "VARCHAR";
                list[1][2] = "VARCHAR";
                list[2][0] = "DATALINK";
                list[2][1] = "VARCHAR";
                list[2][2] = "VARCHAR";
                list[2][3] = "VARCHAR";
                break;
            }
            case 120: {
                list = new String[][]{new String[2], new String[3], new String[4], new String[5], new String[2], new String[2], new String[2], new String[2], new String[2], new String[2], new String[3], new String[3], new String[3], new String[3], new String[3], new String[3], new String[4], new String[4], new String[4], new String[4], new String[4], new String[4]};
                list[0][0] = "DECIMAL";
                list[0][1] = "VARCHAR";
                list[1][0] = "DECIMAL";
                list[1][1] = "VARCHAR";
                list[1][2] = "INTEGER";
                list[2][0] = "DECIMAL";
                list[2][1] = "VARCHAR";
                list[2][2] = "INTEGER";
                list[2][3] = "INTEGER";
                list[3][0] = "DECIMAL";
                list[3][1] = "VARCHAR";
                list[3][2] = "INTEGER";
                list[3][3] = "INTEGER";
                list[3][4] = "VARCHAR";
                list[4][0] = "DECIMAL";
                list[4][1] = "SMALLINT";
                list[5][0] = "DECIMAL";
                list[5][1] = "INTEGER";
                list[6][0] = "DECIMAL";
                list[6][1] = "BIGINT";
                list[7][0] = "DECIMAL";
                list[7][1] = "DECIMAL";
                list[8][0] = "DECIMAL";
                list[8][1] = "REAL";
                list[9][0] = "DECIMAL";
                list[9][1] = "DOUBLE";
                list[10][0] = "DECIMAL";
                list[10][1] = "SMALLINT";
                list[10][2] = "INTEGER";
                list[11][0] = "DECIMAL";
                list[11][1] = "INTEGER";
                list[11][2] = "INTEGER";
                list[12][0] = "DECIMAL";
                list[12][1] = "BIGINT";
                list[12][2] = "INTEGER";
                list[13][0] = "DECIMAL";
                list[13][1] = "DECIMAL";
                list[13][2] = "INTEGER";
                list[14][0] = "DECIMAL";
                list[14][1] = "REAL";
                list[14][2] = "INTEGER";
                list[15][0] = "DECIMAL";
                list[15][1] = "DOUBLE";
                list[15][2] = "INTEGER";
                list[16][0] = "DECIMAL";
                list[16][1] = "SMALLINT";
                list[16][2] = "INTEGER";
                list[16][3] = "INTEGER";
                list[17][0] = "DECIMAL";
                list[17][1] = "INTEGER";
                list[17][2] = "INTEGER";
                list[17][3] = "INTEGER";
                list[18][0] = "DECIMAL";
                list[18][1] = "BIGINT";
                list[18][2] = "INTEGER";
                list[18][3] = "INTEGER";
                list[19][0] = "DECIMAL";
                list[19][1] = "DECIMAL";
                list[19][2] = "INTEGER";
                list[19][3] = "INTEGER";
                list[20][0] = "DECIMAL";
                list[20][1] = "REAL";
                list[20][2] = "INTEGER";
                list[20][3] = "INTEGER";
                list[21][0] = "DECIMAL";
                list[21][1] = "DOUBLE";
                list[21][2] = "INTEGER";
                list[21][3] = "INTEGER";
                break;
            }
            case 130: {
                list = new String[][]{new String[2], new String[2], new String[3], new String[3], new String[3], new String[3]};
                list[0][0] = "TIMESTAMP";
                list[0][1] = "TIMESTAMP";
                list[1][0] = "TIMESTAMP";
                list[1][1] = "VARCHAR";
                list[2][0] = "TIMESTAMP";
                list[2][1] = "VARCHAR";
                list[2][2] = "VARCHAR";
                list[3][0] = "TIMESTAMP";
                list[3][1] = "VARCHAR";
                list[3][2] = "TIME";
                list[4][0] = "TIMESTAMP";
                list[4][1] = "DATE";
                list[4][2] = "VARCHAR";
                list[5][0] = "TIMESTAMP";
                list[5][1] = "DATE";
                list[5][2] = "TIME";
                break;
            }
            case 140: {
                list = new String[][]{new String[2], new String[2], new String[4], new String[4], new String[5], new String[5], new String[4], new String[4], new String[5], new String[5]};
                list[0][0] = "CHARACTER";
                list[0][1] = "CHARACTER";
                list[1][0] = "VARCHAR";
                list[1][1] = "VARCHAR";
                list[2][0] = "CHARACTER";
                list[2][1] = "CHARACTER";
                list[2][2] = "VARCHAR";
                list[2][3] = "VARCHAR";
                list[3][0] = "VARCHAR";
                list[3][1] = "VARCHAR";
                list[3][2] = "VARCHAR";
                list[3][3] = "VARCHAR";
                list[4][0] = "CHARACTER";
                list[4][1] = "CHARACTER";
                list[4][2] = "VARCHAR";
                list[4][3] = "VARCHAR";
                list[4][4] = "VARCHAR";
                list[5][0] = "VARCHAR";
                list[5][1] = "VARCHAR";
                list[5][2] = "VARCHAR";
                list[5][3] = "VARCHAR";
                list[5][4] = "VARCHAR";
                list[6][0] = "GRAPHIC";
                list[6][1] = "GRAPHIC";
                list[6][2] = "VARGRAPHIC";
                list[6][3] = "VARGRAPHIC";
                list[7][0] = "VARGRAPHIC";
                list[7][1] = "VARGRAPHIC";
                list[7][2] = "VARGRAPHIC";
                list[7][3] = "VARGRAPHIC";
                list[8][0] = "GRAPHIC";
                list[8][1] = "GRAPHIC";
                list[8][2] = "VARGRAPHIC";
                list[8][3] = "VARGRAPHIC";
                list[8][4] = "VARGRAPHIC";
                list[9][0] = "VARGRAPHIC";
                list[9][1] = "VARGRAPHIC";
                list[9][2] = "VARGRAPHIC";
                list[9][3] = "VARGRAPHIC";
                list[9][4] = "VARGRAPHIC";
                break;
            }
            case 150: {
                list = new String[3][3];
                list[0][0] = "DOUBLE";
                list[0][1] = "DOUBLE";
                list[0][2] = "INTEGER";
                list[1][0] = "INTEGER";
                list[1][1] = "INTEGER";
                list[1][2] = "INTEGER";
                list[2][0] = "BIGINT";
                list[2][1] = "BIGINT";
                list[2][2] = "INTEGER";
                break;
            }
            case 160: {
                list = new String[3][2];
                list[0][0] = "VARCHAR";
                list[0][1] = "DATE";
                list[1][0] = "VARCHAR";
                list[1][1] = "VARCHAR";
                list[2][0] = "VARCHAR";
                list[2][1] = "TIMESTAMP";
                break;
            }
            case 170: {
                list = new String[4][2];
                list[0][0] = "TIMESTAMP";
                list[0][1] = "DATE";
                list[1][0] = "TIMESTAMP";
                list[1][1] = "TIME";
                list[2][0] = "TIMESTAMP";
                list[2][1] = "TIMESTAMP";
                list[3][0] = "TIMESTAMP";
                list[3][1] = "VARCHAR";
                break;
            }
            case 180: {
                list = new String[3][2];
                list[0][0] = "INTEGER";
                list[0][1] = "DATE";
                list[1][0] = "INTEGER";
                list[1][1] = "VARCHAR";
                list[2][0] = "INTEGER";
                list[2][1] = "TIMESTAMP";
                break;
            }
            case 190: {
                list = new String[1][3];
                list[0][0] = "INTEGER";
                list[0][1] = "INTEGER";
                list[0][2] = "CHARACTER";
                break;
            }
            case 200: {
                list = new String[3][2];
                list[0][0] = "INTEGER";
                list[0][1] = "CHARACTER";
                list[1][0] = "INTEGER";
                list[1][1] = "VARCHAR";
                list[2][0] = "INTEGER";
                list[2][1] = "CLOB";
                break;
            }
            case 210: {
                list = new String[1][2];
                list[0][0] = "CHARACTER";
                list[0][1] = "INTEGER";
                break;
            }
            case 220: {
                list = new String[3][5];
                list[0][0] = "VARCHAR";
                list[0][1] = "VARCHAR";
                list[0][2] = "INTEGER";
                list[0][3] = "INTEGER";
                list[0][4] = "VARCHAR";
                list[1][0] = "CLOB";
                list[1][1] = "CLOB";
                list[1][2] = "INTEGER";
                list[1][3] = "INTEGER";
                list[1][4] = "CLOB";
                list[2][0] = "BLOB";
                list[2][1] = "BLOB";
                list[2][2] = "INTEGER";
                list[2][3] = "INTEGER";
                list[2][4] = "BLOB";
                break;
            }
            case 230: {
                list = new String[5][2];
                list[0][0] = "CLOB";
                list[0][1] = "CLOB";
                list[1][0] = "VARCHAR";
                list[1][1] = "VARCHAR";
                list[2][0] = "VARCHAR";
                list[2][1] = "CHARACTER";
                list[3][0] = "VARGRAPHIC";
                list[3][1] = "GRAPHIC";
                list[4][0] = "VARGRAPHIC";
                list[4][1] = "VARGRAPHIC";
                break;
            }
            case 240: {
                list = new String[3][2];
                list[0][0] = "CLOB";
                list[0][1] = "CLOB";
                list[1][0] = "VARCHAR";
                list[1][1] = "VARCHAR";
                list[2][0] = "CHARACTER";
                list[2][1] = "CHARACTER";
                break;
            }
            case 250: {
                list = new String[3][2];
                list[0][0] = "CLOB";
                list[0][1] = "CLOB";
                list[1][0] = "VARCHAR";
                list[1][1] = "VARCHAR";
                list[2][0] = "CHARACTER";
                list[2][1] = "CHARACTER";
                break;
            }
            case 260: {
                list = new String[][]{new String[4], new String[4], new String[4], new String[3], new String[3], new String[3]};
                list[0][0] = "INTEGER";
                list[0][1] = "VARCHAR";
                list[0][2] = "VARCHAR";
                list[0][3] = "INTEGER";
                list[1][0] = "INTEGER";
                list[1][1] = "CLOB";
                list[1][2] = "CLOB";
                list[1][3] = "INTEGER";
                list[2][0] = "INTEGER";
                list[2][1] = "BLOB";
                list[2][2] = "BLOB";
                list[2][3] = "INTEGER";
                list[3][0] = "INTEGER";
                list[3][1] = "VARCHAR";
                list[3][2] = "VARCHAR";
                list[4][0] = "INTEGER";
                list[4][1] = "CLOB";
                list[4][2] = "CLOB";
                list[5][0] = "INTEGER";
                list[5][1] = "BLOB";
                list[5][2] = "BLOB";
                break;
            }
            case 270: {
                list = new String[1][2];
                list[0][0] = "CHARACTER";
                list[0][1] = "VARCHAR";
                break;
            }
            case 280: {
                list = new String[1][3];
                list[0][0] = "INTEGER";
                list[0][1] = "VARCHAR";
                list[0][2] = "VARCHAR";
                break;
            }
            case 290: {
                list = new String[3][3];
                list[0][0] = "VARCHAR";
                list[0][1] = "VARCHAR";
                list[0][2] = "INTEGER";
                list[1][0] = "CLOB";
                list[1][1] = "CLOB";
                list[1][2] = "INTEGER";
                list[2][0] = "BLOB";
                list[2][1] = "BLOB";
                list[2][2] = "INTEGER";
                break;
            }
            case 300: {
                list = new String[1][2];
                list[0][0] = "VARCHAR";
                list[0][1] = "INTEGER";
                break;
            }
            case 310: {
                list = new String[3][4];
                list[0][0] = "VARCHAR";
                list[0][1] = "VARCHAR";
                list[0][2] = "VARCHAR";
                list[0][3] = "VARCHAR";
                list[1][0] = "CLOB";
                list[1][1] = "CLOB";
                list[1][2] = "CLOB";
                list[1][3] = "CLOB";
                list[2][0] = "BLOB";
                list[2][1] = "BLOB";
                list[2][2] = "BLOB";
                list[2][3] = "BLOB";
                break;
            }
            case 320: {
                list = new String[32][2];
                list[0] = new String[2];
                list[1] = new String[2];
                list[2] = new String[2];
                list[3] = new String[2];
                list[4] = new String[3];
                list[5] = new String[3];
                list[6] = new String[3];
                list[7] = new String[3];
                list[8] = new String[2];
                list[9] = new String[2];
                list[10] = new String[2];
                list[11] = new String[3];
                list[12] = new String[3];
                list[13] = new String[3];
                list[14] = new String[3];
                list[15] = new String[3];
                list[16] = new String[3];
                list[17] = new String[3];
                list[18] = new String[3];
                list[19] = new String[3];
                list[20] = new String[3];
                list[21] = new String[3];
                list[22] = new String[3];
                list[23] = new String[3];
                list[24] = new String[3];
                list[25] = new String[3];
                list[26] = new String[2];
                list[27] = new String[2];
                list[28] = new String[2];
                list[29] = new String[2];
                list[30] = new String[3];
                list[31] = new String[2];
                list[0][0] = "CHARACTER";
                list[0][1] = "CHARACTER";
                list[1][0] = "CHARACTER";
                list[1][1] = "VARCHAR";
                list[2][0] = "CHARACTER";
                list[2][1] = "LONG VARCHAR";
                list[3][0] = "CHARACTER";
                list[3][1] = "CLOB";
                list[4][0] = "CHARACTER";
                list[4][1] = "CHARACTER";
                list[4][2] = "INTEGER";
                list[5][0] = "CHARACTER";
                list[5][1] = "VARCHAR";
                list[5][2] = "INTEGER";
                list[6][0] = "CHARACTER";
                list[6][1] = "LONG VARCHAR";
                list[6][2] = "INTEGER";
                list[7][0] = "CHARACTER";
                list[7][1] = "CLOB";
                list[7][2] = "INTEGER";
                list[8][0] = "CHARACTER";
                list[8][1] = "DATE";
                list[9][0] = "CHARACTER";
                list[9][1] = "TIME";
                list[10][0] = "CHARACTER";
                list[10][1] = "TIMESTAMP";
                list[11][0] = "CHARACTER";
                list[11][1] = "DATE";
                list[11][2] = "ISO";
                list[12][0] = "CHARACTER";
                list[12][1] = "DATE";
                list[12][2] = "USA";
                list[13][0] = "CHARACTER";
                list[13][1] = "DATE";
                list[13][2] = "EUR";
                list[14][0] = "CHARACTER";
                list[14][1] = "DATE";
                list[14][2] = "JIS";
                list[15][0] = "CHARACTER";
                list[15][1] = "DATE";
                list[15][2] = "LOCAL";
                list[16][0] = "CHARACTER";
                list[16][1] = "TIME";
                list[16][2] = "ISO";
                list[17][0] = "CHARACTER";
                list[17][1] = "TIME";
                list[17][2] = "USA";
                list[18][0] = "CHARACTER";
                list[18][1] = "TIME";
                list[18][2] = "EUR";
                list[19][0] = "CHARACTER";
                list[19][1] = "TIME";
                list[19][2] = "JIS";
                list[20][0] = "CHARACTER";
                list[20][1] = "TIME";
                list[20][2] = "LOCAL";
                list[21][0] = "CHARACTER";
                list[21][1] = "TIMESTAMP";
                list[21][2] = "ISO";
                list[22][0] = "CHARACTER";
                list[22][1] = "TIMESTAMP";
                list[22][2] = "USA";
                list[23][0] = "CHARACTER";
                list[23][1] = "TIMESTAMP";
                list[23][2] = "EUR";
                list[24][0] = "CHARACTER";
                list[24][1] = "TIMESTAMP";
                list[24][2] = "JIS";
                list[25][0] = "CHARACTER";
                list[25][1] = "TIMESTAMP";
                list[25][2] = "LOCAL";
                list[26][0] = "CHARACTER";
                list[26][1] = "SMALLINT";
                list[27][0] = "CHARACTER";
                list[27][1] = "INTEGER";
                list[28][0] = "CHARACTER";
                list[28][1] = "BIGINT";
                list[29][0] = "CHARACTER";
                list[29][1] = "DECIMAL";
                list[30][0] = "CHARACTER";
                list[30][1] = "DECIMAL";
                list[30][2] = "VARCHAR";
                list[31][0] = "CHARACTER";
                list[31][1] = "DOUBLE";
                break;
            }
            case 330: {
                list = new String[7][2];
                list[0][0] = "DOUBLE";
                list[0][1] = "SMALLINT";
                list[1][0] = "DOUBLE";
                list[1][1] = "INTEGER";
                list[2][0] = "DOUBLE";
                list[2][1] = "BIGINT";
                list[3][0] = "DOUBLE";
                list[3][1] = "DECIMAL";
                list[4][0] = "DOUBLE";
                list[4][1] = "REAL";
                list[5][0] = "DOUBLE";
                list[5][1] = "DOUBLE";
                list[6][0] = "DOUBLE";
                list[6][1] = "VARCHAR";
                break;
            }
            case 340: {
                list = new String[6][2];
                list[0][0] = "DOUBLE";
                list[0][1] = "SMALLINT";
                list[1][0] = "DOUBLE";
                list[1][1] = "INTEGER";
                list[2][0] = "DOUBLE";
                list[2][1] = "BIGINT";
                list[3][0] = "DOUBLE";
                list[3][1] = "DECIMAL";
                list[4][0] = "DOUBLE";
                list[4][1] = "REAL";
                list[5][0] = "DOUBLE";
                list[5][1] = "DOUBLE";
                break;
            }
            case 350: {
                list = new String[1][2];
                list[0][0] = "CHARACTER";
                list[0][1] = "DECIMAL";
                break;
            }
            case 360: {
                list = new String[1][2];
                list[0][0] = "INTEGER";
                list[0][1] = "VARCHAR";
                break;
            }
            case 370: {
                list = new String[2][2];
                list[0][0] = "VARCHAR";
                list[0][1] = "VARCHAR";
                list[1][0] = "CHARACTER";
                list[1][1] = "CHARACTER";
                break;
            }
            case 380: {
                list = new String[1][2];
                list[0][0] = "VARCHAR";
                list[0][1] = "DATALINK";
                break;
            }
            case 390: {
                list = new String[3][2];
                list[0][0] = "INTEGER";
                list[0][1] = "VARCHAR";
                list[1][0] = "INTEGER";
                list[1][1] = "TIMESTAMP";
                list[2][0] = "INTEGER";
                list[2][1] = "DECIMAL";
                break;
            }
            case 400: {
                list = new String[3][2];
                list[0][0] = "TIME";
                list[0][1] = "TIME";
                list[1][0] = "TIME";
                list[1][1] = "TIMESTAMP";
                list[2][0] = "TIME";
                list[2][1] = "VARCHAR";
                break;
            }
            case 410: {
                list = new String[3][2];
                list[0][0] = "INTEGER";
                list[0][1] = "TIME";
                list[1][0] = "INTEGER";
                list[1][1] = "TIMESTAMP";
                list[2][0] = "INTEGER";
                list[2][1] = "VARCHAR";
                break;
            }
            case 420: {
                list = new String[6][2];
                list[0][0] = "INTEGER";
                list[0][1] = "SMALLINT";
                list[1][0] = "*";
                list[1][1] = "INTEGER";
                list[2][0] = "*";
                list[2][1] = "BIGINT";
                list[3][0] = "*";
                list[3][1] = "DECIMAL";
                list[4][0] = "DOUBLE";
                list[4][1] = "REAL";
                list[5][0] = "*";
                list[5][1] = "DOUBLE";
                break;
            }
            case 430: {
                list = new String[7][2];
                list[0][0] = "BIGINT";
                list[0][1] = "SMALLINT";
                list[1][0] = "BIGINT";
                list[1][1] = "INTEGER";
                list[2][0] = "BIGINT";
                list[2][1] = "BIGINT";
                list[3][0] = "BIGINT";
                list[3][1] = "DECIMAL";
                list[4][0] = "BIGINT";
                list[4][1] = "REAL";
                list[5][0] = "BIGINT";
                list[5][1] = "DOUBLE";
                list[6][0] = "BIGINT";
                list[6][1] = "VARCHAR";
                break;
            }
            case 440: {
                list = new String[7][2];
                list[0][0] = "INTEGER";
                list[0][1] = "SMALLINT";
                list[1][0] = "INTEGER";
                list[1][1] = "INTEGER";
                list[2][0] = "INTEGER";
                list[2][1] = "BIGINT";
                list[3][0] = "INTEGER";
                list[3][1] = "DECIMAL";
                list[4][0] = "INTEGER";
                list[4][1] = "REAL";
                list[5][0] = "INTEGER";
                list[5][1] = "DOUBLE";
                list[6][0] = "INTEGER";
                list[6][1] = "VARCHAR";
                break;
            }
            case 450: {
                list = new String[7][2];
                list[0][0] = "SMALLINT";
                list[0][1] = "SMALLINT";
                list[1][0] = "SMALLINT";
                list[1][1] = "INTEGER";
                list[2][0] = "SMALLINT";
                list[2][1] = "BIGINT";
                list[3][0] = "SMALLINT";
                list[3][1] = "DECIMAL";
                list[4][0] = "SMALLINT";
                list[4][1] = "REAL";
                list[5][0] = "SMALLINT";
                list[5][1] = "DOUBLE";
                list[6][0] = "SMALLINT";
                list[6][1] = "VARCHAR";
                break;
            }
            case 460: {
                list = new String[6][2];
                list[0][0] = "INTEGER";
                list[0][1] = "SMALLINT";
                list[1][0] = "INTEGER";
                list[1][1] = "INTEGER";
                list[2][0] = "BIGINT";
                list[2][1] = "BIGINT";
                list[3][0] = "DECIMAL";
                list[3][1] = "DECIMAL";
                list[4][0] = "DOUBLE";
                list[4][1] = "REAL";
                list[5][0] = "DOUBLE";
                list[5][1] = "DOUBLE";
                break;
            }
            case 470: {
                list = new String[6][2];
                list[0][0] = "REAL";
                list[0][1] = "SMALLINT";
                list[1][0] = "REAL";
                list[1][1] = "INTEGER";
                list[2][0] = "REAL";
                list[2][1] = "BIGINT";
                list[3][0] = "REAL";
                list[3][1] = "DECIMAL";
                list[4][0] = "REAL";
                list[4][1] = "REAL";
                list[5][0] = "REAL";
                list[5][1] = "DOUBLE";
                break;
            }
            case 480: {
                list = new String[1][2];
                list[0][0] = "INTEGER";
                list[0][1] = "*";
                break;
            }
            case 490: {
                list = new String[1][2];
                list[0][0] = "SMALLINT";
                list[0][1] = "*";
                break;
            }
            case 500: {
                list = new String[1][2];
                list[0][0] = "DECIMAL";
                list[0][1] = "*";
                break;
            }
            case 510: {
                list = new String[1][2];
                list[0][0] = "VARCHAR";
                list[0][1] = "*";
                break;
            }
            case 520: {
                list = new String[1][2];
                list[0][0] = "INTEGER";
                list[0][1] = "*";
                break;
            }
            case 530: {
                list = new String[1][2];
                list[0][0] = "*";
                list[0][1] = "*";
                break;
            }
            case 540: {
                list = new String[1][3];
                list[0][0] = "*";
                list[0][1] = "*";
                list[0][2] = "*";
                break;
            }
            case 550: {
                list = new String[9][3];
                list[0][0] = "*";
                list[0][1] = "CHARACTER";
                list[0][2] = "*";
                list[1][0] = "*";
                list[1][1] = "VARCHAR";
                list[1][2] = "*";
                list[2][0] = "*";
                list[2][1] = "LONG VARCHAR";
                list[2][2] = "*";
                list[3][0] = "*";
                list[3][1] = "CLOB";
                list[3][2] = "*";
                list[4][0] = "*";
                list[4][1] = "GRAPHIC";
                list[4][2] = "*";
                list[5][0] = "*";
                list[5][1] = "VARGRAPHIC";
                list[5][2] = "*";
                list[6][0] = "*";
                list[6][1] = "LONG VARGRAPHIC";
                list[6][2] = "*";
                list[7][0] = "*";
                list[7][1] = "DBCLOB";
                list[7][2] = "*";
                list[8][0] = "BLOB";
                list[8][1] = "BLOB";
                list[8][2] = "*";
                break;
            }
            case 560: {
                list = new String[1][3];
                list[0][0] = "*";
                list[0][1] = "VARCHAR";
                list[0][2] = "VARCHAR";
                break;
            }
            case 570: {
                list = new String[9][3];
                list[0][0] = "INTEGER";
                list[0][1] = "CHARACTER";
                list[0][2] = "*";
                list[1][0] = "INTEGER";
                list[1][1] = "VARCHAR";
                list[1][2] = "*";
                list[2][0] = "INTEGER";
                list[2][1] = "LONG VARCHAR";
                list[2][2] = "*";
                list[3][0] = "INTEGER";
                list[3][1] = "CLOB";
                list[3][2] = "*";
                list[4][0] = "INTEGER";
                list[4][1] = "GRAPHIC";
                list[4][2] = "*";
                list[5][0] = "INTEGER";
                list[5][1] = "VARGRAPHIC";
                list[5][2] = "*";
                list[6][0] = "INTEGER";
                list[6][1] = "LONG VARGRAPHIC";
                list[6][2] = "*";
                list[7][0] = "INTEGER";
                list[7][1] = "DBCLOB";
                list[7][2] = "*";
                list[8][0] = "INTEGER";
                list[8][1] = "BLOB";
                list[8][2] = "*";
                break;
            }
            case 580: {
                list = new String[4][2];
                list[0][0] = "LONG VARCHAR";
                list[0][1] = "CHARACTER";
                list[1][0] = "LONG VARCHAR";
                list[1][1] = "VARCHAR";
                list[2][0] = "LONG VARCHAR";
                list[2][1] = "LONG VARCHAR";
                list[3][0] = "LONG VARCHAR";
                list[3][1] = "CLOB";
                break;
            }
            case 590: {
                list = new String[4][2];
                list[0][0] = "LONG VARGRAPHIC";
                list[0][1] = "GRAPHIC";
                list[1][0] = "LONG VARGRAPHIC";
                list[1][1] = "VARGRAPHIC";
                list[2][0] = "LONG VARGRAPHIC";
                list[2][1] = "LONG VARGRAPHIC";
                list[3][0] = "LONG VARGRAPHIC";
                list[3][1] = "DBCLOB";
                break;
            }
            case 600: {
                list = new String[1][3];
                list[0][0] = "*";
                list[0][1] = "*";
                list[0][2] = "*";
                break;
            }
            case 610: {
                list = new String[][]{new String[3], new String[3], new String[3], new String[3], new String[3], new String[3], new String[3], new String[3], new String[3], new String[4], new String[4], new String[4], new String[4], new String[4], new String[4], new String[4], new String[4], new String[4]};
                list[0][0] = "CHARACTER";
                list[0][1] = "CHARACTER";
                list[0][2] = "INTEGER";
                list[1][0] = "VARCHAR";
                list[1][1] = "VARCHAR";
                list[1][2] = "INTEGER";
                list[2][0] = "LONG VARCHAR";
                list[2][1] = "LONG VARCHAR";
                list[2][2] = "INTEGER";
                list[3][0] = "CLOB";
                list[3][1] = "CLOB";
                list[3][2] = "INTEGER";
                list[4][0] = "GRAPHIC";
                list[4][1] = "GRAPHIC";
                list[4][2] = "INTEGER";
                list[5][0] = "VARGRAPHIC";
                list[5][1] = "VARGRAPHIC";
                list[5][2] = "INTEGER";
                list[6][0] = "LONG VARGRAPHIC";
                list[6][1] = "LONG VARGRAPHIC";
                list[6][2] = "INTEGER";
                list[7][0] = "DBCLOB";
                list[7][1] = "DBCLOB";
                list[7][2] = "INTEGER";
                list[8][0] = "BLOB";
                list[8][1] = "BLOB";
                list[8][2] = "INTEGER";
                list[9][0] = "CHARACTER";
                list[9][1] = "CHARACTER";
                list[9][2] = "INTEGER";
                list[9][3] = "INTEGER";
                list[10][0] = "VARCHAR";
                list[10][1] = "VARCHAR";
                list[10][2] = "INTEGER";
                list[10][3] = "INTEGER";
                list[11][0] = "LONG VARCHAR";
                list[11][1] = "LONG VARCHAR";
                list[11][2] = "INTEGER";
                list[11][3] = "INTEGER";
                list[12][0] = "CLOB";
                list[12][1] = "CLOB";
                list[12][2] = "INTEGER";
                list[12][3] = "INTEGER";
                list[13][0] = "GRAPHIC";
                list[13][1] = "GRAPHIC";
                list[13][2] = "INTEGER";
                list[13][3] = "INTEGER";
                list[14][0] = "VARGRAPHIC";
                list[14][1] = "VARGRAPHIC";
                list[14][2] = "INTEGER";
                list[14][3] = "INTEGER";
                list[15][0] = "LONG VARGRAPHIC";
                list[15][1] = "LONG VARGRAPHIC";
                list[15][2] = "INTEGER";
                list[15][3] = "INTEGER";
                list[16][0] = "DBCLOB";
                list[16][1] = "DBCLOB";
                list[16][2] = "INTEGER";
                list[16][3] = "INTEGER";
                list[17][0] = "BLOB";
                list[17][1] = "BLOB";
                list[17][2] = "INTEGER";
                list[17][3] = "INTEGER";
                break;
            }
            case 620: {
                list = new String[][]{new String[2], new String[2], new String[2], new String[2], new String[2], new String[2], new String[2], new String[2], new String[2], new String[3], new String[3], new String[3], new String[3], new String[3], new String[3], new String[3], new String[3], new String[3]};
                list[0][0] = "BLOB";
                list[0][1] = "CHARACTER";
                list[1][0] = "BLOB";
                list[1][1] = "VARCHAR";
                list[2][0] = "BLOB";
                list[2][1] = "LONG VARCHAR";
                list[3][0] = "BLOB";
                list[3][1] = "CLOB";
                list[4][0] = "BLOB";
                list[4][1] = "GRAPHIC";
                list[5][0] = "BLOB";
                list[5][1] = "VARGRAPHIC";
                list[6][0] = "BLOB";
                list[6][1] = "LONG VARGRAPHIC";
                list[7][0] = "BLOB";
                list[7][1] = "DBCLOB";
                list[8][0] = "BLOB";
                list[8][1] = "BLOB";
                list[9][0] = "BLOB";
                list[9][1] = "CHARACTER";
                list[9][2] = "INTEGER";
                list[10][0] = "BLOB";
                list[10][1] = "VARCHAR";
                list[10][2] = "INTEGER";
                list[11][0] = "BLOB";
                list[11][1] = "LONG VARCHAR";
                list[11][2] = "INTEGER";
                list[12][0] = "BLOB";
                list[12][1] = "CLOB";
                list[12][2] = "INTEGER";
                list[13][0] = "BLOB";
                list[13][1] = "GRAPHIC";
                list[13][2] = "INTEGER";
                list[14][0] = "BLOB";
                list[14][1] = "VARGRAPHIC";
                list[14][2] = "INTEGER";
                list[15][0] = "BLOB";
                list[15][1] = "LONG VARGRAPHIC";
                list[15][2] = "INTEGER";
                list[16][0] = "BLOB";
                list[16][1] = "DBCLOB";
                list[16][2] = "INTEGER";
                list[17][0] = "BLOB";
                list[17][1] = "BLOB";
                list[17][2] = "INTEGER";
                break;
            }
            case 630: {
                list = new String[][]{new String[2], new String[2], new String[2], new String[2], new String[3], new String[3], new String[3], new String[3]};
                list[0][0] = "CLOB";
                list[0][1] = "CHARACTER";
                list[1][0] = "CLOB";
                list[1][1] = "VARCHAR";
                list[2][0] = "CLOB";
                list[2][1] = "LONG VARCHAR";
                list[3][0] = "CLOB";
                list[3][1] = "CLOB";
                list[4][0] = "CLOB";
                list[4][1] = "CHARACTER";
                list[4][2] = "INTEGER";
                list[5][0] = "CLOB";
                list[5][1] = "VARCHAR";
                list[5][2] = "INTEGER";
                list[6][0] = "CLOB";
                list[6][1] = "LONG VARCHAR";
                list[6][2] = "INTEGER";
                list[7][0] = "CLOB";
                list[7][1] = "CLOB";
                list[7][2] = "INTEGER";
                break;
            }
            case 640: {
                list = new String[36][3];
                list[0][0] = "DOUBLE";
                list[0][1] = "SMALLINT";
                list[0][2] = "SMALLINT";
                list[1][0] = "DOUBLE";
                list[1][1] = "SMALLINT";
                list[1][2] = "INTEGER";
                list[2][0] = "DOUBLE";
                list[2][1] = "SMALLINT";
                list[2][2] = "BIGINT";
                list[3][0] = "DOUBLE";
                list[3][1] = "SMALLINT";
                list[3][2] = "DECIMAL";
                list[4][0] = "DOUBLE";
                list[4][1] = "SMALLINT";
                list[4][2] = "REAL";
                list[5][0] = "DOUBLE";
                list[5][1] = "SMALLINT";
                list[5][2] = "DOUBLE";
                list[6][0] = "DOUBLE";
                list[6][1] = "INTEGER";
                list[6][2] = "SMALLINT";
                list[7][0] = "DOUBLE";
                list[7][1] = "INTEGER";
                list[7][2] = "INTEGER";
                list[8][0] = "DOUBLE";
                list[8][1] = "INTEGER";
                list[8][2] = "BIGINT";
                list[9][0] = "DOUBLE";
                list[9][1] = "INTEGER";
                list[9][2] = "DECIMAL";
                list[10][0] = "DOUBLE";
                list[10][1] = "INTEGER";
                list[10][2] = "REAL";
                list[11][0] = "DOUBLE";
                list[11][1] = "INTEGER";
                list[11][2] = "DOUBLE";
                list[12][0] = "DOUBLE";
                list[12][1] = "BIGINT";
                list[12][2] = "SMALLINT";
                list[13][0] = "DOUBLE";
                list[13][1] = "BIGINT";
                list[13][2] = "INTEGER";
                list[14][0] = "DOUBLE";
                list[14][1] = "BIGINT";
                list[14][2] = "BIGINT";
                list[15][0] = "DOUBLE";
                list[15][1] = "BIGINT";
                list[15][2] = "DECIMAL";
                list[16][0] = "DOUBLE";
                list[16][1] = "BIGINT";
                list[16][2] = "REAL";
                list[17][0] = "DOUBLE";
                list[17][1] = "BIGINT";
                list[17][2] = "DOUBLE";
                list[18][0] = "DOUBLE";
                list[18][1] = "DECIMAL";
                list[18][2] = "SMALLINT";
                list[19][0] = "DOUBLE";
                list[19][1] = "DECIMAL";
                list[19][2] = "INTEGER";
                list[20][0] = "DOUBLE";
                list[20][1] = "DECIMAL";
                list[20][2] = "BIGINT";
                list[21][0] = "DOUBLE";
                list[21][1] = "DECIMAL";
                list[21][2] = "DECIMAL";
                list[22][0] = "DOUBLE";
                list[22][1] = "DECIMAL";
                list[22][2] = "REAL";
                list[23][0] = "DOUBLE";
                list[23][1] = "DECIMAL";
                list[23][2] = "DOUBLE";
                list[24][0] = "DOUBLE";
                list[24][1] = "REAL";
                list[24][2] = "SMALLINT";
                list[25][0] = "DOUBLE";
                list[25][1] = "REAL";
                list[25][2] = "INTEGER";
                list[26][0] = "DOUBLE";
                list[26][1] = "REAL";
                list[26][2] = "BIGINT";
                list[27][0] = "DOUBLE";
                list[27][1] = "REAL";
                list[27][2] = "DECIMAL";
                list[28][0] = "DOUBLE";
                list[28][1] = "REAL";
                list[28][2] = "REAL";
                list[29][0] = "DOUBLE";
                list[29][1] = "REAL";
                list[29][2] = "DOUBLE";
                list[30][0] = "DOUBLE";
                list[30][1] = "DOUBLE";
                list[30][2] = "SMALLINT";
                list[31][0] = "DOUBLE";
                list[31][1] = "DOUBLE";
                list[31][2] = "INTEGER";
                list[32][0] = "DOUBLE";
                list[32][1] = "DOUBLE";
                list[32][2] = "BIGINT";
                list[33][0] = "DOUBLE";
                list[33][1] = "DOUBLE";
                list[33][2] = "DECIMAL";
                list[34][0] = "DOUBLE";
                list[34][1] = "DOUBLE";
                list[34][2] = "REAL";
                list[35][0] = "DOUBLE";
                list[35][1] = "DOUBLE";
                list[35][2] = "DOUBLE";
                break;
            }
            case 650: {
                list = new String[36][3];
                list[0][0] = "INTEGER";
                list[0][1] = "SMALLINT";
                list[0][2] = "SMALLINT";
                list[1][0] = "INTEGER";
                list[1][1] = "SMALLINT";
                list[1][2] = "INTEGER";
                list[2][0] = "INTEGER";
                list[2][1] = "SMALLINT";
                list[2][2] = "BIGINT";
                list[3][0] = "INTEGER";
                list[3][1] = "SMALLINT";
                list[3][2] = "DECIMAL";
                list[4][0] = "INTEGER";
                list[4][1] = "SMALLINT";
                list[4][2] = "REAL";
                list[5][0] = "INTEGER";
                list[5][1] = "SMALLINT";
                list[5][2] = "DOUBLE";
                list[6][0] = "INTEGER";
                list[6][1] = "INTEGER";
                list[6][2] = "SMALLINT";
                list[7][0] = "INTEGER";
                list[7][1] = "INTEGER";
                list[7][2] = "INTEGER";
                list[8][0] = "INTEGER";
                list[8][1] = "INTEGER";
                list[8][2] = "BIGINT";
                list[9][0] = "INTEGER";
                list[9][1] = "INTEGER";
                list[9][2] = "DECIMAL";
                list[10][0] = "INTEGER";
                list[10][1] = "INTEGER";
                list[10][2] = "REAL";
                list[11][0] = "INTEGER";
                list[11][1] = "INTEGER";
                list[11][2] = "DOUBLE";
                list[12][0] = "INTEGER";
                list[12][1] = "BIGINT";
                list[12][2] = "SMALLINT";
                list[13][0] = "INTEGER";
                list[13][1] = "BIGINT";
                list[13][2] = "INTEGER";
                list[14][0] = "INTEGER";
                list[14][1] = "BIGINT";
                list[14][2] = "BIGINT";
                list[15][0] = "INTEGER";
                list[15][1] = "BIGINT";
                list[15][2] = "DECIMAL";
                list[16][0] = "INTEGER";
                list[16][1] = "BIGINT";
                list[16][2] = "REAL";
                list[17][0] = "INTEGER";
                list[17][1] = "BIGINT";
                list[17][2] = "DOUBLE";
                list[18][0] = "INTEGER";
                list[18][1] = "DECIMAL";
                list[18][2] = "SMALLINT";
                list[19][0] = "INTEGER";
                list[19][1] = "DECIMAL";
                list[19][2] = "INTEGER";
                list[20][0] = "INTEGER";
                list[20][1] = "DECIMAL";
                list[20][2] = "BIGINT";
                list[21][0] = "INTEGER";
                list[21][1] = "DECIMAL";
                list[21][2] = "DECIMAL";
                list[22][0] = "INTEGER";
                list[22][1] = "DECIMAL";
                list[22][2] = "REAL";
                list[23][0] = "INTEGER";
                list[23][1] = "DECIMAL";
                list[23][2] = "DOUBLE";
                list[24][0] = "INTEGER";
                list[24][1] = "REAL";
                list[24][2] = "SMALLINT";
                list[25][0] = "INTEGER";
                list[25][1] = "REAL";
                list[25][2] = "INTEGER";
                list[26][0] = "INTEGER";
                list[26][1] = "REAL";
                list[26][2] = "BIGINT";
                list[27][0] = "INTEGER";
                list[27][1] = "REAL";
                list[27][2] = "DECIMAL";
                list[28][0] = "INTEGER";
                list[28][1] = "REAL";
                list[28][2] = "REAL";
                list[29][0] = "INTEGER";
                list[29][1] = "REAL";
                list[29][2] = "DOUBLE";
                list[30][0] = "INTEGER";
                list[30][1] = "DOUBLE";
                list[30][2] = "SMALLINT";
                list[31][0] = "INTEGER";
                list[31][1] = "DOUBLE";
                list[31][2] = "INTEGER";
                list[32][0] = "INTEGER";
                list[32][1] = "DOUBLE";
                list[32][2] = "BIGINT";
                list[33][0] = "INTEGER";
                list[33][1] = "DOUBLE";
                list[33][2] = "DECIMAL";
                list[34][0] = "INTEGER";
                list[34][1] = "DOUBLE";
                list[34][2] = "REAL";
                list[35][0] = "INTEGER";
                list[35][1] = "DOUBLE";
                list[35][2] = "DOUBLE";
                break;
            }
            case 660: {
                list = new String[][]{new String[2], new String[2], new String[2], new String[2], new String[3], new String[3], new String[3], new String[3]};
                list[0][0] = "DBCLOB";
                list[0][1] = "GRAPHIC";
                list[1][0] = "DBCLOB";
                list[1][1] = "VARGRAPHIC";
                list[2][0] = "DBCLOB";
                list[2][1] = "LONG VARGRAPHIC";
                list[3][0] = "DBCLOB";
                list[3][1] = "DBCLOB";
                list[4][0] = "DBCLOB";
                list[4][1] = "GRAPHIC";
                list[4][2] = "INTEGER";
                list[5][0] = "DBCLOB";
                list[5][1] = "VARGRAPHIC";
                list[5][2] = "INTEGER";
                list[6][0] = "DBCLOB";
                list[6][1] = "LONG VARGRAPHIC";
                list[6][2] = "INTEGER";
                list[7][0] = "DBCLOB";
                list[7][1] = "DBCLOB";
                list[7][2] = "INTEGER";
                break;
            }
            case 670: {
                list = new String[][]{new String[2], new String[2], new String[2], new String[2], new String[3], new String[3], new String[3], new String[3]};
                list[0][0] = "GRAPHIC";
                list[0][1] = "GRAPHIC";
                list[1][0] = "GRAPHIC";
                list[1][1] = "VARGRAPHIC";
                list[2][0] = "GRAPHIC";
                list[2][1] = "LONG VARGRAPHIC";
                list[3][0] = "GRAPHIC";
                list[3][1] = "DBCLOB";
                list[4][0] = "GRAPHIC";
                list[4][1] = "GRAPHIC";
                list[4][2] = "INTEGER";
                list[5][0] = "GRAPHIC";
                list[5][1] = "VARGRAPHIC";
                list[5][2] = "INTEGER";
                list[6][0] = "GRAPHIC";
                list[6][1] = "LONG VARGRAPHIC";
                list[6][2] = "INTEGER";
                list[7][0] = "GRAPHIC";
                list[7][1] = "DBCLOB";
                list[7][2] = "INTEGER";
                break;
            }
            case 680: {
                list = new String[][]{new String[2], new String[2], new String[2], new String[2], new String[3], new String[3], new String[3], new String[3], new String[2], new String[2], new String[2]};
                list[0][0] = "VARCHAR";
                list[0][1] = "CHARACTER";
                list[1][0] = "VARCHAR";
                list[1][1] = "VARCHAR";
                list[2][0] = "VARCHAR";
                list[2][1] = "LONG VARCHAR";
                list[3][0] = "VARCHAR";
                list[3][1] = "CLOB";
                list[4][0] = "VARCHAR";
                list[4][1] = "CHARACTER";
                list[4][2] = "INTEGER";
                list[5][0] = "VARCHAR";
                list[5][1] = "VARCHAR";
                list[5][2] = "INTEGER";
                list[6][0] = "VARCHAR";
                list[6][1] = "LONG VARCHAR";
                list[6][2] = "INTEGER";
                list[7][0] = "VARCHAR";
                list[7][1] = "CLOB";
                list[7][2] = "INTEGER";
                list[8][0] = "VARCHAR";
                list[8][1] = "DATE";
                list[9][0] = "VARCHAR";
                list[9][1] = "TIME";
                list[10][0] = "VARCHAR";
                list[10][1] = "TIMESTAMP";
                break;
            }
            case 690: {
                list = new String[][]{new String[2], new String[2], new String[2], new String[2], new String[3], new String[3], new String[3], new String[3], new String[2]};
                list[0][0] = "VARGRAPHIC";
                list[0][1] = "GRAPHIC";
                list[1][0] = "VARGRAPHIC";
                list[1][1] = "VARGRAPHIC";
                list[2][0] = "VARGRAPHIC";
                list[2][1] = "LONG VARGRAPHIC";
                list[3][0] = "VARGRAPHIC";
                list[3][1] = "DBCLOB";
                list[4][0] = "VARGRAPHIC";
                list[4][1] = "GRAPHIC";
                list[4][2] = "INTEGER";
                list[5][0] = "VARGRAPHIC";
                list[5][1] = "VARGRAPHIC";
                list[5][2] = "INTEGER";
                list[6][0] = "VARGRAPHIC";
                list[6][1] = "LONG VARGRAPHIC";
                list[6][2] = "INTEGER";
                list[7][0] = "VARGRAPHIC";
                list[7][1] = "DBCLOB";
                list[7][2] = "INTEGER";
                list[8][0] = "VARGRAPHIC";
                list[8][1] = "VARCHAR";
                break;
            }
            case 700: {
                list = new String[1][5];
                list[0][0] = "BLOB";
                list[0][1] = "BLOB";
                list[0][2] = "INTEGER";
                list[0][3] = "INTEGER";
                list[0][4] = "INTEGER";
                break;
            }
            case 710: {
                list = new String[][]{new String[1]};
                list[0][0] = "STRING";
                break;
            }
            case 720: {
                list = new String[2][2];
                list[0][0] = "SMALLINT";
                list[0][1] = "DB2TEXTFH";
                list[1][0] = "SMALLINT";
                list[1][1] = "DB2TEXTH";
                break;
            }
            case 730: {
                list = new String[2][3];
                list[0][0] = "INTEGER";
                list[0][1] = "DB2TEXTFH";
                list[0][2] = "LONG VARCHAR";
                list[1][0] = "INTEGER";
                list[1][1] = "DB2TEXTH";
                list[1][2] = "LONG VARCHAR";
                break;
            }
            case 740: {
                list = new String[][]{new String[2], new String[3]};
                list[0][0] = "DB2TEXTFH";
                list[0][1] = "DB2TEXTFH";
                list[1][0] = "DB2TEXTFH";
                list[1][1] = "DB2TEXTFH";
                list[1][2] = "VARCHAR(150)";
                break;
            }
            case 750: {
                list = new String[][]{new String[2], new String[2], new String[3], new String[3], new String[3], new String[3]};
                list[0][0] = "VARCHAR(30)";
                list[0][1] = "DB2TEXTFH";
                list[1][0] = "VARCHAR(30)";
                list[1][1] = "DB2TEXTH";
                list[2][0] = "DB2TEXTFH";
                list[2][1] = "DB2TEXTFH";
                list[2][2] = "VARCHAR(30)";
                list[3][0] = "DB2TEXTH";
                list[3][1] = "DB2TEXTFH";
                list[3][2] = "VARCHAR(30)";
                list[4][0] = "DB2TEXTFH";
                list[4][1] = "DB2TEXTH";
                list[4][2] = "VARCHAR(30)";
                list[5][0] = "DB2TEXTH";
                list[5][1] = "DB2TEXTH";
                list[5][2] = "VARCHAR(30)";
                break;
            }
            case 760: {
                list = new String[4][3];
                list[0][0] = "DB2TEXTFH";
                list[0][1] = "DB2TEXTHLISTP";
                list[0][2] = "INTEGER";
                list[1][0] = "DB2TEXTFH";
                list[1][1] = "DB2TEXTFHLISTP";
                list[1][2] = "INTEGER";
                list[2][0] = "DB2TEXTH";
                list[2][1] = "DB2TEXTHLISTP";
                list[2][2] = "INTEGER";
                list[3][0] = "DB2TEXTH";
                list[3][1] = "DB2TEXTFHLISTP";
                list[3][2] = "INTEGER";
                break;
            }
            case 770: {
                list = new String[4][3];
                list[0][0] = "DB2TEXTFHLISTP";
                list[0][1] = "DB2TEXTH";
                list[0][2] = "LONG VARCHAR";
                list[1][0] = "DB2TEXTHLISTP";
                list[1][1] = "DB2TEXTH";
                list[1][2] = "LONG VARCHAR";
                list[2][0] = "DB2TEXTFHLISTP";
                list[2][1] = "DB2TEXTFH";
                list[2][2] = "LONG VARCHAR";
                list[3][0] = "DB2TEXTHLISTP";
                list[3][1] = "DB2TEXTFH";
                list[3][2] = "LONG VARCHAR";
                break;
            }
            case 780: {
                list = new String[][]{new String[3], new String[5]};
                list[0][0] = "DB2TEXTH";
                list[0][1] = "VARCHAR(30)";
                list[0][2] = "VARCHAR(30)";
                list[1][0] = "DB2TEXTFH";
                list[1][1] = "CCSID";
                list[1][2] = "VARCHAR(30)";
                list[1][3] = "VARCHAR(30)";
                list[1][4] = "VARCHAR(150)";
                break;
            }
            case 790: {
                list = new String[][]{new String[2], new String[2], new String[3], new String[3], new String[3], new String[3]};
                list[0][0] = "VARCHAR(30)";
                list[0][1] = "DB2TEXTFH";
                list[1][0] = "VARCHAR(30)";
                list[1][1] = "DB2TEXTH";
                list[2][0] = "DB2TEXTFH";
                list[2][1] = "DB2TEXTH";
                list[2][2] = "VARCHAR(30)";
                list[3][0] = "DB2TEXTH";
                list[3][1] = "DB2TEXTH";
                list[3][2] = "VARCHAR(30)";
                list[4][0] = "DB2TEXTFH";
                list[4][1] = "DB2TEXTFH";
                list[4][2] = "VARCHAR(30)";
                list[5][0] = "DB2TEXTH";
                list[5][1] = "DB2TEXTFH";
                list[5][2] = "VARCHAR(30)";
                break;
            }
            case 800: {
                list = new String[2][2];
                list[0][0] = "INTEGER";
                list[0][1] = "DB2TEXTHLISTP";
                list[1][0] = "INTEGER";
                list[1][1] = "DB2TEXTFLISTP";
                break;
            }
            case 810: {
                list = new String[2][3];
                list[0][0] = "INTEGER";
                list[0][1] = "DB2TEXTFH";
                list[0][2] = "LONG VARCHAR";
                list[1][0] = "INTEGER";
                list[1][1] = "DB2TEXTH";
                list[1][2] = "LONG VARCHAR";
                break;
            }
            case 820: {
                list = new String[2][3];
                list[0][0] = "DOUBLE";
                list[0][1] = "DB2TEXTFH";
                list[0][2] = "LONG VARCHAR";
                list[1][0] = "DOUBLE";
                list[1][1] = "DB2TEXTH";
                list[1][2] = "LONG VARCHAR";
                break;
            }
            case 830: {
                list = new String[1][3];
                list[0][0] = "LONG VARCHAR";
                list[0][1] = "LONG VARCHAR";
                list[0][2] = "LONG VARCHAR";
                break;
            }
            case 840: {
                list = new String[1][5];
                list[0][0] = "LONG VARCHAR";
                list[0][1] = "schema";
                list[0][2] = "table";
                list[0][3] = "handle";
                list[0][4] = "LONG VARCHAR";
                break;
            }
            case 850: {
                list = new String[1][2];
                list[0][0] = "SMALLINT";
                list[0][1] = "handle";
                break;
            }
            case 860: {
                list = new String[1][2];
                list[0][0] = "SMALLINT";
                list[0][1] = "handle";
                break;
            }
            case 870: {
                list = new String[1][2];
                list[0][0] = "SMALLINT";
                list[0][1] = "handle";
                break;
            }
            case 880: {
                list = new String[1][2];
                list[0][0] = "INTEGER";
                list[0][1] = "handle";
                break;
            }
            case 890: {
                list = new String[][]{new String[2], new String[3]};
                list[0][0] = "LONG VARCHAR";
                list[0][1] = "handle";
                list[1][0] = "handle";
                list[1][1] = "handle";
                list[1][2] = "LONG VARCHAR";
                break;
            }
            case 900: {
                list = new String[1][2];
                list[0][0] = "VARCHAR(8)";
                list[0][1] = "handle";
                break;
            }
            case 910: {
                list = new String[][]{new String[2], new String[4], new String[4], new String[3], new String[5], new String[4], new String[6], new String[5], new String[5], new String[6], new String[6], new String[6], new String[6], new String[7], new String[7]};
                list[0][0] = "content";
                list[0][1] = "handle";
                list[1][0] = "content";
                list[1][1] = "handle";
                list[1][2] = "offset";
                list[1][3] = "size";
                list[2][0] = "content";
                list[2][1] = "handle";
                list[2][2] = "target_file";
                list[2][3] = "overwrite";
                list[3][0] = "content";
                list[3][1] = "handle";
                list[3][2] = "target_format";
                list[4][0] = "content";
                list[4][1] = "handle";
                list[4][2] = "target_file";
                list[4][3] = "overwrite";
                list[4][4] = "target_format";
                list[5][0] = "content";
                list[5][1] = "handle";
                list[5][2] = "target_format";
                list[5][3] = "conversion_options";
                list[6][0] = "content";
                list[6][1] = "handle";
                list[6][2] = "target_file";
                list[6][3] = "overwrite";
                list[6][4] = "target_format";
                list[6][5] = "conversion_options";
                list[7][0] = "handle";
                list[7][1] = "handle";
                list[7][2] = "content";
                list[7][3] = "source_format";
                list[7][4] = "target_file";
                list[8][0] = "handle";
                list[8][1] = "handle";
                list[8][2] = "source_file";
                list[8][3] = "source_format";
                list[8][4] = "stortype";
                list[9][0] = "handle";
                list[9][1] = "handle";
                list[9][2] = "content";
                list[9][3] = "target_file";
                list[9][4] = "attrs";
                list[9][5] = "thumbnail";
                list[10][0] = "handle";
                list[10][1] = "handle";
                list[10][2] = "source_file";
                list[10][3] = "stortype";
                list[10][4] = "attrs";
                list[10][5] = "thumbnail";
                list[11][0] = "handle";
                list[11][1] = "handle";
                list[11][2] = "content";
                list[11][3] = "source_format";
                list[11][4] = "target_format";
                list[11][5] = "target_file";
                list[12][0] = "handle";
                list[12][1] = "handle";
                list[12][2] = "source_file";
                list[12][3] = "source_format";
                list[12][4] = "target_format";
                list[12][5] = "target_file";
                list[13][0] = "handle";
                list[13][1] = "handle";
                list[13][2] = "content";
                list[13][3] = "source_format";
                list[13][4] = "target_format";
                list[13][5] = "conversion_options";
                list[13][6] = "target_file";
                list[14][0] = "handle";
                list[14][1] = "handle";
                list[14][2] = "source_file";
                list[14][3] = "source_format";
                list[14][4] = "target_format";
                list[14][5] = "conversion_options";
                list[14][6] = "target_file";
                break;
            }
            case 920: {
                list = new String[4][6];
                list[0][0] = "handle";
                list[0][1] = "dbname";
                list[0][2] = "content";
                list[0][3] = "format";
                list[0][4] = "target_file";
                list[0][5] = "comment";
                list[1][0] = "handle";
                list[1][1] = "dbname";
                list[1][2] = "source_file";
                list[1][3] = "format";
                list[1][4] = "stortype";
                list[1][5] = "comment";
                list[2][0] = "handle";
                list[2][1] = "dbname";
                list[2][2] = "content";
                list[2][3] = "target_file";
                list[2][4] = "comment";
                list[2][5] = "attrs";
                list[3][0] = "handle";
                list[3][1] = "dbname";
                list[3][2] = "source_file";
                list[3][3] = "stortype";
                list[3][4] = "comment";
                list[3][5] = "attrs";
                break;
            }
            case 930: {
                list = new String[][]{new String[6], new String[6], new String[7], new String[7], new String[7], new String[7], new String[8], new String[8]};
                list[0][0] = "handle";
                list[0][1] = "dbname";
                list[0][2] = "content";
                list[0][3] = "source_format";
                list[0][4] = "target_file";
                list[0][5] = "comment";
                list[1][0] = "handle";
                list[1][1] = "dbname";
                list[1][2] = "source_file";
                list[1][3] = "source_format";
                list[1][4] = "stortype";
                list[1][5] = "comment";
                list[2][0] = "handle";
                list[2][1] = "dbname";
                list[2][2] = "content";
                list[2][3] = "target_file";
                list[2][4] = "comment";
                list[2][5] = "attrs";
                list[2][6] = "thumbnail";
                list[3][0] = "handle";
                list[3][1] = "dbname";
                list[3][2] = "source_file";
                list[3][3] = "stortype";
                list[3][4] = "comment";
                list[3][5] = "attrs";
                list[3][6] = "thumbnail";
                list[4][0] = "handle";
                list[4][1] = "dbname";
                list[4][2] = "content";
                list[4][3] = "source_format";
                list[4][4] = "target_format";
                list[4][5] = "target_file";
                list[4][6] = "comment";
                list[5][0] = "handle";
                list[5][1] = "dbname";
                list[5][2] = "source_file";
                list[5][3] = "source_format";
                list[5][4] = "target_format";
                list[5][5] = "target_file";
                list[5][6] = "comment";
                list[6][0] = "handle";
                list[6][1] = "dbname";
                list[6][2] = "content";
                list[6][3] = "source_format";
                list[6][4] = "target_format";
                list[6][5] = "conversion_options";
                list[6][6] = "target_file";
                list[6][7] = "comment";
                list[7][0] = "handle";
                list[7][1] = "dbname";
                list[7][2] = "source_file";
                list[7][3] = "source_format";
                list[7][4] = "target_format";
                list[7][5] = "conversion_options";
                list[7][6] = "target_file";
                list[7][7] = "comment";
                break;
            }
            case 940: {
                list = new String[][]{new String[6], new String[6], new String[7], new String[7]};
                list[0][0] = "handle";
                list[0][1] = "dbname";
                list[0][2] = "content";
                list[0][3] = "format";
                list[0][4] = "target_file";
                list[0][5] = "comment";
                list[1][0] = "handle";
                list[1][1] = "dbname";
                list[1][2] = "source_file";
                list[1][3] = "format";
                list[1][4] = "stortype";
                list[1][5] = "comment";
                list[2][0] = "handle";
                list[2][1] = "dbname";
                list[2][2] = "content";
                list[2][3] = "target_file";
                list[2][4] = "comment";
                list[2][5] = "attrs";
                list[2][6] = "thumbnail";
                list[3][0] = "handle";
                list[3][1] = "dbname";
                list[3][2] = "source_file";
                list[3][3] = "stortype";
                list[3][4] = "comment";
                list[3][5] = "attrs";
                list[3][6] = "thumbnail";
                break;
            }
            case 950: {
                list = new String[1][2];
                list[0][0] = "INTEGER";
                list[0][1] = "handle";
                break;
            }
            case 960: {
                list = new String[1][2];
                list[0][0] = "VARCHAR(250)";
                list[0][1] = "handle";
                break;
            }
            case 970: {
                list = new String[1][3];
                list[0][0] = "SMALLINT";
                list[0][1] = "handle(DB2AUDIO)";
                list[0][2] = "instrument(VARCHAR(255))";
                break;
            }
            case 980: {
                list = new String[1][3];
                list[0][0] = "SMALLINT";
                list[0][1] = "handle(DB2AUDIO)";
                list[0][2] = "trackname(VARCHAR(255))";
                break;
            }
            case 990: {
                list = new String[1][2];
                list[0][0] = "VARCHAR(8)";
                list[0][1] = "handle";
                break;
            }
            case 1000: {
                list = new String[1][2];
                list[0][0] = "SMALLINT";
                list[0][1] = "handle(DB2VIDEO)";
                break;
            }
            case 1010: {
                list = new String[1][2];
                list[0][0] = "VARCHAR(1536)";
                list[0][1] = "handle(DB2AUDIO)";
                break;
            }
            case 1020: {
                list = new String[1][2];
                list[0][0] = "VARCHAR(1536)";
                list[0][1] = "handle(DB2AUDIO)";
                break;
            }
            case 1030: {
                list = new String[1][2];
                list[0][0] = "INTEGER";
                list[0][1] = "handle(DB2IMAGE|DB2VIDEO)";
                break;
            }
            case 1040: {
                list = new String[1][2];
                list[0][0] = "CHAR(8)";
                list[0][1] = "handle(DB2IMAGE|DB2AUDIO|DB2VIDEO)";
                break;
            }
            case 1050: {
                list = new String[1][2];
                list[0][0] = "TIMESTAMP";
                list[0][1] = "handle(DB2IMAGE|DB2AUDIO|DB2VIDEO)";
                break;
            }
            case 1060: {
                list = new String[1][2];
                list[0][0] = "INTEGER";
                list[0][1] = "handle(DB2VIDEO)";
                break;
            }
            case 1070: {
                list = new String[1][2];
                list[0][0] = "SMALLINT";
                list[0][1] = "handle(DB2AUDIO|DB2VIDEO)";
                break;
            }
            case 1080: {
                list = new String[1][2];
                list[0][0] = "SMALLINT";
                list[0][1] = "handle(DB2AUDIO|DB2VIDEO)";
                break;
            }
            case 1090: {
                list = new String[1][2];
                list[0][0] = "INTEGER";
                list[0][1] = "handle(DB2IMAGE)";
                break;
            }
            case 1100: {
                list = new String[1][2];
                list[0][0] = "INTEGER";
                list[0][1] = "handle(DB2VIDEO)";
                break;
            }
            case 1110: {
                list = new String[1][2];
                list[0][0] = "SMALLINT";
                list[0][1] = "handle(DB2VIDEO)";
                break;
            }
            case 1120: {
                list = new String[1][3];
                list[0][0] = "DOUBLE";
                list[0][1] = "imgHandle(DB2IMAGE)";
                list[0][2] = "VARCHAR(18)";
                break;
            }
            case 1130: {
                list = new String[1][3];
                list[0][0] = "DOUBLE";
                list[0][1] = "imgHandle(DB2IMAGE)";
                list[0][2] = "VARCHAR(1024)";
                break;
            }
            case 1140: {
                break;
            }
            case 1150: {
                break;
            }
            case 1160: {
                list = new String[][]{new String[7], new String[6], new String[7], new String[7], new String[7], new String[7], new String[8], new String[8]};
                list[0][0] = "handle";
                list[0][1] = "handle";
                list[0][2] = "content";
                list[0][3] = "source_format";
                list[0][4] = "target_file";
                list[0][5] = "attrs";
                list[0][6] = "comment";
                list[1][0] = "handle";
                list[1][1] = "handle";
                list[1][2] = "source_file";
                list[1][3] = "source_format";
                list[1][4] = "stortype";
                list[1][5] = "comment";
                list[2][0] = "handle";
                list[2][1] = "handle";
                list[2][2] = "content";
                list[2][3] = "target_file";
                list[2][4] = "comment";
                list[2][5] = "attrs";
                list[2][6] = "thumbnail";
                list[3][0] = "handle";
                list[3][1] = "handle";
                list[3][2] = "source_file";
                list[3][3] = "stortype";
                list[3][4] = "comment";
                list[3][5] = "attrs";
                list[3][6] = "thumbnail";
                list[4][0] = "handle";
                list[4][1] = "handle";
                list[4][2] = "content";
                list[4][3] = "source_format";
                list[4][4] = "target_format";
                list[4][5] = "target_file";
                list[4][6] = "comment";
                list[5][0] = "handle";
                list[5][1] = "handle";
                list[5][2] = "source_file";
                list[5][3] = "source_format";
                list[5][4] = "target_format";
                list[5][5] = "target_file";
                list[5][6] = "comment";
                list[6][0] = "handle";
                list[6][1] = "handle";
                list[6][2] = "content";
                list[6][3] = "source_format";
                list[6][4] = "target_format";
                list[6][5] = "target_file";
                list[6][6] = "conversion_options";
                list[6][7] = "comment";
                list[7][0] = "handle";
                list[7][1] = "handle";
                list[7][2] = "source_file";
                list[7][3] = "source_format";
                list[7][4] = "target_format";
                list[7][5] = "conversion_options";
                list[7][6] = "target_file";
                list[7][7] = "comment";
                break;
            }
            case 1170: {
                list = new String[1][2];
                list[0][0] = "INTEGER";
                list[0][1] = "handle(DB2AUDIO|DB2VIDEO)";
                break;
            }
            case 1180: {
                list = new String[1][2];
                list[0][0] = "INTEGER";
                list[0][1] = "handle(DB2IMAGE|DB2AUDIO|DB2VIDEO)";
                break;
            }
            case 1190: {
                list = new String[][]{new String[2], new String[3]};
                list[0][0] = "LONG VARCHAR FOR BIT DATA";
                list[0][1] = "handle(DB2IMAGE|DB2VIDEO)";
                list[1][0] = "handle(DB2IMAGE|DB2VIDEO)";
                list[1][1] = "handle(DB2IMAGE|DB2VIDEO)";
                list[1][2] = "new_thumbnail(LONG VARCHAR FOR BIT DATA)";
                break;
            }
            case 1200: {
                list = new String[1][2];
                list[0][0] = "SMALLINT";
                list[0][1] = "handle(DB2AUDIO)";
                break;
            }
            case 1210: {
                list = new String[1][2];
                list[0][0] = "SMALLINT";
                list[0][1] = "handle(DB2AUDIO)";
                break;
            }
            case 1220: {
                list = new String[1][2];
                list[0][0] = "CHAR(8)";
                list[0][1] = "handle(DB2IMAGE|DB2AUDIO|DB2VIDEO)";
                break;
            }
            case 1230: {
                list = new String[1][2];
                list[0][0] = "TIMESTAMP";
                list[0][1] = "handle(DB2IMAGE|DB2AUDIO|DB2VIDEO)";
                break;
            }
            case 1240: {
                list = new String[1][2];
                list[0][0] = "INTEGER";
                list[0][1] = "handle(DB2IMAGE|DB2VIDEO)";
                break;
            }
            case 1250: {
                list = new String[1][1];
                list[0][0] = "DECIMAL";
                break;
            }
            case 1260: {
                list = new String[1][2];
                list[0][0] = "instance";
                list[0][1] = "REF";
                break;
            }
            case 1270: {
                list = new String[][]{new String[2], new String[2], new String[3]};
                list[0][0] = "XML";
                list[0][1] = "xml-expression";
                list[1][0] = "XML";
                list[1][1] = "xml-expression ORDER BY sort-key";
                list[2][0] = "XML";
                list[2][1] = "xml-expression ORDER BY sort-key1";
                list[2][2] = "sort-key2";
                break;
            }
            case 1280: {
                list = new String[][]{new String[2], new String[2], new String[3], new String[4]};
                list[0][0] = "XML(SEQUENCE)";
                list[0][1] = "attribute-value";
                list[1][0] = "XML(SEQUENCE)";
                list[1][1] = "attribute-value AS attribute-name";
                list[2][0] = "XML(SEQUENCE)";
                list[2][1] = "attribute-value1 AS attribute-name1";
                list[2][2] = "attribute-value2 AS attribute-name2";
                list[3][0] = "XML(SEQUENCE)";
                list[3][1] = "attribute-value1";
                list[3][2] = "attribute-value2";
                list[3][3] = "attribute-value3";
                break;
            }
            case 1290: {
                list = new String[][]{new String[2], new String[3], new String[4]};
                list[0][0] = "XML";
                list[0][1] = "xml-expression";
                list[1][0] = "XML";
                list[1][1] = "xml-expression1";
                list[1][2] = "xml-expression2";
                list[2][0] = "XML";
                list[2][1] = "xml-expression1";
                list[2][2] = "xml-expression2";
                list[2][3] = "xml-expression3";
                break;
            }
            case 1300: {
                list = new String[][]{new String[2], new String[3], new String[3], new String[3], new String[4], new String[5], new String[4], new String[5], new String[4], new String[5], new String[4], new String[5], new String[6], new String[6], new String[6]};
                list[0][0] = "XML";
                list[0][1] = "NAME element-name";
                list[1][0] = "XML";
                list[1][1] = "NAME element-name";
                list[1][2] = "xmlnamespaces-function";
                list[2][0] = "XML";
                list[2][1] = "NAME element-name";
                list[2][2] = "xmlattributes-function";
                list[3][0] = "XML";
                list[3][1] = "NAME element-name";
                list[3][2] = "xml-element-content";
                list[4][0] = "XML";
                list[4][1] = "NAME element-name";
                list[4][2] = "xml-element-content1";
                list[4][3] = "xml-element-content2";
                list[5][0] = "XML";
                list[5][1] = "NAME element-name";
                list[5][2] = "xml-element-content1";
                list[5][3] = "xml-element-content2";
                list[5][4] = "xml-element-content3";
                list[6][0] = "XML";
                list[6][1] = "NAME element-name";
                list[6][2] = "xmlnamespaces-function";
                list[6][3] = "xml-element-content";
                list[7][0] = "XML";
                list[7][1] = "NAME element-name";
                list[7][2] = "xmlnamespaces-function";
                list[7][3] = "xml-element-content1";
                list[7][4] = "xml-element-content2";
                list[8][0] = "XML";
                list[8][1] = "NAME element-name";
                list[8][2] = "xmlattributes-function";
                list[8][3] = "xml-element-content";
                list[9][0] = "XML";
                list[9][1] = "NAME element-name";
                list[9][2] = "xmlattributes-function";
                list[9][3] = "xml-element-content1";
                list[9][4] = "xml-element-content2";
                list[10][0] = "XML";
                list[10][1] = "NAME element-name";
                list[10][2] = "xmlnamespaces-function";
                list[10][3] = "xmlattributes-function";
                list[11][0] = "XML";
                list[11][1] = "NAME element-name";
                list[11][2] = "xmlnamespaces-function";
                list[11][3] = "xmlattributes-function";
                list[11][4] = "xml-element-content";
                list[12][0] = "XML";
                list[12][1] = "NAME element-name";
                list[12][2] = "xmlnamespaces-function";
                list[12][3] = "xmlattributes-function";
                list[12][4] = "xml-element-content1";
                list[12][5] = "xml-element-content2";
                list[13][0] = "XML";
                list[13][1] = "NAME element-name";
                list[13][2] = "xmlnamespaces-function";
                list[13][3] = "xmlattributes-function";
                list[13][4] = "xml-element-content1";
                list[13][5] = "xml-element-content2 OPTION NULL ON NULL";
                list[14][0] = "XML";
                list[14][1] = "NAME element-name";
                list[14][2] = "xmlnamespaces-function";
                list[14][3] = "xmlattributes-function";
                list[14][4] = "xml-element-content1";
                list[14][5] = "xml-element-content2 OPTION EMPTY ON NULL";
                break;
            }
            case 1310: {
                list = new String[][]{new String[2], new String[3], new String[3], new String[4], new String[4], new String[4]};
                list[0][0] = "XML";
                list[0][1] = "xml-element-content";
                list[1][0] = "XML";
                list[1][1] = "xml-element-content1";
                list[1][2] = "xml-element-content2";
                list[2][0] = "XML";
                list[2][1] = "xml-element-content1 AS xml-element-name1";
                list[2][2] = "xml-element-content2 AS xml-element-name2";
                list[3][0] = "XML";
                list[3][1] = "xmlnamespaces-function";
                list[3][2] = "xml-element-content1";
                list[3][3] = "xml-element-content2";
                list[4][0] = "XML";
                list[4][1] = "xmlnamespaces-function";
                list[4][2] = "xml-element-content1";
                list[4][3] = "xml-element-content2 OPTION EMPTY ON NULL";
                list[5][0] = "XML";
                list[5][1] = "xmlnamespaces-function";
                list[5][2] = "xml-element-content1";
                list[5][3] = "xml-element-content2 OPTION NULL ON NULL";
                break;
            }
            case 1320: {
                list = new String[][]{new String[2], new String[3], new String[3], new String[3]};
                list[0][0] = "*";
                list[0][1] = "namespace-uri AS namespace-prefix";
                list[1][0] = "*";
                list[1][1] = "namespace-uri1 AS namespace-prefix1";
                list[1][2] = "namespace-uri2 AS namespace-prefix2";
                list[2][0] = "*";
                list[2][1] = "namespace-uri1 AS namespace-prefix1";
                list[2][2] = "DEFAULT namespace-uri2";
                list[3][0] = "*";
                list[3][1] = "namespace-uri AS namespace-prefix";
                list[3][2] = "NO DEFAULT";
                break;
            }
            case 1330: {
                list = new String[][]{new String[2], new String[2], new String[2], new String[2], new String[2]};
                list[0][0] = "*";
                list[0][1] = "xml-expression AS data-type";
                list[1][0] = "*";
                list[1][1] = "CONTENT xml-expression AS data-type";
                list[2][0] = "*";
                list[2][1] = "CONTENT xml-expression AS data-type INCLUDING XMLDECLARATION";
                list[3][0] = "*";
                list[3][1] = "CONTENT xml-expression AS data-type EXCLUDING XMLDECLARATION";
                list[4][0] = "*";
                list[4][1] = "CONTENT xml-expression AS data-type INCLUDING XMLDECLARATION VERSION '1.0'";
                break;
            }
            case 1340: {
                list = new String[][]{new String[2], new String[2], new String[2]};
                list[0][0] = "*";
                list[0][1] = "expression AS data-type";
                list[1][0] = "*";
                list[1][1] = "NULL AS data-type";
                list[2][0] = "*";
                list[2][1] = "parameter-marker AS data-type";
                break;
            }
            case 1350: {
                list = new String[][]{new String[2]};
                list[0][0] = "XML";
                list[0][1] = "string-expression";
                break;
            }
            case 1360: {
                list = new String[][]{new String[2], new String[2], new String[2], new String[3]};
                list[0][0] = "BOOLEAN";
                list[0][1] = "xquery-expression-constant";
                list[1][0] = "BOOLEAN";
                list[1][1] = "xquery-expression-constant PASSING xquery-variable-expression AS identifier";
                list[2][0] = "BOOLEAN";
                list[2][1] = "xquery-expression-constant PASSING BY REF xquery-variable-expression AS identifier";
                list[3][0] = "BOOLEAN";
                list[3][1] = "xquery-expression-constant PASSING BY REF xquery-variable-expression1 AS identifier1";
                list[3][2] = "xquery-variable-expression2 AS identifier2";
                break;
            }
            case 1370: {
                list = new String[][]{new String[2], new String[2], new String[2]};
                list[0][0] = "XML";
                list[0][1] = "DOCUMENT string-expression";
                list[1][0] = "XML";
                list[1][1] = "DOCUMENT string-expression STRIP WHITESPACE";
                list[2][0] = "XML";
                list[2][1] = "DOCUMENT string-expression PRESERVE WHITESPACE";
                break;
            }
            case 1380: {
                list = new String[][]{new String[2], new String[3]};
                list[0][0] = "XML";
                list[0][1] = "NAME identifier";
                list[1][0] = "XML";
                list[1][1] = "NAME identifier";
                list[1][2] = "string-expression";
                break;
            }
            case 1390: {
                list = new String[][]{new String[2], new String[2], new String[2], new String[3]};
                list[0][0] = "XML";
                list[0][1] = "xquery-expression-constant";
                list[1][0] = "XML";
                list[1][1] = "xquery-expression-constant PASSING xquery-variable-expression AS identifier";
                list[2][0] = "XML";
                list[2][1] = "xquery-expression-constant PASSING BY REF xquery-variable-expression AS identifier";
                list[3][0] = "XML";
                list[3][1] = "xquery-expression-constant PASSING BY REF xquery-variable-expression1 AS identifier1";
                list[3][2] = "xquery-variable-expression2 AS identifier2";
                break;
            }
            case 1400: {
                list = new String[][]{new String[2], new String[3], new String[4], new String[4], new String[5], new String[5], new String[6]};
                list[0][0] = "*";
                list[0][1] = "row-xquery-expression-constant COLUMNS column-name data-type";
                list[1][0] = "*";
                list[1][1] = "row-xquery-expression-constant COLUMNS column-name1 data-type1";
                list[1][2] = "column-name2 data-type2";
                list[2][0] = "*";
                list[2][1] = "row-xquery-expression-constant COLUMNS column-name1 data-type1";
                list[2][2] = "column-name2 data-type2";
                list[2][3] = "column-name3 data-type3";
                list[3][0] = "*";
                list[3][1] = "row-xquery-expression-constant PASSING xquery-variable-expression AS identifier COLUMNS column-name1 data-type1";
                list[3][2] = "column-name2 data-type2";
                list[3][3] = "column-name3 data-type3";
                list[4][0] = "*";
                list[4][1] = "xmlnamespaces-function";
                list[4][2] = "row-xquery-expression-constant PASSING xquery-variable-expression AS identifier COLUMNS column-name1 data-type1";
                list[4][3] = "column-name2 data-type2";
                list[4][4] = "column-name3 data-type3";
                list[5][0] = "*";
                list[5][1] = "xmlnamespaces-function";
                list[5][2] = "row-xquery-expression-constant PASSING BY REF xquery-variable-expression AS identifier COLUMNS column-name1 data-type1";
                list[5][3] = "column-name2 data-type2";
                list[5][4] = "column-name3 data-type3";
                list[6][0] = "*";
                list[6][1] = "xmlnamespaces-function";
                list[6][2] = "row-xquery-expression-constant PASSING xquery-variable-expression1 AS identifier1";
                list[6][3] = "xquery-variable-expression2 AS identifier2 COLUMNS column-name1 data-type1";
                list[6][4] = "column-name2 data-type2";
                list[6][5] = "column-name3 data-type3";
                break;
            }
            case 1410: {
                list = new String[][]{new String[2], new String[2], new String[2], new String[2], new String[2], new String[2], new String[2], new String[2], new String[2]};
                list[0][0] = "XML";
                list[0][1] = "xml-expression";
                list[1][0] = "XML";
                list[1][1] = "DOCUMENT xml-expression";
                list[2][0] = "XML";
                list[2][1] = "DOCUMENT xml-expression ACCORDING TO XMLSCHEMA ID registered-xml-schema-name";
                list[3][0] = "XML";
                list[3][1] = "DOCUMENT xml-expression ACCORDING TO XMLSCHEMA URI xml-uri";
                list[4][0] = "XML";
                list[4][1] = "DOCUMENT xml-expression ACCORDING TO XMLSCHEMA NO NAMESPACE";
                list[5][0] = "XML";
                list[5][1] = "DOCUMENT xml-expression ACCORDING TO XMLSCHEMA URI xml-uri1 LOCATION xml-uri2";
                list[6][0] = "XML";
                list[6][1] = "DOCUMENT xml-expression ACCORDING TO XMLSCHEMA URI xml-uri1 LOCATION xml-uri2 ELEMENT xml-element-name";
                list[7][0] = "XML";
                list[7][1] = "DOCUMENT xml-expression ACCORDING TO XMLSCHEMA URI xml-uri1 LOCATION xml-uri2 NAMESPACE xml-uri3 ELEMENT xml-element-name";
                list[8][0] = "XML";
                list[8][1] = "DOCUMENT xml-expression ACCORDING TO XMLSCHEMA URI xml-uri1 LOCATION xml-uri2 NO NAMESPACE ELEMENT xml-element-name";
            }
        }
        return list;
    }

    @Override
    protected void initAggregateFunctions() {
        super.initAggregateFunctions();
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
        tempMap.put("AVG", 420);
        tempMap.put("CORR", 640);
        tempMap.put("CORRELATION", 640);
        tempMap.put("COUNT", 520);
        tempMap.put("COUNT_BIG", 500);
        tempMap.put("COVAR", 640);
        tempMap.put("COVARIANCE", 640);
        tempMap.put("GROUPING", 490);
        tempMap.put("MAX", 530);
        tempMap.put("MIN", 530);
        tempMap.put("REGR_AVGX", 640);
        tempMap.put("REGR_AVGY", 640);
        tempMap.put("REGR_COUNT", 650);
        tempMap.put("REGR_ICPT", 640);
        tempMap.put("REGR_INTERCEPT", 640);
        tempMap.put("REGR_R2", 640);
        tempMap.put("REGR_SLOPE", 640);
        tempMap.put("REGR_SXX", 640);
        tempMap.put("REGR_SXY", 640);
        tempMap.put("REGR_SYY", 640);
        tempMap.put("STDDEV", 40);
        tempMap.put("SUM", 460);
        tempMap.put("VAR", 40);
        tempMap.put("VARIANCE", 40);
        Set keyset = tempMap.keySet();
        this.fAggregateFunctionNamesList.addAll(keyset);
        Collections.sort(this.fAggregateFunctionNamesList);
        this.fFuncNameToSigListMap.putAll(tempMap);
    }

    @Override
    protected void initConversionFunctions() {
        super.initConversionFunctions();
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
        tempMap.put("BIGINT", 430);
        tempMap.put("BLOB", 620);
        tempMap.put("CHAR", 320);
        tempMap.put("CLOB", 630);
        tempMap.put("DATE", 10);
        tempMap.put("DBCLOB", 660);
        tempMap.put("DEC", 120);
        tempMap.put("DECIMAL", 120);
        tempMap.put("DOUBLE", 330);
        tempMap.put("DOUBLE_PRECISION", 340);
        tempMap.put("FLOAT", 340);
        tempMap.put("GRAPHIC", 670);
        tempMap.put("INT", 440);
        tempMap.put("INTEGER", 440);
        tempMap.put("LONG_VARCHAR", 580);
        tempMap.put("LONG_VARGRAPHIC", 590);
        tempMap.put("REAL", 470);
        tempMap.put("SMALLINT", 450);
        tempMap.put("TIME", 400);
        tempMap.put("TIMESTAMP", 130);
        tempMap.put("VARCHAR", 680);
        tempMap.put("VARGRAPHIC", 690);
        Set keyset = tempMap.keySet();
        this.fConversionFunctionNamesList.addAll(keyset);
        Collections.sort(this.fConversionFunctionNamesList);
        this.fFuncNameToSigListMap.putAll(tempMap);
    }

    protected void initDatalinkFunctions() {
        this.fDatalinkFunctionNamesList = new ArrayList();
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
        tempMap.put("DLCOMMENT", 380);
        tempMap.put("DLLINKTYPE", 380);
        tempMap.put("DLURLCOMPLETE", 380);
        tempMap.put("DLURLPATH", 380);
        tempMap.put("DLURLPATHONLY", 380);
        tempMap.put("DLURLSCHEME", 380);
        tempMap.put("DLURLSERVER", 380);
        tempMap.put("DLVALUE", 110);
        Set keyset = tempMap.keySet();
        this.fDatalinkFunctionNamesList.addAll(keyset);
        Collections.sort(this.fDatalinkFunctionNamesList);
        this.fFuncNameToSigListMap.putAll(tempMap);
    }

    @Override
    protected void initDatetimeFunctions() {
        super.initDatetimeFunctions();
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
        tempMap.put("DAY", 20);
        tempMap.put("DAYOFWEEK", 180);
        tempMap.put("DAYOFWEEK_ISO", 180);
        tempMap.put("DAYOFYEAR", 180);
        tempMap.put("DAYNAME", 160);
        tempMap.put("DAYS", 180);
        tempMap.put("HOUR", 30);
        tempMap.put("JULIAN_DAY", 180);
        tempMap.put("MICROSECOND", 390);
        tempMap.put("MIDNIGHT_SECONDS", 410);
        tempMap.put("MINUTE", 30);
        tempMap.put("MONTH", 20);
        tempMap.put("MONTHNAME", 160);
        tempMap.put("QUARTER", 180);
        tempMap.put("SECOND", 30);
        tempMap.put("TIMESTAMPDIFF", 190);
        tempMap.put("TIMESTAMP_ISO", 170);
        tempMap.put("WEEK", 180);
        tempMap.put("WEEK_ISO", 180);
        tempMap.put("YEAR", 20);
        Set keyset = tempMap.keySet();
        this.fDatetimeFunctionNamesList.addAll(keyset);
        Collections.sort(this.fDatetimeFunctionNamesList);
        this.fFuncNameToSigListMap.putAll(tempMap);
    }

    protected void initDB2Functions() {
        this.fDB2FunctionNamesList = new ArrayList();
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
        tempMap.put("COALESCE", 600);
        tempMap.put("DEREF", 1260);
        tempMap.put("EVENT_MON_STATE", 360);
        tempMap.put("IDENTITY_VAL_LOCAL", 1250);
        tempMap.put("HEX", 510);
        tempMap.put("LENGTH", 520);
        tempMap.put("NULLIF", 540);
        tempMap.put("RAISE_ERROR", 560);
        tempMap.put("TABLE_NAME", 100);
        tempMap.put("TABLE_SCHEMA", 100);
        tempMap.put("TYPE_ID", 520);
        tempMap.put("TYPE_NAME", 510);
        tempMap.put("TYPE_SCHEMA", 510);
        tempMap.put("VALUE", 600);
        Set keyset = tempMap.keySet();
        this.fDB2FunctionNamesList.addAll(keyset);
        Collections.sort(this.fDB2FunctionNamesList);
        this.fFuncNameToSigListMap.putAll(tempMap);
    }

    protected void initMMDBExtenderFunctions() {
        this.fMMDBExtenderFunctionNamesList = new ArrayList();
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
        tempMap.put("MMDBSYS.ALIGNVALUE", 850);
        tempMap.put("MMDBSYS.ASPECTRATIO", 860);
        tempMap.put("MMDBSYS.BITSPERSAMPLE", 870);
        tempMap.put("MMDBSYS.BYTESPERSEC", 880);
        tempMap.put("MMDBSYS.COMMENT", 890);
        tempMap.put("MMDBSYS.COMPRESSTYPE", 900);
        tempMap.put("MMDBSYS.CONTENT", 910);
        tempMap.put("MMDBSYS.DB2AUDIO", 920);
        tempMap.put("MMDBSYS.DB2IMAGE", 930);
        tempMap.put("MMDBSYS.DB2VIDEO", 940);
        tempMap.put("MMDBSYS.DURATION", 950);
        tempMap.put("MMDBSYS.FILENAME", 960);
        tempMap.put("MMDBSYS.FINDINSTRUMENT", 970);
        tempMap.put("MMDBSYS.FINDTRACKNAME", 980);
        tempMap.put("MMDBSYS.FORMAT", 990);
        tempMap.put("MMDBSYS.FRAMERATE", 1000);
        tempMap.put("MMDBSYS.GETINSTRUMENTS", 1010);
        tempMap.put("MMDBSYS.GETTRACKNAMES", 1020);
        tempMap.put("MMDBSYS.HEIGHT", 1030);
        tempMap.put("MMDBSYS.IMPORTER", 1040);
        tempMap.put("MMDBSYS.IMPORTTIME", 1050);
        tempMap.put("MMDBSYS.MAXBYTESPERSEC", 1060);
        tempMap.put("MMDBSYS.NUMAUDIOTRACKS", 1070);
        tempMap.put("MMDBSYS.NUMCHANNELS", 1080);
        tempMap.put("MMDBSYS.NUMCOLORS", 1090);
        tempMap.put("MMDBSYS.NUMFRAMES", 1100);
        tempMap.put("MMDBSYS.NUMVIDEOTRACKS", 1110);
        tempMap.put("MMDBSYS.QBSCOREFROMNAME", 1120);
        tempMap.put("MMDBSYS.QBSCOREFROMSTR", 1130);
        tempMap.put("MMDBSYS.QBSCORETBFROMNAME", 1140);
        tempMap.put("MMDBSYS.QBSCORETBFROMSTR", 1150);
        tempMap.put("MMDBSYS.REPLACE", 1160);
        tempMap.put("MMDBSYS.SAMPLINGRATE", 1170);
        tempMap.put("MMDBSYS.SIZE", 1180);
        tempMap.put("MMDBSYS.THUMBNAIL", 1190);
        tempMap.put("MMDBSYS.TICKSPERQNOTE", 1200);
        tempMap.put("MMDBSYS.TICKSPERSEC", 1210);
        tempMap.put("MMDBSYS.UPDATER", 1220);
        tempMap.put("MMDBSYS.UPDATETIME", 1230);
        tempMap.put("MMDBSYS.WIDTH", 1240);
        Set keyset = tempMap.keySet();
        this.fMMDBExtenderFunctionNamesList.addAll(keyset);
        Collections.sort(this.fMMDBExtenderFunctionNamesList);
        this.fFuncNameToSigListMap.putAll(tempMap);
    }

    protected void initMQExtenderFunctions() {
        this.fMQExtenderFunctionNamesList = new ArrayList();
        HashMap tempMap = new HashMap();
        Set keyset = tempMap.keySet();
        this.fMQExtenderFunctionNamesList.addAll(keyset);
        Collections.sort(this.fMQExtenderFunctionNamesList);
        this.fFuncNameToSigListMap.putAll(tempMap);
    }

    @Override
    protected void initNumericFunctions() {
        super.initNumericFunctions();
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
        tempMap.put("ABS", 0);
        tempMap.put("ABSVAL", 0);
        tempMap.put("ACOS", 40);
        tempMap.put("ASIN", 40);
        tempMap.put("ATAN", 40);
        tempMap.put("ATAN2", 50);
        tempMap.put("CEIL", 0);
        tempMap.put("CEILING", 0);
        tempMap.put("COS", 40);
        tempMap.put("COT", 40);
        tempMap.put("DEGREES", 40);
        tempMap.put("DIGITS", 350);
        tempMap.put("EXP", 40);
        tempMap.put("FLOOR", 0);
        tempMap.put("LOG", 40);
        tempMap.put("LN", 40);
        tempMap.put("LOG10", 40);
        tempMap.put("MOD", 60);
        tempMap.put("POWER", 70);
        tempMap.put("RADIANS", 40);
        tempMap.put("RAND", 80);
        tempMap.put("ROUND", 150);
        tempMap.put("SIGN", 0);
        tempMap.put("SIN", 40);
        tempMap.put("SQRT", 40);
        tempMap.put("TAN", 40);
        tempMap.put("TRUNCATE", 150);
        tempMap.put("TRUNC", 150);
        tempMap.put("VAR", 40);
        tempMap.put("VARIANCE", 40);
        Set keyset = tempMap.keySet();
        this.fNumericFunctionNamesList.addAll(keyset);
        Collections.sort(this.fNumericFunctionNamesList);
        this.fFuncNameToSigListMap.putAll(tempMap);
    }

    @Override
    protected void initScalarFunctions() {
        super.initScalarFunctions();
        DBVersionHelper versionHelper = this.getVersionHelper();
        if (versionHelper.isDB2_LUW()) {
            this.fScalarFunctionNamesList.addAll(this.getDatalinkFunctionNames());
            this.fScalarFunctionNamesList.addAll(this.getMMDBExtenderFunctionNames());
            this.fScalarFunctionNamesList.addAll(this.getTextExtenderFunctionNames());
        }
        this.fScalarFunctionNamesList.addAll(this.getDB2FunctionNames());
        if (versionHelper.isDB2_LUW() && versionHelper.isAtLeast(8, 2) || versionHelper.isDB2_zOS() && versionHelper.isAtLeast(9)) {
            this.fScalarFunctionNamesList.addAll(this.getSQLXMLFunctionNames());
        }
        Collections.sort(this.fScalarFunctionNamesList);
        LinkedHashSet scalarFuncNameSet = new LinkedHashSet(this.fScalarFunctionNamesList);
        this.fScalarFunctionNamesList.clear();
        this.fScalarFunctionNamesList.addAll(scalarFuncNameSet);
    }

    @Override
    protected void initSpecialRegisters() {
        super.initSpecialRegisters();
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
        tempMap.put("CURRENT DATE", 710);
        tempMap.put("CURRENT DEFAULT TRANSFORM GROUP", 710);
        tempMap.put("CURRENT DEGREE", 710);
        tempMap.put("CURRENT EXPLAIN MODE", 710);
        tempMap.put("CURRENT EXPLAIN SNAPSHOT", 710);
        tempMap.put("CURRENT NODE", 710);
        tempMap.put("CURRENT PATH", 710);
        tempMap.put("CURRENT QUERY OPTIMIZATION", 710);
        tempMap.put("CURRENT REFRESH AGE", 710);
        tempMap.put("CURRENT SCHEMA", 710);
        tempMap.put("CURRENT SERVER", 710);
        tempMap.put("CURRENT TIME", 710);
        tempMap.put("CURRENT TIMESTAMP", 710);
        tempMap.put("CURRENT TIMEZONE", 710);
        tempMap.put("USER", 710);
        Set keyset = tempMap.keySet();
        this.fSpecialRegisterNamesList.addAll(keyset);
        Collections.sort(this.fSpecialRegisterNamesList);
        this.fFuncNameToSigListMap.putAll(tempMap);
    }

    protected void initSQLXMLFunctions() {
        this.fSQLXMLFunctionNamesList = new ArrayList();
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
        DBVersionHelper versionHelper = this.getVersionHelper();
        if (versionHelper.isDB2_LUW()) {
            if (versionHelper.isAtLeast(8, 2)) {
                tempMap.put("XMLAGG", 1270);
                tempMap.put("XMLATTRIBUTES", 1280);
                tempMap.put("XMLCONCAT", 1290);
                tempMap.put("XMLELEMENT", 1300);
                tempMap.put("XMLFOREST", 1310);
                tempMap.put("XMLNAMESPACES", 1320);
                tempMap.put("XMLSERIALIZE", 1330);
            }
            if (versionHelper.isAtLeast(9)) {
                tempMap.put("XMLCAST", 1340);
                tempMap.put("XMLCOMMENT", 1350);
                tempMap.put("XMLDOCUMENT", 1290);
                tempMap.put("XMLPARSE", 1370);
                tempMap.put("XMLPI", 1380);
                tempMap.put("XMLQUERY", 1390);
                tempMap.put("XMLTABLE", 1400);
                tempMap.put("XMLTEXT", 1350);
                tempMap.put("XMLVALIDATE", 1410);
            }
        } else if (versionHelper.isDB2_zOS() && versionHelper.isAtLeast(9)) {
            tempMap.put("XMLAGG", 1270);
            tempMap.put("XMLATTRIBUTES", 1280);
            tempMap.put("XMLCOMMENT", 1350);
            tempMap.put("XMLCONCAT", 1290);
            tempMap.put("XMLDOCUMENT", 1290);
            tempMap.put("XMLELEMENT", 1300);
            tempMap.put("XMLFOREST", 1310);
            tempMap.put("XMLNAMESPACES", 1320);
            tempMap.put("XMLPARSE", 1370);
            tempMap.put("XMLPI", 1380);
            tempMap.put("XMLQUERY", 1390);
            tempMap.put("XMLSERIALIZE", 1330);
            tempMap.put("XMLTEXT", 1350);
        }
        Set keyset = tempMap.keySet();
        this.fSQLXMLFunctionNamesList.addAll(keyset);
        Collections.sort(this.fSQLXMLFunctionNamesList);
        this.fFuncNameToSigListMap.putAll(tempMap);
    }

    @Override
    protected void initStringFunctions() {
        super.initStringFunctions();
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
        tempMap.put("ASCII", 200);
        tempMap.put("CHR", 210);
        tempMap.put("DIFFERENCE", 280);
        tempMap.put("GENERATE_UNIQUE", 90);
        tempMap.put("INSERT", 220);
        tempMap.put("LCASE", 240);
        tempMap.put("LEFT", 290);
        tempMap.put("LOCATE", 260);
        tempMap.put("LOWER", 250);
        tempMap.put("LTRIM", 230);
        tempMap.put("POSSTR", 570);
        tempMap.put("REPEAT", 290);
        tempMap.put("REPLACE", 310);
        tempMap.put("RIGHT", 290);
        tempMap.put("RTRIM", 230);
        tempMap.put("SOUNDEX", 270);
        tempMap.put("SPACE", 300);
        tempMap.put("SUBSTR", 610);
        tempMap.put("TRANSLATE", 140);
        tempMap.put("UCASE", 370);
        tempMap.put("UPPER", 370);
        Set keyset = tempMap.keySet();
        this.fStringFunctionNamesList.addAll(keyset);
        Collections.sort(this.fStringFunctionNamesList);
        this.fFuncNameToSigListMap.putAll(tempMap);
    }

    protected void initTextExtenderFunctions() {
        this.fTextExtenderFunctionNamesList = new ArrayList();
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
        tempMap.put("DB2TX.CCSID", 720);
        tempMap.put("DB2TX.CONTAINS", 730);
        tempMap.put("DB2TX.FILE", 740);
        tempMap.put("DB2TX.FORMAT", 750);
        tempMap.put("DB2TX.HANDLE", 760);
        tempMap.put("DB2TX.HANDLE_LIST", 770);
        tempMap.put("DB2TX.INIT_TEXT_HANDLE", 780);
        tempMap.put("DB2TX.LANGUAGE", 790);
        tempMap.put("DB2TX.NO_OF_DOCUMENTS", 800);
        tempMap.put("DB2TX.NO_OF_MATCHES", 810);
        tempMap.put("DB2TX.RANK", 820);
        tempMap.put("DB2TX.REFINE", 830);
        tempMap.put("DB2TX.SEARCH_RESULT", 840);
        Set keyset = tempMap.keySet();
        this.fTextExtenderFunctionNamesList.addAll(keyset);
        Collections.sort(this.fTextExtenderFunctionNamesList);
        this.fFuncNameToSigListMap.putAll(tempMap);
    }

    @Override
    protected void initUserDefinedFunctions() {
        super.initUserDefinedFunctions();
    }
}

