/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.debug.core.pathmapper.LocalFileSearchEngine;
import org.eclipse.php.internal.debug.core.pathmapper.LocalFileSearchResult;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.zend.communication.IRemoteFileContentRequestor;
import org.eclipse.php.internal.debug.core.zend.communication.RemoteFileStorage;
import org.eclipse.php.internal.debug.ui.editor.RemoteFileStorageEditorInput;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class OpenRemoteFileExternalRequestor
implements IRemoteFileContentRequestor {
    public void fileContentReceived(byte[] content, String serverAddress, String originalURL, String fileName, final int lineNumber) {
        final IEditorInput editorInput = this.getEditorInput(content, serverAddress, originalURL, fileName);
        if (editorInput == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                OpenRemoteFileExternalRequestor.this.openEditor(editorInput, lineNumber);
            }
        });
    }

    public void requestCompleted(Exception e) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IEditorInput getEditorInput(byte[] content, String serverAddress, String originalURL, String remoteFile) {
        IWorkspaceRoot root;
        PathEntry entry;
        block11: {
            PathMapper mapper = null;
            entry = null;
            root = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = root.getFileForLocation((IPath)new Path(remoteFile));
            if (file != null) {
                return new FileEditorInput(file);
            }
            Server serverMatch = null;
            try {
                Server server;
                String serverURL = "http://" + serverAddress;
                serverMatch = ServersManager.findByURL((String)serverURL);
                if (serverMatch != null) {
                    mapper = PathMapperRegistry.getByServer((Server)serverMatch);
                    entry = mapper.getLocalFile(remoteFile);
                    if (entry == null) {
                        LocalFileSearchEngine searchEngine = new LocalFileSearchEngine();
                        LocalFileSearchResult searchResult = searchEngine.find((IResource)root, remoteFile, serverMatch.getUniqueId());
                        if (searchResult == null) {
                            File localFile = new File(remoteFile);
                            if (localFile.exists()) {
                                Path path = new Path(remoteFile);
                                String parentPath = path.removeLastSegments(1).toOSString();
                                IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(parentPath));
                                fileStore = fileStore.getChild(path.lastSegment());
                                return new FileStoreEditorInput(fileStore);
                            }
                            return new RemoteFileStorageEditorInput(new RemoteFileStorage(content, remoteFile, originalURL));
                        }
                        if (searchResult.getStatus().isOK() && searchResult.getPathEntry() == null) {
                            return new RemoteFileStorageEditorInput(new RemoteFileStorage(content, remoteFile, originalURL));
                        }
                        if (!searchResult.getStatus().isOK()) {
                            return null;
                        }
                        entry = searchResult.getPathEntry();
                    }
                    break block11;
                }
                Server[] serverArray = ServersManager.getServers();
                int n = serverArray.length;
                int n2 = 0;
                while (n2 < n && (entry = (mapper = PathMapperRegistry.getByServer((Server)(server = serverArray[n2]))).getLocalFile(remoteFile)) == null) {
                    ++n2;
                }
            }
            catch (InterruptedException e) {
                DebugPlugin.log((Throwable)e);
            }
        }
        if (entry != null) {
            return new FileEditorInput(root.getFile((IPath)new Path(entry.getPath())));
        }
        return new RemoteFileStorageEditorInput(new RemoteFileStorage(content, remoteFile, originalURL));
    }

    private void openEditor(IEditorInput editorInput, int lineNumber) {
        try {
            IEditorPart editorPart;
            IWorkbenchPage p = DLTKUIPlugin.getActivePage();
            if (p != null && (editorPart = p.openEditor(editorInput, EditorUtility.getEditorID((IEditorInput)editorInput, null), true)) != null) {
                IRegion region;
                if (lineNumber > 0 && editorPart instanceof StructuredTextEditor && (region = ((StructuredTextEditor)editorPart).getTextViewer().getDocument().getLineInformation(lineNumber - 1)) != null) {
                    EditorUtility.revealInEditor((IEditorPart)editorPart, (int)region.getOffset(), (int)region.getLength());
                }
                if (editorPart.getSite() != null) {
                    editorPart.getSite().getShell().forceActive();
                }
            }
        }
        catch (PartInitException e) {
            DebugPlugin.log((Throwable)e);
        }
        catch (BadLocationException e) {
            DebugPlugin.log((Throwable)e);
        }
    }
}

