/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.corext.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.visitor.ApplyAll;
import org.eclipse.php.internal.core.corext.dom.Selection;

public class SelectionAnalyzer
extends ApplyAll {
    private Selection fSelection;
    private boolean fTraverseSelectedNode;
    private ASTNode fLastCoveringNode;
    private List<ASTNode> fSelectedNodes;

    public SelectionAnalyzer(Selection selection, boolean traverseSelectedNode) {
        Assert.isNotNull((Object)selection);
        this.fSelection = selection;
        this.fTraverseSelectedNode = traverseSelectedNode;
    }

    public boolean hasSelectedNodes() {
        return this.fSelectedNodes != null && !this.fSelectedNodes.isEmpty();
    }

    public ASTNode[] getSelectedNodes() {
        if (this.fSelectedNodes == null || this.fSelectedNodes.isEmpty()) {
            return new ASTNode[0];
        }
        return this.fSelectedNodes.toArray(new ASTNode[this.fSelectedNodes.size()]);
    }

    public ASTNode getFirstSelectedNode() {
        if (this.fSelectedNodes == null || this.fSelectedNodes.isEmpty()) {
            return null;
        }
        return this.fSelectedNodes.get(0);
    }

    public ASTNode getLastSelectedNode() {
        if (this.fSelectedNodes == null || this.fSelectedNodes.isEmpty()) {
            return null;
        }
        return this.fSelectedNodes.get(this.fSelectedNodes.size() - 1);
    }

    public boolean isExpressionSelected() {
        if (!this.hasSelectedNodes()) {
            return false;
        }
        return this.fSelectedNodes.get(0) instanceof Expression;
    }

    public IRegion getSelectedNodeRange() {
        if (this.fSelectedNodes == null || this.fSelectedNodes.isEmpty()) {
            return null;
        }
        ASTNode firstNode = this.fSelectedNodes.get(0);
        ASTNode lastNode = this.fSelectedNodes.get(this.fSelectedNodes.size() - 1);
        int start = firstNode.getStart();
        return new Region(start, lastNode.getEnd() - start);
    }

    public ASTNode getLastCoveringNode() {
        return this.fLastCoveringNode;
    }

    protected Selection getSelection() {
        return this.fSelection;
    }

    @Override
    protected boolean apply(ASTNode node) {
        if (this.fSelection.liesOutside(node)) {
            return false;
        }
        if (this.fSelection.covers(node)) {
            if (this.isFirstNode()) {
                this.handleFirstSelectedNode(node);
            } else {
                this.handleNextSelectedNode(node);
            }
            return this.fTraverseSelectedNode;
        }
        if (this.fSelection.coveredBy(node)) {
            this.fLastCoveringNode = node;
            return true;
        }
        if (this.fSelection.endsIn(node)) {
            return this.handleSelectionEndsIn(node);
        }
        return true;
    }

    protected void reset() {
        this.fSelectedNodes = null;
    }

    protected void handleFirstSelectedNode(ASTNode node) {
        this.fSelectedNodes = new ArrayList<ASTNode>(5);
        this.fSelectedNodes.add(node);
    }

    protected void handleNextSelectedNode(ASTNode node) {
        if (this.getFirstSelectedNode().getParent() == node.getParent()) {
            this.fSelectedNodes.add(node);
        }
    }

    protected boolean handleSelectionEndsIn(ASTNode node) {
        return false;
    }

    protected List<ASTNode> internalGetSelectedNodes() {
        return this.fSelectedNodes;
    }

    private boolean isFirstNode() {
        return this.fSelectedNodes == null;
    }
}

