/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.JUnitMessages;
import org.eclipse.jdt.internal.junit.launcher.ITestFinder;
import org.eclipse.jdt.internal.junit.util.CoreTestSearchEngine;

public class JUnit3TestFinder
implements ITestFinder {
    @Override
    public void findTestsInContainer(IJavaElement element, Set<IType> result, IProgressMonitor pm) throws CoreException {
        if (element == null || result == null) {
            throw new IllegalArgumentException();
        }
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)pm, (String)JUnitMessages.TestSearchEngine_message_searching, (int)10);
        try {
            if (element instanceof IType) {
                if (this.isTest((IType)element)) {
                    result.add((IType)element);
                }
            } else if (element instanceof ICompilationUnit) {
                IType[] types;
                IType[] iTypeArray = types = ((ICompilationUnit)element).getAllTypes();
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    if (this.isTest(type)) {
                        result.add(type);
                    }
                    ++n2;
                }
            } else {
                JUnit3TestFinder.findTestCases(element, result, (IProgressMonitor)subMon.newChild(7));
                if (subMon.isCanceled()) {
                    return;
                }
                CoreTestSearchEngine.findSuiteMethods(element, result, (IProgressMonitor)subMon.newChild(3));
            }
            if (subMon.isCanceled()) {
                return;
            }
        }
        finally {
            subMon.done();
        }
    }

    private static void findTestCases(IJavaElement element, Set<IType> result, IProgressMonitor pm) throws JavaModelException {
        IJavaProject javaProject = element.getJavaProject();
        IType testCaseType = javaProject.findType("junit.framework.Test");
        if (testCaseType == null) {
            return;
        }
        IRegion region = CoreTestSearchEngine.getRegion(element);
        ITypeHierarchy typeHierarchy = javaProject.newTypeHierarchy(testCaseType, region, pm);
        CoreTestSearchEngine.findTestImplementorClasses(typeHierarchy, testCaseType, region, result);
    }

    @Override
    public boolean isTest(IType type) throws JavaModelException {
        return CoreTestSearchEngine.isAccessibleClass(type) && (CoreTestSearchEngine.hasSuiteMethod(type) || JUnit3TestFinder.isTestImplementor(type));
    }

    private static boolean isTestImplementor(IType type) throws JavaModelException {
        return !Flags.isAbstract((int)type.getFlags()) && CoreTestSearchEngine.isTestImplementor(type);
    }
}

