/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.registry;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.registry.Converters;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.util.MessageUtil;

public abstract class QueryContextImpl
implements IQueryContext {
    @Override
    public boolean available(Class<?> type, Argument.Advice advice) {
        return IQueryContext.class.isAssignableFrom(type);
    }

    @Override
    public Object get(Class<?> type, Argument.Advice advice) {
        return IQueryContext.class.isAssignableFrom(type) ? this : null;
    }

    @Override
    public boolean converts(Class<?> type, Argument.Advice advice) {
        return Converters.getConverter(type) != null;
    }

    @Override
    public String convertToString(Class<?> type, Argument.Advice advice, Object value) throws SnapshotException {
        return Converters.getConverter(type).toString(value);
    }

    @Override
    public Object convertToValue(Class<?> type, Argument.Advice advice, String value) throws SnapshotException {
        try {
            Converters.IConverter<Object> conv = Converters.getConverter(type);
            if (conv == null) {
                throw new SnapshotException(MessageUtil.format(Messages.QueryContextImpl_ImpossibleToConvert, type.getName()));
            }
            return conv.toObject(value, advice);
        }
        catch (IllegalArgumentException e) {
            throw new SnapshotException(e);
        }
    }
}

