/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.panes;

import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.mat.internal.snapshot.inspections.CompareTablesQuery;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.refined.Filter;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.panes.QueryResultPane;
import org.eclipse.mat.ui.internal.viewer.RefinedResultViewer;
import org.eclipse.mat.ui.util.EasyToolBarDropDown;
import org.eclipse.mat.ui.util.PopupMenu;

public class CompareTablesPane
extends QueryResultPane {
    private DiffOption diffOption;
    private SetopOption setopOption;

    @Override
    public void initWithArgument(Object argument) {
        super.initWithArgument(argument);
        IResult subject = ((QueryResult)argument).getSubject();
        if (subject instanceof CompareTablesQuery.TableComparisonResult) {
            CompareTablesQuery.Mode mode = ((CompareTablesQuery.TableComparisonResult)subject).getMode();
            switch (mode) {
                case ABSOLUTE: {
                    this.diffOption = DiffOption.ABSOLUTE;
                    break;
                }
                case DIFF_TO_FIRST: {
                    this.diffOption = DiffOption.DIFF_TO_BASE;
                    break;
                }
                case DIFF_TO_PREVIOUS: {
                    this.diffOption = DiffOption.DIFF_TO_PREV;
                    break;
                }
                case DIFF_RATIO_TO_FIRST: {
                    this.diffOption = DiffOption.DIFF_RATIO_TO_BASE;
                    break;
                }
                case DIFF_RATIO_TO_PREVIOUS: {
                    this.diffOption = DiffOption.DIFF_RATIO_TO_PREV;
                    break;
                }
            }
            CompareTablesQuery.Operation op = ((CompareTablesQuery.TableComparisonResult)subject).getOperation();
            switch (op) {
                case NONE: {
                    this.setopOption = SetopOption.NONE;
                    break;
                }
                case ALL: {
                    this.setopOption = SetopOption.ALL;
                    break;
                }
                case INTERSECTION: {
                    this.setopOption = SetopOption.INTERSECTION;
                    break;
                }
                case UNION: {
                    this.setopOption = SetopOption.UNION;
                    break;
                }
                case SYMMETRIC_DIFFERENCE: {
                    this.setopOption = SetopOption.SYMMETRIC_DIFFERENCE;
                    break;
                }
                case DIFFERENCE: {
                    this.setopOption = SetopOption.DIFFERENCE;
                    break;
                }
                case REVERSE_DIFFERENCE: {
                    this.setopOption = SetopOption.REVERSE_DIFFERENCE;
                    break;
                }
            }
        }
    }

    @Override
    public void contributeToToolBar(IToolBarManager manager) {
        this.addDiffOptions(manager);
        this.addSetopOptions(manager);
        this.addSelectColumns(manager);
        manager.add((IContributionItem)new Separator());
        super.contributeToToolBar(manager);
    }

    private void addSelectColumns(IToolBarManager manager) {
        final IResult result = this.viewer.getQueryResult().getSubject();
        if (result instanceof CompareTablesQuery.TableComparisonResult) {
            EasyToolBarDropDown selectColumnsAction = new EasyToolBarDropDown(Messages.CompareTablesPane_SelectDisplayedColumnsTooltip, MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/select_table.gif"), this){

                @Override
                public void contribute(PopupMenu menu) {
                    List columns = ((CompareTablesQuery.TableComparisonResult)result).getComparedColumns();
                    for (CompareTablesQuery.ComparedColumn comparedColumn : columns) {
                        menu.add(new SelectColumnAction(comparedColumn));
                    }
                }
            };
            manager.add((IAction)selectColumnsAction);
        }
    }

    private void addDiffOptions(IToolBarManager manager) {
        EasyToolBarDropDown diffOptionAction = new EasyToolBarDropDown(Messages.CompareTablesPane_ChooseDiffOptionTooltip, MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/grouping.gif"), this){

            @Override
            public void contribute(PopupMenu menu) {
                DiffOption[] diffOptionArray = DiffOption.values();
                int n = diffOptionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DiffOption opt = diffOptionArray[n2];
                    DiffOptionAction action = new DiffOptionAction(opt);
                    action.setEnabled(opt != CompareTablesPane.this.diffOption);
                    action.setChecked(opt == CompareTablesPane.this.diffOption);
                    menu.add(action);
                    ++n2;
                }
            }
        };
        manager.add((IAction)diffOptionAction);
    }

    private void addSetopOptions(IToolBarManager manager) {
        CompareTablesQuery.TableComparisonResult tcr;
        CompareTablesQuery.Operation op1;
        IResult result = this.viewer.getQueryResult().getSubject();
        if (result instanceof CompareTablesQuery.TableComparisonResult && (op1 = (tcr = (CompareTablesQuery.TableComparisonResult)result).getOperation()) == CompareTablesQuery.Operation.NONE) {
            CompareTablesQuery.Operation op2 = CompareTablesQuery.Operation.ALL;
            tcr.setOperation(op2);
            CompareTablesQuery.Operation op3 = tcr.getOperation();
            tcr.setOperation(op1);
            if (op3 != op2) {
                return;
            }
        }
        EasyToolBarDropDown setopOptionAction = new EasyToolBarDropDown(Messages.CompareTablesPane_ChooseOperation, MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/set_symmetric_difference.gif"), this){

            @Override
            public void contribute(PopupMenu menu) {
                SetopOption[] setopOptionArray = SetopOption.values();
                int n = setopOptionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SetopOption opt = setopOptionArray[n2];
                    SetopOptionAction action = new SetopOptionAction(opt);
                    action.setEnabled(opt != CompareTablesPane.this.setopOption);
                    action.setChecked(opt == CompareTablesPane.this.setopOption);
                    switch (opt) {
                        case UNION: {
                            action.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/set_union.gif"));
                            break;
                        }
                        case INTERSECTION: {
                            action.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/set_intersection.gif"));
                            break;
                        }
                        case SYMMETRIC_DIFFERENCE: {
                            action.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/set_symmetric_difference.gif"));
                            break;
                        }
                        case DIFFERENCE: {
                            action.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/set_differenceA.gif"));
                            break;
                        }
                        case REVERSE_DIFFERENCE: {
                            action.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/set_differenceB.gif"));
                            break;
                        }
                    }
                    menu.add(action);
                    ++n2;
                }
            }
        };
        manager.add((IAction)setopOptionAction);
    }

    private void rebuildViewer(QueryResult queryResult) {
        Column[] cols;
        Filter[] filters;
        int sortIndex = this.viewer.getResult().getSortColumn();
        Column.SortDirection direction = this.viewer.getResult().getSortDirection();
        Column sortCol = sortIndex >= 0 ? this.viewer.getResult().getColumns()[sortIndex] : null;
        boolean hasFilters = this.viewer.getResult().hasActiveFilter();
        if (hasFilters) {
            filters = this.viewer.getResult().getFilter();
            cols = this.viewer.getResult().getColumns();
        } else {
            filters = null;
            cols = null;
        }
        this.deactivateViewer();
        RefinedResultViewer v = this.createViewer(queryResult);
        if (sortCol != null) {
            Column[] columnArray = v.getResult().getColumns();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column col = columnArray[n2];
                if (col.getLabel().equals(sortCol.getLabel()) && Objects.equals(col.getFormatter(), sortCol.getFormatter()) && Objects.equals(col.getComparator(), sortCol.getComparator())) {
                    v.getResult().setSortOrder(col, direction);
                    break;
                }
                ++n2;
            }
        }
        if (hasFilters) {
            Filter[] filters2 = v.getResult().getFilter();
            Column[] cols2 = v.getResult().getColumns();
            int i = 0;
            while (i < filters.length) {
                if (filters[i].isActive()) {
                    int j = 0;
                    while (j < filters2.length) {
                        if (filters[i].getLabel().equals(filters2[j].getLabel()) && filters[i].getClass() == filters2[j].getClass() && cols[i].getLabel().equals(cols2[j].getLabel()) && Objects.equals(cols[i].getFormatter(), cols2[j].getFormatter())) {
                            filters2[j].setCriteria(filters[i].getCriteria());
                            v.getResult().filterChanged(filters[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        this.activateViewer(v);
    }

    public static enum DiffOption {
        ABSOLUTE(Messages.CompareTablesPane_AbsoluteValues),
        DIFF_TO_BASE(Messages.CompareTablesPane_DifferenceToBaseTable),
        DIFF_RATIO_TO_BASE(Messages.CompareTablesPane_PercentageDifferenceToBaseTable),
        DIFF_TO_PREV(Messages.CompareTablesPane_DifferenceToPrecedingTable),
        DIFF_RATIO_TO_PREV(Messages.CompareTablesPane_PercentageDifferenceToPrecedingTable);

        String label;

        private DiffOption(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    private class DiffOptionAction
    extends Action {
        private DiffOption diffOption;

        private DiffOptionAction(DiffOption diffOption) {
            super(diffOption.toString(), 2);
            this.diffOption = diffOption;
        }

        public void run() {
            if (!this.isChecked()) {
                return;
            }
            CompareTablesQuery.Mode mode = CompareTablesQuery.Mode.ABSOLUTE;
            switch (this.diffOption) {
                case DIFF_TO_PREV: {
                    mode = CompareTablesQuery.Mode.DIFF_TO_PREVIOUS;
                    break;
                }
                case DIFF_TO_BASE: {
                    mode = CompareTablesQuery.Mode.DIFF_TO_FIRST;
                    break;
                }
                case DIFF_RATIO_TO_PREV: {
                    mode = CompareTablesQuery.Mode.DIFF_RATIO_TO_PREVIOUS;
                    break;
                }
                case DIFF_RATIO_TO_BASE: {
                    mode = CompareTablesQuery.Mode.DIFF_RATIO_TO_FIRST;
                    break;
                }
            }
            IResult result = CompareTablesPane.this.viewer.getQueryResult().getSubject();
            if (result instanceof CompareTablesQuery.TableComparisonResult) {
                ((CompareTablesQuery.TableComparisonResult)result).setMode(mode);
            }
            final QueryResult queryResult = new QueryResult(CompareTablesPane.this.viewer.getQueryResult().getQuery(), CompareTablesPane.this.viewer.getQueryResult().getCommand(), result);
            new Job(this.getText()){

                protected IStatus run(IProgressMonitor monitor) {
                    if (!CompareTablesPane.this.top.isDisposed()) {
                        CompareTablesPane.this.top.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (CompareTablesPane.this.top.isDisposed()) {
                                    return;
                                }
                                CompareTablesPane.this.diffOption = DiffOptionAction.this.diffOption;
                                CompareTablesPane.this.rebuildViewer(queryResult);
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private class SelectColumnAction
    extends Action {
        CompareTablesQuery.ComparedColumn column;

        public SelectColumnAction(CompareTablesQuery.ComparedColumn column) {
            super(column.getDescription().getLabel(), 2);
            this.column = column;
            this.setChecked(column.isDisplayed());
        }

        public void run() {
            this.column.setDisplayed(!this.column.isDisplayed());
            IResult result = CompareTablesPane.this.viewer.getQueryResult().getSubject();
            if (result instanceof CompareTablesQuery.TableComparisonResult) {
                ((CompareTablesQuery.TableComparisonResult)result).updateColumns();
            }
            final QueryResult queryResult = new QueryResult(CompareTablesPane.this.viewer.getQueryResult().getQuery(), CompareTablesPane.this.viewer.getQueryResult().getCommand(), result);
            new Job(this.getText()){

                protected IStatus run(IProgressMonitor monitor) {
                    if (!CompareTablesPane.this.top.isDisposed()) {
                        CompareTablesPane.this.top.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (CompareTablesPane.this.top.isDisposed()) {
                                    return;
                                }
                                CompareTablesPane.this.rebuildViewer(queryResult);
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public static enum SetopOption {
        NONE(Messages.CompareTablesPane_Setop_None),
        ALL(Messages.CompareTablesPane_Setop_All),
        INTERSECTION(Messages.CompareTablesPane_Setop_Intersection),
        UNION(Messages.CompareTablesPane_Setop_Union),
        SYMMETRIC_DIFFERENCE(Messages.CompareTablesPane_Setop_SymmetricDifference),
        DIFFERENCE(Messages.CompareTablesPane_Setop_Difference),
        REVERSE_DIFFERENCE(Messages.CompareTablesPane_Setop_ReverseDifference);

        String label;

        private SetopOption(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    private class SetopOptionAction
    extends Action {
        private SetopOption setopOption;

        private SetopOptionAction(SetopOption setopOption) {
            super(setopOption.toString(), 2);
            this.setopOption = setopOption;
        }

        public void run() {
            if (!this.isChecked()) {
                return;
            }
            CompareTablesQuery.Operation op = CompareTablesQuery.Operation.NONE;
            switch (this.setopOption) {
                case ALL: {
                    op = CompareTablesQuery.Operation.ALL;
                    break;
                }
                case INTERSECTION: {
                    op = CompareTablesQuery.Operation.INTERSECTION;
                    break;
                }
                case UNION: {
                    op = CompareTablesQuery.Operation.UNION;
                    break;
                }
                case SYMMETRIC_DIFFERENCE: {
                    op = CompareTablesQuery.Operation.SYMMETRIC_DIFFERENCE;
                    break;
                }
                case DIFFERENCE: {
                    op = CompareTablesQuery.Operation.DIFFERENCE;
                    break;
                }
                case REVERSE_DIFFERENCE: {
                    op = CompareTablesQuery.Operation.REVERSE_DIFFERENCE;
                    break;
                }
            }
            IResult result = CompareTablesPane.this.viewer.getQueryResult().getSubject();
            if (result instanceof CompareTablesQuery.TableComparisonResult) {
                ((CompareTablesQuery.TableComparisonResult)result).setOperation(op);
            }
            final QueryResult queryResult = new QueryResult(CompareTablesPane.this.viewer.getQueryResult().getQuery(), CompareTablesPane.this.viewer.getQueryResult().getCommand(), result);
            new Job(this.getText()){

                protected IStatus run(IProgressMonitor monitor) {
                    if (!CompareTablesPane.this.top.isDisposed()) {
                        CompareTablesPane.this.top.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (CompareTablesPane.this.top.isDisposed()) {
                                    return;
                                }
                                CompareTablesPane.this.setopOption = SetopOptionAction.this.setopOption;
                                CompareTablesPane.this.rebuildViewer(queryResult);
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }
}

