/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.mat.hprof.IPositionInputStream;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.parser.io.BufferedRandomAccessInputStream;
import org.eclipse.mat.parser.io.SimpleBufferedRandomAccessInputStream;

public class DefaultPositionInputStream
extends FilterInputStream
implements DataInput,
IPositionInputStream {
    private final byte[] readBuffer = new byte[32];
    private long position = 0L;

    public DefaultPositionInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int res = super.read();
        if (res != -1) {
            ++this.position;
        }
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res = super.read(b, off, len);
        if (res != -1) {
            this.position += (long)res;
        }
        return res;
    }

    @Override
    public long skip(long n) throws IOException {
        long res = super.skip(n);
        this.position += res;
        return res;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readLimit) {
        throw new UnsupportedOperationException(Messages.IPositionInputStream_mark);
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException(Messages.IPositionInputStream_reset);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int total = 0;
        int cur = 0;
        while (total < n && (cur = (int)this.skip(n - total)) > 0) {
            total += cur;
        }
        return total;
    }

    @Override
    public int skipBytes(long n) throws IOException {
        long total = 0L;
        long cur = 0L;
        while (total < n && (cur = this.skip(n - total)) > 0L) {
            total += cur;
        }
        return (int)total;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        int n = 0;
        while (n < len) {
            int count = this.read(b, off + n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (this.in instanceof BufferedRandomAccessInputStream) {
            this.position = pos;
            ((BufferedRandomAccessInputStream)this.in).seek(pos);
        } else if (this.in instanceof SimpleBufferedRandomAccessInputStream) {
            this.position = pos;
            ((SimpleBufferedRandomAccessInputStream)this.in).seek(pos);
        } else {
            throw new UnsupportedOperationException(Messages.IPositionInputStream_seek);
        }
    }

    public void seek(int pos) throws IOException {
        if (this.in instanceof BufferedRandomAccessInputStream) {
            this.position = pos;
            ((BufferedRandomAccessInputStream)this.in).seek((long)pos);
        } else if (this.in instanceof SimpleBufferedRandomAccessInputStream) {
            this.position = pos;
            ((SimpleBufferedRandomAccessInputStream)this.in).seek((long)pos);
        } else {
            throw new UnsupportedOperationException(Messages.IPositionInputStream_seek);
        }
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        ++this.position;
        return ch;
    }

    @Override
    public int readInt() throws IOException {
        this.readFully(this.readBuffer, 0, 4);
        return DefaultPositionInputStream.readInt(this.readBuffer, 0);
    }

    @Override
    public long readLong() throws IOException {
        this.readFully(this.readBuffer, 0, 8);
        return DefaultPositionInputStream.readLong(this.readBuffer, 0);
    }

    @Override
    public boolean readBoolean() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        ++this.position;
        return ch != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        ++this.position;
        return (byte)ch;
    }

    @Override
    public char readChar() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        this.position += 2L;
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        this.position += 2L;
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        this.position += 2L;
        return (ch1 << 8) + (ch2 << 0);
    }

    protected int readIntArray(int[] a) throws IOException {
        byte[] b;
        int len = a.length * 4;
        byte[] byArray = b = len > this.readBuffer.length ? new byte[len] : this.readBuffer;
        if (this.read(b, 0, len) != len) {
            throw new IOException();
        }
        int ii = 0;
        while (ii < a.length) {
            a[ii] = DefaultPositionInputStream.readInt(b, ii * 4);
            ++ii;
        }
        return a.length;
    }

    public static int readInt(byte[] b, int offset) throws IOException {
        int ch1 = b[offset] & 0xFF;
        int ch2 = b[offset + 1] & 0xFF;
        int ch3 = b[offset + 2] & 0xFF;
        int ch4 = b[offset + 3] & 0xFF;
        if ((ch1 | ch2 | ch3 | ch4) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    protected int readLongArray(long[] a) throws IOException {
        byte[] b;
        int len = a.length * 8;
        byte[] byArray = b = len > this.readBuffer.length ? new byte[len] : this.readBuffer;
        if (this.read(b, 0, len) != len) {
            throw new IOException();
        }
        int ii = 0;
        while (ii < a.length) {
            a[ii] = DefaultPositionInputStream.readLong(b, ii * 8);
            ++ii;
        }
        return a.length;
    }

    public static long readLong(byte[] b, int offset) {
        return ((long)b[offset] << 56) + ((long)(b[offset + 1] & 0xFF) << 48) + ((long)(b[offset + 2] & 0xFF) << 40) + ((long)(b[offset + 3] & 0xFF) << 32) + ((long)(b[offset + 4] & 0xFF) << 24) + (long)((b[offset + 5] & 0xFF) << 16) + (long)((b[offset + 6] & 0xFF) << 8) + (long)((b[offset + 7] & 0xFF) << 0);
    }

    @Override
    public long readUnsignedInt() throws IOException {
        return 0xFFFFFFFFL & (long)this.readInt();
    }

    @Override
    public long readID(int idSize) throws IOException {
        return idSize == 4 ? 0xFFFFFFFFL & (long)this.readInt() : this.readLong();
    }
}

