/*
 * Decompiled with CFR 0.152.
 */
package lpg.lpgjavaruntime;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import lpg.lpgjavaruntime.IntSegmentedTuple;
import lpg.lpgjavaruntime.ParseErrorCodes;
import lpg.lpgjavaruntime.PrsStream;
import lpg.lpgjavaruntime.TokenStream;

public class Utf8LexStream
implements TokenStream,
ParseErrorCodes {
    static final int DEFAULT_TAB = 1;
    private int startIndex = -1;
    private int index = -1;
    private int lastIndex = -1;
    private byte[] inputChars;
    private boolean isUTF8;
    private byte[] charSize = new byte[256];
    private String fileName;
    private IntSegmentedTuple lineOffsets;
    private int tab = 1;
    private PrsStream prsStream;

    public Utf8LexStream() {
        this.lineOffsets = new IntSegmentedTuple(12);
        this.setLineOffset(-1);
    }

    public Utf8LexStream(int tab) {
        this();
        this.tab = tab;
    }

    public Utf8LexStream(String fileName) throws IOException {
        this(fileName, 1);
    }

    public Utf8LexStream(String fileName, int tab) throws IOException {
        this(tab);
        try {
            File f = new File(fileName);
            FileInputStream in = new FileInputStream(f);
            byte[] buffer = new byte[(int)f.length()];
            in.read(buffer, 0, buffer.length);
            this.initialize(buffer, fileName);
        }
        catch (Exception e) {
            IOException io = new IOException();
            System.err.println(e.getMessage());
            e.printStackTrace();
            throw io;
        }
    }

    public Utf8LexStream(byte[] inputChars, String fileName) {
        this();
        this.initialize(inputChars, fileName);
    }

    public Utf8LexStream(IntSegmentedTuple lineOffsets, byte[] inputChars, String fileName) {
        this.initialize(lineOffsets, inputChars, fileName);
    }

    public Utf8LexStream(byte[] inputChars, String fileName, int tab) {
        this(tab);
        this.initialize(inputChars, fileName);
    }

    public Utf8LexStream(IntSegmentedTuple lineOffsets, byte[] inputChars, String fileName, int tab) {
        this.tab = tab;
        this.initialize(lineOffsets, inputChars, fileName);
    }

    private void setUtf8() {
        int i = 0;
        while (i < 128) {
            this.charSize[i] = 1;
            ++i;
        }
        i = 128;
        while (i < 206) {
            this.charSize[i] = 0;
            ++i;
        }
        i = 206;
        while (i < 224) {
            this.charSize[i] = 2;
            ++i;
        }
        i = 224;
        while (i < 240) {
            this.charSize[i] = 3;
            ++i;
        }
        i = 240;
        while (i < 248) {
            this.charSize[i] = 4;
            ++i;
        }
        i = 248;
        while (i < 252) {
            this.charSize[i] = 5;
            ++i;
        }
        i = 252;
        while (i < 254) {
            this.charSize[i] = 6;
            ++i;
        }
        i = 254;
        while (i < 255) {
            this.charSize[i] = 0;
            ++i;
        }
    }

    public boolean isUtf8() {
        return this.isUTF8;
    }

    private void setAscii() {
        int i = 0;
        while (i < 255) {
            this.charSize[i] = 1;
            ++i;
        }
    }

    public boolean isAscii() {
        return !this.isUTF8;
    }

    public final int getCharSize(byte c) {
        return this.charSize[c & 0xFF];
    }

    public void initialize(byte[] inputChars, String fileName) {
        this.setInputChars(inputChars);
        this.setFileName(fileName);
        this.computeLineOffsets();
    }

    public void initialize(IntSegmentedTuple lineOffsets, byte[] inputChars, String fileName) {
        this.lineOffsets = lineOffsets;
        this.setInputChars(inputChars);
        this.setFileName(fileName);
    }

    public void computeLineOffsets() {
        this.lineOffsets.reset();
        this.setLineOffset(-1);
        int i = this.startIndex + 1;
        while (i < this.inputChars.length) {
            if (this.inputChars[i] == 10) {
                this.setLineOffset(i);
            }
            ++i;
        }
    }

    public void setInputChars(byte[] buffer) {
        this.inputChars = buffer;
        boolean bl = this.isUTF8 = buffer.length >= 3 && (buffer[0] & 0xFF) == 239 && (buffer[1] & 0xFF) == 187 && (buffer[2] & 0xFF) == 191;
        if (this.isUTF8) {
            this.setUtf8();
        } else {
            this.setAscii();
        }
        this.index = this.startIndex = this.isUTF8 ? 2 : -1;
        this.lastIndex = this.getPrevious(buffer.length);
    }

    public byte[] getInputChars() {
        return this.inputChars;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public void setLineOffsets(IntSegmentedTuple lineOffsets) {
        this.lineOffsets = lineOffsets;
    }

    public IntSegmentedTuple getLineOffsets() {
        return this.lineOffsets;
    }

    public void setTab(int tab) {
        this.tab = tab;
    }

    public int getTab() {
        return this.tab;
    }

    public void setStreamIndex(int index) {
        this.index = index;
    }

    public int getStreamIndex() {
        return this.index;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    @Override
    public int getStreamLength() {
        return this.inputChars.length;
    }

    public void setLineOffset(int i) {
        this.lineOffsets.add(i);
    }

    public int getLineOffset(int i) {
        return this.lineOffsets.get(i);
    }

    public void setPrsStream(PrsStream prsStream) {
        this.prsStream = prsStream;
    }

    public PrsStream getPrsStream() {
        return this.prsStream;
    }

    public String[] orderedExportedSymbols() {
        return null;
    }

    public int getUnicodeValue(int i) {
        int code = this.inputChars[i] & 0xFF;
        int size = this.charSize[code];
        block0 : switch (size) {
            case 1: {
                break;
            }
            case 0: {
                code = 0;
                break;
            }
            default: {
                code &= 255 >> size + 1;
                int k = 1;
                while (k < size) {
                    byte c = this.inputChars[i + k];
                    if ((c & 0xC0) != 128) {
                        code = 0;
                        break block0;
                    }
                    code = (code << 6) + (c & 0x3F);
                    ++k;
                }
                break block0;
            }
        }
        return code;
    }

    public int getLineCount() {
        return this.lineOffsets.size();
    }

    public int getLineNumberOfCharAt(int i) {
        int index = this.lineOffsets.binarySearch(i);
        return index < 0 ? -index : (index == 0 ? 1 : index);
    }

    public int getColumnOfCharAt(int i) {
        int lineNo = this.getLineNumberOfCharAt(i);
        int start = this.getLineOffset(lineNo - 1);
        int tab = this.getTab();
        if (start + 1 >= this.inputChars.length) {
            return 1;
        }
        int k = start + 1;
        while (k < i) {
            byte c = this.inputChars[k];
            if (c == 9) {
                int offset = k - start - 1;
                start -= tab - 1 - offset % tab;
            }
            start += this.getCharSize(c) - 1;
            k = this.getNext(k);
        }
        return i - start;
    }

    void reportError(int i) {
        this.reportError(i, i);
    }

    @Override
    public int getToken() {
        this.index = this.getNext(this.index);
        return this.index;
    }

    @Override
    public int getToken(int end_token) {
        this.index = this.index < end_token ? this.getNext(this.index) : this.lastIndex;
        return this.index;
    }

    @Override
    public int getKind(int i) {
        return 0;
    }

    @Override
    public int getNext(int i) {
        return i <= this.startIndex ? this.startIndex + 1 : (i < this.inputChars.length ? i + this.charSize[this.inputChars[i] & 0xFF] : this.lastIndex);
    }

    @Override
    public int getPrevious(int i) {
        int n = i = i > this.startIndex ? i - 1 : this.startIndex;
        if (this.isUTF8) {
            while (i > this.startIndex) {
                if ((this.inputChars[i] & 0xC0) != 128) break;
                --i;
            }
        }
        return i;
    }

    @Override
    public String getName(int i) {
        int c = this.getUnicodeValue(i);
        if (c <= 65535) {
            return "" + (char)c;
        }
        return "#x" + Integer.toHexString(i);
    }

    public String getName(int i, int k) {
        String name = "";
        int j = i;
        while (j <= k) {
            int c = this.getUnicodeValue(j);
            name = c <= 65535 ? String.valueOf(name) + (char)c : String.valueOf(name) + "#x" + Integer.toHexString(j);
            ++j;
        }
        return name;
    }

    @Override
    public int peek() {
        return this.getNext(this.index);
    }

    @Override
    public void reset(int i) {
        this.index = this.getPrevious(i);
    }

    @Override
    public void reset() {
        this.index = this.startIndex;
    }

    @Override
    public int badToken() {
        return 0;
    }

    @Override
    public int getLine(int i) {
        return this.getLineNumberOfCharAt(i);
    }

    @Override
    public int getColumn(int i) {
        return this.getColumnOfCharAt(i);
    }

    @Override
    public int getEndLine(int i) {
        return this.getLine(i);
    }

    @Override
    public int getEndColumn(int i) {
        return this.getColumnOfCharAt(i);
    }

    @Override
    public boolean afterEol(int i) {
        return i < 1 ? true : this.getLineNumberOfCharAt(this.getPrevious(i)) < this.getLineNumberOfCharAt(i);
    }

    @Override
    public void makeToken(int startLoc, int endLoc, int kind) {
        if (this.prsStream != null) {
            this.prsStream.makeToken(startLoc, endLoc, kind);
        } else {
            this.reportError(startLoc, endLoc);
        }
    }

    @Override
    public int getFirstErrorToken(int i) {
        return i;
    }

    @Override
    public int getLastErrorToken(int i) {
        return i;
    }

    @Override
    public int makeErrorToken(int firsttok, int lasttok, int errortok, int kind) {
        return 0;
    }

    @Override
    public void reportError(int i, String code) {
        this.reportError(i, i);
    }

    @Override
    public void reportError(int left_loc, int right_loc) {
        int end_loc;
        int errorCode = right_loc > this.lastIndex ? 10 : (left_loc == right_loc ? 0 : 11);
        int n = end_loc = left_loc == right_loc ? right_loc : right_loc - 1;
        String tokenText = errorCode == 10 ? "End-of-file " : (errorCode == 11 ? "\"" + this.getName(left_loc, right_loc) + "\" " : "\"" + this.getUnicodeValue(left_loc) + "\" ");
        String locationInfo = String.valueOf(this.getFileName()) + ':' + this.getLineNumberOfCharAt(left_loc) + ':' + this.getColumnOfCharAt(left_loc) + ':' + this.getLineNumberOfCharAt(end_loc) + ':' + this.getColumnOfCharAt(end_loc) + ": ";
        this.reportError(errorCode, locationInfo, tokenText);
    }

    @Override
    public void reportError(int errorCode, String locationInfo, String tokenText) {
        System.out.println(String.valueOf(locationInfo) + tokenText + errorMsgText[errorCode]);
    }

    @Override
    public void reportError(int errorCode, String locationInfo, int leftToken, int rightToken, String tokenText) {
        System.out.println(String.valueOf(locationInfo) + tokenText + errorMsgText[errorCode]);
    }
}

