/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.document;

import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.document.IJSONObject;
import org.eclipse.wst.json.core.document.IJSONPair;
import org.eclipse.wst.json.core.document.JSONException;
import org.eclipse.wst.json.core.internal.document.JSONDocumentImpl;
import org.eclipse.wst.json.core.internal.document.JSONModelImpl;
import org.eclipse.wst.json.core.internal.document.JSONPairImpl;
import org.eclipse.wst.json.core.internal.document.JSONStructureImpl;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public class JSONObjectImpl
extends JSONStructureImpl
implements IJSONObject {
    public JSONObjectImpl() {
        this(null);
    }

    public JSONObjectImpl(JSONObjectImpl object) {
        super(object);
    }

    @Override
    public IJSONNode cloneNode(boolean deep) {
        JSONObjectImpl cloned = new JSONObjectImpl(this);
        if (deep) {
            this.cloneChildNodes(cloned, deep);
        }
        return cloned;
    }

    @Override
    public short getNodeType() {
        return 0;
    }

    public boolean hasEndTag() {
        return this.getLastStructuredDocumentRegion() != null;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    public boolean isEmptyTag() {
        return false;
    }

    public boolean hasStartTag() {
        return this.getStructuredDocumentRegion() != null;
    }

    @Override
    public String getNodeName() {
        return "object";
    }

    @Override
    public String getNodeValue() throws JSONException {
        return null;
    }

    @Override
    public IJSONObject add(IJSONPair newAttr) {
        if (newAttr == null) {
            return null;
        }
        JSONPairImpl attr = (JSONPairImpl)newAttr;
        if (attr.getOwnerObject() != null) {
            return null;
        }
        attr.setOwnerObject(this);
        this.notifyPairReplaced(attr, null);
        return this;
    }

    protected void notifyPairReplaced(IJSONPair newPair, IJSONPair oldPair) {
        JSONDocumentImpl document = (JSONDocumentImpl)this.getContainerDocument();
        if (document == null) {
            return;
        }
        JSONModelImpl model = (JSONModelImpl)document.getModel();
        if (model == null) {
            return;
        }
        model.pairReplaced(this, newPair, oldPair);
    }

    @Override
    public IJSONObject remove(IJSONPair pair) {
        this.notifyPairReplaced(null, pair);
        return this;
    }

    public String toString() {
        IStructuredDocumentRegion endStructuredDocumentRegion;
        IStructuredDocumentRegion startStructuredDocumentRegion;
        StringBuilder buffer = new StringBuilder();
        String tagName = null;
        if (this.hasStartTag()) {
            buffer.append(tagName);
        }
        if (this.isEmptyTag()) {
            buffer.append('/');
        }
        if (this.hasEndTag()) {
            buffer.append('/');
            buffer.append(tagName);
        }
        if (buffer.length() == 0) {
            buffer.append(tagName);
        }
        if ((startStructuredDocumentRegion = this.getStartStructuredDocumentRegion()) != null) {
            buffer.append('@');
            buffer.append(startStructuredDocumentRegion.toString());
        }
        if ((endStructuredDocumentRegion = this.getEndStructuredDocumentRegion()) != null) {
            buffer.append('@');
            buffer.append(endStructuredDocumentRegion.toString());
        }
        return buffer.toString();
    }

    @Override
    public String getSimpleValue() {
        return null;
    }

    @Override
    public String getValueRegionType() {
        return null;
    }
}

