/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.resource;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProgressMonitorOutputStream
extends FilterOutputStream {
    private IProgressMonitor monitor;
    private int updateIncrement;
    private long bytesWritten;
    private long lastUpdate = -1L;
    private long nextUpdate;
    private long previousWritten;

    public ProgressMonitorOutputStream(OutputStream out, long bytesTotal, int updateIncrement, IProgressMonitor monitor) {
        super(out);
        this.updateIncrement = updateIncrement;
        this.monitor = monitor;
        this.update(true);
    }

    private void updateMonitor(long writtenBytes) {
        long progress = writtenBytes - this.previousWritten;
        while (progress > Integer.MAX_VALUE) {
            this.monitor.worked(Integer.MAX_VALUE);
            progress -= Integer.MAX_VALUE;
        }
        this.monitor.worked((int)progress);
        this.previousWritten = writtenBytes;
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.close();
        }
        finally {
            this.update(true);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.bytesWritten;
        this.update(false);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        try {
            this.out.write(buffer, offset, length);
            this.bytesWritten += (long)length;
            this.update(false);
        }
        catch (InterruptedIOException e) {
            this.bytesWritten += (long)e.bytesTransferred;
            this.update(false);
            throw e;
        }
    }

    private void update(boolean now) {
        if (this.bytesWritten >= this.nextUpdate || now) {
            this.nextUpdate = this.bytesWritten - this.bytesWritten % (long)this.updateIncrement;
            if (this.nextUpdate != this.lastUpdate) {
                this.updateMonitor(this.nextUpdate);
            }
            this.lastUpdate = this.nextUpdate;
            this.nextUpdate += (long)this.updateIncrement;
        }
    }
}

