/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.omg.kdm.source.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.modisco.omg.kdm.source.AbstractInventoryElement;
import org.eclipse.modisco.omg.kdm.source.BinaryFile;
import org.eclipse.modisco.omg.kdm.source.Directory;
import org.eclipse.modisco.omg.kdm.source.InventoryContainer;
import org.eclipse.modisco.omg.kdm.source.SourceFile;
import org.eclipse.modisco.omg.kdm.source.impl.BinaryFileImpl;
import org.eclipse.modisco.omg.kdm.source.impl.DirectoryImpl;
import org.eclipse.modisco.omg.kdm.source.impl.SourceFileImpl;

public class KDMSourceUtils {
    private static List<AbstractInventoryElement> getInventoryItemFromContainer(InventoryContainer container, List<String> filteredDirectoryName, Class<?> itemType, boolean recurseOnSubDirectories) {
        ArrayList<AbstractInventoryElement> list = new ArrayList<AbstractInventoryElement>();
        for (AbstractInventoryElement elt : container.getInventoryElement()) {
            if (KDMSourceUtils.isFiltered(elt.getName(), filteredDirectoryName)) continue;
            if (elt.getClass().equals(itemType)) {
                list.add(elt);
            }
            if (!(elt instanceof InventoryContainer) || !recurseOnSubDirectories) continue;
            list.addAll(KDMSourceUtils.getInventoryItemFromContainer((InventoryContainer)elt, filteredDirectoryName, itemType, recurseOnSubDirectories));
        }
        return list;
    }

    public static List<BinaryFile> getBinaryFilesFromInventoryModel(InventoryContainer container, ArrayList<String> filteredDirectoryName, boolean recurseOnSubDirectories) {
        ArrayList<BinaryFile> binaryFileList = new ArrayList<BinaryFile>();
        for (AbstractInventoryElement elt : KDMSourceUtils.getInventoryItemFromContainer(container, filteredDirectoryName, BinaryFileImpl.class, recurseOnSubDirectories)) {
            binaryFileList.add((BinaryFile)elt);
        }
        return binaryFileList;
    }

    public static List<SourceFile> getSourceFileFromInventoryModel(InventoryContainer container, List<String> filteredDirectoryName, boolean recurseOnSubDirectories) {
        ArrayList<SourceFile> sourceFileList = new ArrayList<SourceFile>();
        for (AbstractInventoryElement elt : KDMSourceUtils.getInventoryItemFromContainer(container, filteredDirectoryName, SourceFileImpl.class, recurseOnSubDirectories)) {
            sourceFileList.add((SourceFile)elt);
        }
        return sourceFileList;
    }

    public static List<Directory> getDirectoriesFromInventoryModel(InventoryContainer container, List<String> filteredDirectoryName, boolean recurseOnSubDirectories) {
        ArrayList<Directory> directoriesList = new ArrayList<Directory>();
        for (AbstractInventoryElement elt : KDMSourceUtils.getInventoryItemFromContainer(container, filteredDirectoryName, DirectoryImpl.class, recurseOnSubDirectories)) {
            directoriesList.add((Directory)elt);
        }
        return directoriesList;
    }

    private static boolean isFiltered(String name, List<String> filteredDirectoryName) {
        return filteredDirectoryName == null ? false : filteredDirectoryName.contains(name);
    }

    private KDMSourceUtils() {
    }

    public static Directory getDirectoryByPath(String path, InventoryContainer inventoryContainer) {
        for (Directory dir : KDMSourceUtils.getDirectoriesFromInventoryModel(inventoryContainer, null, true)) {
            if (!dir.getPath().equalsIgnoreCase(path)) continue;
            return dir;
        }
        return null;
    }
}

