/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.core.analysis;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.eclemma.core.EclEmmaStatus;
import org.eclipse.eclemma.internal.core.DebugOptions;
import org.eclipse.eclemma.internal.core.analysis.AnalyzedNodes;
import org.eclipse.eclemma.internal.core.analysis.ResourceTreeWalker;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataStore;

final class PackageFragementRootAnalyzer {
    private static final DebugOptions.ITracer TRACER = DebugOptions.ANALYSISTRACER;
    private final ExecutionDataStore executiondata;
    private final Map<Object, AnalyzedNodes> cache;

    PackageFragementRootAnalyzer(ExecutionDataStore executiondata) {
        this.executiondata = executiondata;
        this.cache = new HashMap<Object, AnalyzedNodes>();
    }

    AnalyzedNodes analyze(IPackageFragmentRoot root) throws CoreException {
        if (root.isExternal()) {
            return this.analyzeExternal(root);
        }
        return this.analyzeInternal(root);
    }

    private AnalyzedNodes analyzeInternal(IPackageFragmentRoot root) throws CoreException {
        IResource location = null;
        try {
            location = this.getClassfilesLocation(root);
            if (location == null) {
                TRACER.trace("No class files found for package fragment root {0}", root.getPath());
                return AnalyzedNodes.EMPTY;
            }
            AnalyzedNodes nodes = this.cache.get(location);
            if (nodes != null) {
                return nodes;
            }
            CoverageBuilder builder = new CoverageBuilder();
            Analyzer analyzer = new Analyzer(this.executiondata, (ICoverageVisitor)builder);
            new ResourceTreeWalker(analyzer).walk(location);
            nodes = new AnalyzedNodes(builder.getClasses(), builder.getSourceFiles());
            this.cache.put(location, nodes);
            return nodes;
        }
        catch (Exception e) {
            throw new CoreException(EclEmmaStatus.BUNDLE_ANALYSIS_ERROR.getStatus(root.getElementName(), location, e));
        }
    }

    private AnalyzedNodes analyzeExternal(IPackageFragmentRoot root) throws CoreException {
        IPath location = null;
        try {
            location = root.getPath();
            AnalyzedNodes nodes = this.cache.get(location);
            if (nodes != null) {
                return nodes;
            }
            CoverageBuilder builder = new CoverageBuilder();
            Analyzer analyzer = new Analyzer(this.executiondata, (ICoverageVisitor)builder);
            new ResourceTreeWalker(analyzer).walk(location);
            nodes = new AnalyzedNodes(builder.getClasses(), builder.getSourceFiles());
            this.cache.put(location, nodes);
            return nodes;
        }
        catch (Exception e) {
            throw new CoreException(EclEmmaStatus.BUNDLE_ANALYSIS_ERROR.getStatus(root.getElementName(), location, e));
        }
    }

    private IResource getClassfilesLocation(IPackageFragmentRoot root) throws CoreException {
        if (root.getKind() == 2) {
            return root.getResource();
        }
        IPath path = root.getRawClasspathEntry().getOutputLocation();
        if (path == null) {
            path = root.getJavaProject().getOutputLocation();
        }
        return root.getResource().getWorkspace().getRoot().findMember(path);
    }
}

