/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.ui.explorer.providers.content.virtual;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentService;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.providers.content.virtual.CreationInfoRegistry;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.providers.content.virtual.ICreationInfoProvider;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public abstract class VirtualNode
implements IVirtualNode,
IAdaptable {
    private String name;
    private String displayName;
    private Object parent;
    private List children = new LinkedList();

    public VirtualNode(String name, String displayName, Object parent) {
        this.name = name;
        this.displayName = displayName;
        this.parent = parent;
        if (parent != null && parent instanceof IVirtualNode) {
            ((IVirtualNode)parent).addChildren(this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName != null ? this.displayName : this.name;
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    protected List getChildren() {
        return this.children;
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public Object[] getChildrenArray() {
        return this.children.toArray(new Object[this.children.size()]);
    }

    @Override
    public void addChildren(Object child) {
        if (!this.children.contains(child)) {
            this.children.add(child);
        }
    }

    @Override
    public void removeChildren(Object child) {
        if (this.children.contains(child)) {
            this.children.remove(child);
        }
    }

    @Override
    public void removeAllChildren() {
        this.children.removeAll(this.children);
    }

    public boolean supports(EClass type) {
        return false;
    }

    @Override
    public void addChildren(Collection collection) {
        this.children.removeAll(this.children);
        this.children.addAll(collection);
    }

    @Override
    public ConnectionInfo getParentConnection() {
        return DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(this.getDatabase());
    }

    protected SQLObject getParentSQLObject() {
        Object parent = this;
        while (parent != null && !(parent instanceof SQLObject) && !((parent = ((IVirtualNode)parent).getParent()) instanceof SQLObject)) {
        }
        return parent instanceof SQLObject ? (SQLObject)parent : null;
    }

    protected Database getDatabase() {
        ContainmentService containment = RDBCorePlugin.getDefault().getContainmentService();
        SQLObject sqlObject = this.getParentSQLObject();
        while (sqlObject != null && !(sqlObject instanceof Database) && !((sqlObject = (SQLObject)containment.getContainer((EObject)sqlObject)) instanceof Database)) {
        }
        return sqlObject instanceof Database ? (Database)sqlObject : null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public String getFilterName(String virtualNodeType) {
        if (this.getParent() instanceof Schema) {
            Schema schema = (Schema)this.getParent();
            if (schema.getCatalog() == null) {
                return String.valueOf(schema.getName()) + "::" + virtualNodeType;
            }
            return String.valueOf(schema.getCatalog().getName()) + "::" + schema.getName() + "::" + virtualNodeType;
        }
        if (this.getParent() instanceof Catalog) {
            Catalog catalog = (Catalog)this.getParent();
            return String.valueOf(catalog.getName()) + "::" + virtualNodeType;
        }
        if (this.getParent() instanceof Routine) {
            Routine routine = (Routine)this.getParent();
            return String.valueOf(routine.getName()) + "::" + virtualNodeType;
        }
        return null;
    }

    public boolean isCreateActionSupported(DatabaseDefinition dbdef) {
        ICreationInfoProvider provider = CreationInfoRegistry.INSTANCE.getProvider(dbdef);
        if (provider != null) {
            return provider.isCreateActionSupported(this);
        }
        return true;
    }

    public boolean isCreateDistinctTypeSupported(DatabaseDefinition dbdef) {
        ICreationInfoProvider provider = CreationInfoRegistry.INSTANCE.getProvider(dbdef);
        if (provider != null) {
            return provider.isCreateDistinctType();
        }
        return true;
    }

    public boolean isCreateRowTypeSupported(DatabaseDefinition dbdef) {
        ICreationInfoProvider provider = CreationInfoRegistry.INSTANCE.getProvider(dbdef);
        if (provider != null) {
            return provider.isCreateRowTypeSupported();
        }
        return true;
    }
}

