/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.core.runtime.PlatformObject;

public class CPPBuiltinParameter
extends PlatformObject
implements ICPPParameter {
    private IType type;
    private int position;

    public static ICPPParameter[] createParameterList(ICPPFunctionType ft) {
        if (ft == null) {
            return ICPPParameter.EMPTY_CPPPARAMETER_ARRAY;
        }
        IType[] ptypes = ft.getParameterTypes();
        ICPPParameter[] result = new ICPPParameter[ptypes.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new CPPBuiltinParameter(ptypes[i]);
            ++i;
        }
        return result;
    }

    public CPPBuiltinParameter(IType type) {
        this.type = type;
        this.position = -1;
    }

    public CPPBuiltinParameter(IType type, int position) {
        this.type = type;
        this.position = position;
    }

    @Override
    public IType getType() {
        return this.type;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isExtern() {
        return false;
    }

    @Override
    public boolean isExternC() {
        return false;
    }

    @Override
    public boolean isAuto() {
        return false;
    }

    @Override
    public boolean isRegister() {
        return false;
    }

    @Override
    public String getName() {
        if (this.position != -1) {
            return "arg" + this.position;
        }
        return "";
    }

    @Override
    public char[] getNameCharArray() {
        return CharArrayUtils.EMPTY;
    }

    @Override
    public IScope getScope() {
        return null;
    }

    @Override
    public boolean hasDefaultValue() {
        return false;
    }

    @Override
    public IValue getDefaultValue() {
        return null;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isConstexpr() {
        return false;
    }

    @Override
    public String[] getQualifiedName() {
        return new String[0];
    }

    @Override
    public char[][] getQualifiedNameCharArray() {
        return new char[0][];
    }

    @Override
    public boolean isGloballyQualified() {
        return false;
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    @Override
    public IBinding getOwner() {
        return null;
    }

    @Override
    public IValue getInitialValue() {
        return null;
    }

    @Override
    public boolean isParameterPack() {
        return false;
    }
}

