/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.federation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedService;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;

public abstract class AbstractFederatedServiceResolver
implements FederatedServiceResolver {
    protected Map<String, FederatedService> endpointToService = new HashMap<String, FederatedService>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerService(String serviceUrl, FederatedService service) {
        Map<String, FederatedService> map = this.endpointToService;
        synchronized (map) {
            this.endpointToService.put(serviceUrl, service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(String serviceUrl) {
        FederatedService service;
        Map<String, FederatedService> map = this.endpointToService;
        synchronized (map) {
            service = this.endpointToService.remove(serviceUrl);
        }
        if (service != null && service.isInitialized()) {
            try {
                service.shutdown();
            }
            catch (QueryEvaluationException queryEvaluationException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FederatedService getService(String serviceUrl) throws QueryEvaluationException {
        FederatedService service;
        Map<String, FederatedService> map = this.endpointToService;
        synchronized (map) {
            service = this.endpointToService.get(serviceUrl);
            if (service == null) {
                service = this.createService(serviceUrl);
                this.endpointToService.put(serviceUrl, service);
            }
        }
        if (!service.isInitialized()) {
            service.initialize();
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasService(String serviceUrl) {
        Map<String, FederatedService> map = this.endpointToService;
        synchronized (map) {
            return this.endpointToService.containsKey(serviceUrl);
        }
    }

    protected abstract FederatedService createService(String var1) throws QueryEvaluationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAll() {
        Map<String, FederatedService> map = this.endpointToService;
        synchronized (map) {
            for (FederatedService service : this.endpointToService.values()) {
                try {
                    service.shutdown();
                }
                catch (QueryEvaluationException queryEvaluationException) {}
            }
            this.endpointToService.clear();
        }
    }

    public void shutDown() {
        this.unregisterAll();
    }
}

