/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.util.Locale;
import java.util.Set;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.manager.RepositoryInfo;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;

public class Show
extends ConsoleCommand {
    private static final String OUTPUT_SEPARATOR = "+----------";

    @Override
    public String getName() {
        return "show";
    }

    @Override
    public String getHelpShort() {
        return "Displays an overview of various resources";
    }

    @Override
    public String getHelpLong() {
        return "Usage:\nshow {r, repositories}   Shows all available repositories\nshow {n, namespaces}     Shows all namespaces\nshow {c, contexts}       Shows all context identifiers\n";
    }

    public Show(ConsoleIO consoleIO, ConsoleState state) {
        super(consoleIO, state);
    }

    @Override
    public void execute(String ... tokens) {
        if (tokens.length == 2) {
            String target = tokens[1].toLowerCase(Locale.ENGLISH);
            if ("repositories".equals(target) || "r".equals(target)) {
                this.showRepositories();
            } else if ("namespaces".equals(target) || "n".equals(target)) {
                this.showNamespaces();
            } else if ("contexts".equals(target) || "c".equals(target)) {
                this.showContexts();
            } else {
                this.writeError("Unknown target '" + tokens[1] + "'");
            }
        } else {
            this.writeln(this.getHelpLong());
        }
    }

    private void showRepositories() {
        block7: {
            try {
                RepositoryManager manager = this.state.getManager();
                Set repIDs = manager.getRepositoryIDs();
                if (repIDs.isEmpty()) {
                    this.writeln("No repositories found");
                    break block7;
                }
                this.writeln(OUTPUT_SEPARATOR);
                for (String repID : repIDs) {
                    this.write("|" + repID);
                    try {
                        RepositoryInfo repInfo = manager.getRepositoryInfo(repID);
                        if (repInfo.getDescription() != null) {
                            this.write(" (\"" + repInfo.getDescription() + "\")");
                        }
                    }
                    catch (RepositoryException e) {
                        this.write(" [ERROR: " + e.getMessage() + "]");
                    }
                    this.writeln("");
                }
                this.writeln(OUTPUT_SEPARATOR);
            }
            catch (RepositoryException e) {
                this.writeError("Failed to get repository list", (Exception)((Object)e));
            }
        }
    }

    private void showNamespaces() {
        Repository repository = this.state.getRepository();
        if (repository == null) {
            this.writeUnopenedError();
            return;
        }
        try (RepositoryConnection con = repository.getConnection();
             RepositoryResult namespaces = con.getNamespaces();){
            if (namespaces.hasNext()) {
                this.writeln(OUTPUT_SEPARATOR);
                while (namespaces.hasNext()) {
                    Namespace namespace = (Namespace)namespaces.next();
                    this.writeln("|" + namespace.getPrefix() + "  " + namespace.getName());
                }
                this.writeln(OUTPUT_SEPARATOR);
            } else {
                this.writeln("No namespaces found");
            }
        }
        catch (RepositoryException e) {
            this.writeError("Failed to show namespaces", (Exception)((Object)e));
        }
    }

    private void showContexts() {
        Repository repository = this.state.getRepository();
        if (repository == null) {
            this.writeUnopenedError();
            return;
        }
        try (RepositoryConnection con = repository.getConnection();
             RepositoryResult contexts = con.getContextIDs();){
            if (contexts.hasNext()) {
                this.writeln(OUTPUT_SEPARATOR);
                while (contexts.hasNext()) {
                    this.writeln("|" + ((Resource)contexts.next()).toString());
                }
                this.writeln(OUTPUT_SEPARATOR);
            } else {
                this.writeln("No contexts found");
            }
        }
        catch (RepositoryException e) {
            this.writeError("Failed to show contexts", (Exception)((Object)e));
        }
    }
}

