/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.util.Arrays;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.SerializerFourByte;

public class SerializerFloat
extends SerializerFourByte<Float> {
    @Override
    protected Float unpack(int l) {
        return new Float(Float.intBitsToFloat(l));
    }

    @Override
    protected int pack(Float l) {
        return Float.floatToIntBits(l.floatValue());
    }

    @Override
    public void serialize(DataOutput2 out, Float value) throws IOException {
        out.writeFloat(value.floatValue());
    }

    @Override
    public Float deserialize(DataInput2 in, int available) throws IOException {
        return new Float(in.readFloat());
    }

    @Override
    public int valueArraySearch(Object keys, Float key) {
        return Arrays.binarySearch(this.valueArrayToArray(keys), key);
    }
}

