/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrExists;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrFilter;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrStatementPattern;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSubSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrTripleLike;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrValues;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public final class GroupFilterExistsWithPrecedingTriplesTransform
extends BaseTransform {
    private GroupFilterExistsWithPrecedingTriplesTransform() {
    }

    public static IrBGP apply(IrBGP bgp) {
        return GroupFilterExistsWithPrecedingTriplesTransform.apply(bgp, false, false);
    }

    private static IrBGP apply(IrBGP bgp, boolean insideExists, boolean insideContainer) {
        if (bgp == null) {
            return null;
        }
        List<IrNode> in = bgp.getLines();
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        int i = 0;
        boolean avoidWrapInsideExists = false;
        if (insideExists) {
            boolean hasTripleLike = false;
            boolean hasNestedExistsOrValues = false;
            for (IrNode ln : in) {
                if (ln instanceof IrTripleLike) {
                    hasTripleLike = true;
                    continue;
                }
                if (ln instanceof IrFilter) {
                    IrFilter fx = (IrFilter)ln;
                    if (!(fx.getBody() instanceof IrExists)) continue;
                    hasNestedExistsOrValues = true;
                    continue;
                }
                if (!(ln instanceof IrValues)) continue;
                hasNestedExistsOrValues = true;
            }
            boolean bl = avoidWrapInsideExists = in.size() >= 2 && hasTripleLike && hasNestedExistsOrValues;
        }
        while (i < in.size()) {
            IrNode n = in.get(i);
            if (i + 1 < in.size() && n instanceof IrStatementPattern && in.get(i + 1) instanceof IrFilter) {
                boolean allowHere;
                IrFilter f = (IrFilter)in.get(i + 1);
                boolean bl = allowHere = insideExists || insideContainer || f.isNewScope();
                if (allowHere && f.getBody() instanceof IrExists) {
                    boolean doWrap;
                    boolean bl2 = doWrap = f.isNewScope() || insideExists && !avoidWrapInsideExists;
                    if (doWrap) {
                        IrBGP grp = new IrBGP(false);
                        grp.add(n);
                        grp.add(f);
                        out.add(grp);
                        i += 2;
                        continue;
                    }
                }
            }
            if (n instanceof IrSubSelect) {
                out.add(n);
            } else if (n instanceof IrFilter) {
                IrFilter f2 = (IrFilter)n;
                IrNode body = f2.getBody();
                if (body instanceof IrExists) {
                    IrExists ex = (IrExists)body;
                    IrFilter nf = new IrFilter(new IrExists(GroupFilterExistsWithPrecedingTriplesTransform.apply(ex.getWhere(), true, true), ex.isNewScope()), f2.isNewScope());
                    out.add(nf);
                } else {
                    out.add(n);
                }
            } else if (n instanceof IrBGP) {
                out.add(GroupFilterExistsWithPrecedingTriplesTransform.apply((IrBGP)n, insideExists, true));
            } else {
                IrNode rec = BaseTransform.rewriteContainers(n, child -> GroupFilterExistsWithPrecedingTriplesTransform.apply(child, insideExists, true));
                out.add(rec);
            }
            ++i;
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }
}

