/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.math.BigInteger;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ValidationSettings;
import org.eclipse.rdf4j.sail.shacl.ast.Cache;
import org.eclipse.rdf4j.sail.shacl.ast.NodeShape;
import org.eclipse.rdf4j.sail.shacl.ast.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclParsingException;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclProperties;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclUnsupportedException;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationQuery;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.AbstractBulkJoinPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BulkedExternalLeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.GroupByCountFilter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.NotValuesIn;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TrimToTarget;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TupleMapper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChain;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;

public class QualifiedMaxCountConstraintComponent
extends AbstractConstraintComponent {
    Shape qualifiedValueShape;
    boolean qualifiedValueShapesDisjoint;
    Long qualifiedMaxCount;

    public QualifiedMaxCountConstraintComponent(Resource id, ShapeSource shapeSource, Shape.ParseSettings parseSettings, Cache cache, Boolean qualifiedValueShapesDisjoint, Long qualifiedMaxCount) {
        super(id);
        ShaclProperties p = new ShaclProperties(id, shapeSource);
        this.qualifiedValueShapesDisjoint = qualifiedValueShapesDisjoint;
        this.qualifiedMaxCount = qualifiedMaxCount;
        if (p.getType() == SHACL.NODE_SHAPE) {
            this.qualifiedValueShape = NodeShape.getInstance(p, shapeSource, parseSettings, cache);
        } else if (p.getType() == SHACL.PROPERTY_SHAPE) {
            this.qualifiedValueShape = PropertyShape.getInstance(p, shapeSource, parseSettings, cache);
        } else {
            throw new IllegalStateException("Unknown shape type for " + String.valueOf(p.getId()));
        }
    }

    public QualifiedMaxCountConstraintComponent(QualifiedMaxCountConstraintComponent constraintComponent) {
        super(constraintComponent.getId());
        this.qualifiedValueShape = (Shape)constraintComponent.qualifiedValueShape.deepClone();
        this.qualifiedValueShapesDisjoint = constraintComponent.qualifiedValueShapesDisjoint;
        this.qualifiedMaxCount = constraintComponent.qualifiedMaxCount;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.QUALIFIED_VALUE_SHAPE, (Value)this.getId(), new Resource[0]);
        if (this.qualifiedValueShapesDisjoint) {
            model.add(subject, SHACL.QUALIFIED_VALUE_SHAPES_DISJOINT, (Value)Values.literal((boolean)this.qualifiedValueShapesDisjoint), new Resource[0]);
        }
        if (this.qualifiedMaxCount != null) {
            model.add(subject, SHACL.QUALIFIED_MAX_COUNT, (Value)Values.literal((BigInteger)BigInteger.valueOf(this.qualifiedMaxCount)), new Resource[0]);
        }
        this.qualifiedValueShape.toModel(null, null, model, cycleDetection);
    }

    @Override
    public void setTargetChain(TargetChain targetChain) {
        super.setTargetChain(targetChain);
        this.qualifiedValueShape.setTargetChain(targetChain.setOptimizable(false));
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.QualifiedMaxCountConstraintComponent;
    }

    @Override
    public ValidationQuery generateSparqlValidationQuery(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        assert (scope == ConstraintComponent.Scope.propertyShape);
        throw new ShaclUnsupportedException();
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        if (scope != ConstraintComponent.Scope.propertyShape) {
            throw new ShaclParsingException("QualifiedMaxCountConstraintComponent can only be used on property shapes!");
        }
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        EffectiveTarget effectiveTarget = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider);
        PlanNode target = overrideTargetNode != null ? effectiveTarget.extend(overrideTargetNode.getPlanNode(), connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.right, false, null) : this.getAllTargetsPlan(connectionsGroup, validationSettings.getDataGraph(), scope, stableRandomVariableProvider, validationSettings);
        PlanNode planNode = this.negated(connectionsGroup, validationSettings, overrideTargetNode, scope);
        planNode = new LeftOuterJoin(target, planNode, connectionsGroup);
        GroupByCountFilter groupByCountFilter = new GroupByCountFilter(planNode, count -> count > this.qualifiedMaxCount, connectionsGroup);
        return Unique.getInstance(new TrimToTarget(groupByCountFilter, connectionsGroup), false, connectionsGroup);
    }

    public PlanNode negated(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        PlanNodeProvider planNodeProvider = () -> {
            PlanNode target = overrideTargetNode == null ? this.getAllTargetsPlan(connectionsGroup, validationSettings.getDataGraph(), scope, stableRandomVariableProvider, validationSettings) : this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).extend(overrideTargetNode.getPlanNode(), connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.right, false, null);
            target = Unique.getInstance(new TrimToTarget(target, connectionsGroup), false, connectionsGroup);
            BulkedExternalLeftOuterJoin relevantTargetsWithPath = new BulkedExternalLeftOuterJoin(target, connectionsGroup.getBaseConnection(), validationSettings.getDataGraph(), this.getTargetChain().getPath().get().getTargetQueryFragment(new StatementMatcher.Variable<String>("a"), new StatementMatcher.Variable<String>("c"), connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of()), b -> new ValidationTuple(b.getValue("a"), b.getValue("c"), scope, true, validationSettings.getDataGraph()), connectionsGroup, AbstractBulkJoinPlanNode.DEFAULT_VARS);
            return new TupleMapper(relevantTargetsWithPath, t -> {
                List<Value> targetChain = t.getTargetChain(true);
                return new ValidationTuple(targetChain, ConstraintComponent.Scope.propertyShape, false, validationSettings.getDataGraph());
            }, connectionsGroup);
        };
        PlanNode planNode = this.qualifiedValueShape.generateTransactionalValidationPlan(connectionsGroup, validationSettings, planNodeProvider, scope);
        PlanNode invalid = Unique.getInstance(planNode, false, connectionsGroup);
        PlanNode allTargetsPlan = overrideTargetNode == null ? this.getAllTargetsPlan(connectionsGroup, validationSettings.getDataGraph(), scope, stableRandomVariableProvider, validationSettings) : this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).extend(overrideTargetNode.getPlanNode(), connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.right, false, null);
        allTargetsPlan = Unique.getInstance(new TrimToTarget(allTargetsPlan, connectionsGroup), false, connectionsGroup);
        allTargetsPlan = new BulkedExternalLeftOuterJoin(allTargetsPlan, connectionsGroup.getBaseConnection(), validationSettings.getDataGraph(), this.getTargetChain().getPath().get().getTargetQueryFragment(new StatementMatcher.Variable<String>("a"), new StatementMatcher.Variable<String>("c"), connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of()), b -> new ValidationTuple(b.getValue("a"), b.getValue("c"), scope, true, validationSettings.getDataGraph()), connectionsGroup, AbstractBulkJoinPlanNode.DEFAULT_VARS);
        invalid = new NotValuesIn(allTargetsPlan, invalid, connectionsGroup);
        return invalid;
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider, ValidationSettings validationSettings) {
        assert (scope == ConstraintComponent.Scope.propertyShape);
        EffectiveTarget effectiveTarget = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.propertyShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider);
        Path path = this.getTargetChain().getPath().orElseThrow();
        PlanNode allTargets = QualifiedMaxCountConstraintComponent.getAllTargetsIncludingThoseAddedByPath(connectionsGroup, validationSettings, scope, effectiveTarget, path, false);
        PlanNode subTargets = this.qualifiedValueShape.getAllTargetsPlan(connectionsGroup, dataGraph, scope, new StatementMatcher.StableRandomVariableProvider(), validationSettings);
        return Unique.getInstance(new TrimToTarget(UnionNode.getInstanceDedupe(connectionsGroup, allTargets, subTargets), connectionsGroup), false, connectionsGroup);
    }

    @Override
    public ConstraintComponent deepClone() {
        return new QualifiedMaxCountConstraintComponent(this);
    }

    @Override
    public boolean requiresEvaluation(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope, Resource[] dataGraph, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        return true;
    }

    @Override
    public List<Literal> getDefaultMessage() {
        return List.of();
    }

    @Override
    public boolean equals(ConstraintComponent o, IdentityHashMap<Shape, Shape> guard) {
        if (!(o instanceof QualifiedMaxCountConstraintComponent)) {
            return false;
        }
        QualifiedMaxCountConstraintComponent that = (QualifiedMaxCountConstraintComponent)o;
        if (this.qualifiedValueShapesDisjoint != that.qualifiedValueShapesDisjoint) {
            return false;
        }
        if (!this.qualifiedValueShape.equals(that.qualifiedValueShape, guard)) {
            return false;
        }
        return Objects.equals(this.qualifiedMaxCount, that.qualifiedMaxCount);
    }

    @Override
    public int hashCode(IdentityHashMap<Shape, Boolean> guard) {
        int result = this.qualifiedValueShape.hashCode(guard);
        result = 31 * result + (this.qualifiedValueShapesDisjoint ? 1 : 0);
        result = 31 * result + (this.qualifiedMaxCount != null ? this.qualifiedMaxCount.hashCode() : 0);
        return result + "QualifiedMaxCountConstraintComponent".hashCode();
    }
}

