/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.OrderElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.Slice;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.parser.ParsedQuery;

public abstract class BaseTupleExprRenderer
extends AbstractQueryModelVisitor<Exception> {
    protected Map<String, ValueExpr> mExtensions = new HashMap<String, ValueExpr>();
    protected List<ProjectionElemList> mProjection = new ArrayList<ProjectionElemList>();
    protected List<OrderElem> mOrdering = new ArrayList<OrderElem>();
    protected boolean mDistinct = false;
    protected boolean mReduced = false;
    protected long mLimit = -1L;
    protected long mOffset = -1L;

    public void reset() {
        this.mOffset = -1L;
        this.mLimit = -1L;
        this.mReduced = false;
        this.mDistinct = false;
        this.mExtensions.clear();
        this.mOrdering.clear();
        this.mProjection.clear();
    }

    public Map<String, ValueExpr> getExtensions() {
        return this.mExtensions;
    }

    public List<ProjectionElemList> getProjection() {
        return this.mProjection;
    }

    public List<OrderElem> getOrdering() {
        return this.mOrdering;
    }

    public boolean isDistinct() {
        return this.mDistinct;
    }

    public boolean isReduced() {
        return this.mReduced;
    }

    public long getLimit() {
        return this.mLimit;
    }

    public long getOffset() {
        return this.mOffset;
    }

    public String render(ParsedQuery theQuery) throws Exception {
        return this.render(theQuery.getTupleExpr());
    }

    public abstract String render(TupleExpr var1) throws Exception;

    protected abstract String renderValueExpr(ValueExpr var1) throws Exception;

    public StatementPattern toStatementPattern(ProjectionElemList theList) {
        ProjectionElem aSubj = theList.getElements().get(0);
        ProjectionElem aPred = theList.getElements().get(1);
        ProjectionElem aObj = theList.getElements().get(2);
        return new StatementPattern(this.mExtensions.containsKey(aSubj.getName()) ? Var.of(BaseTupleExprRenderer.scrubVarName(aSubj.getName()), this.asValue(this.mExtensions.get(aSubj.getName()))) : Var.of(BaseTupleExprRenderer.scrubVarName(aSubj.getName())), this.mExtensions.containsKey(aPred.getName()) ? Var.of(BaseTupleExprRenderer.scrubVarName(aPred.getName()), this.asValue(this.mExtensions.get(aPred.getName()))) : Var.of(BaseTupleExprRenderer.scrubVarName(aPred.getName())), this.mExtensions.containsKey(aObj.getName()) ? Var.of(BaseTupleExprRenderer.scrubVarName(aObj.getName()), this.asValue(this.mExtensions.get(aObj.getName()))) : Var.of(BaseTupleExprRenderer.scrubVarName(aObj.getName())));
    }

    public static String scrubVarName(String theName) {
        return theName.replace("-", "");
    }

    private Value asValue(ValueExpr theValue) {
        if (theValue instanceof ValueConstant) {
            return ((ValueConstant)theValue).getValue();
        }
        if (theValue instanceof Var) {
            Var aVar = (Var)theValue;
            if (aVar.hasValue()) {
                return aVar.getValue();
            }
            return null;
        }
        return null;
    }

    protected boolean isSelect() {
        boolean aIsSelect = false;
        for (ProjectionElemList aList : this.mProjection) {
            if (BaseTupleExprRenderer.isSPOElemList(aList)) continue;
            aIsSelect = true;
            break;
        }
        return aIsSelect;
    }

    public static boolean isSPOElemList(ProjectionElemList theList) {
        return theList.getElements().size() == 3 && theList.getElements().get(0).getProjectionAlias().get().equalsIgnoreCase("subject") && theList.getElements().get(1).getProjectionAlias().get().equalsIgnoreCase("predicate") && theList.getElements().get(2).getProjectionAlias().get().equalsIgnoreCase("object");
    }

    @Override
    public void meet(StatementPattern theStatementPattern) throws Exception {
        theStatementPattern.visitChildren(this);
    }

    @Override
    public void meet(Slice theSlice) throws Exception {
        if (theSlice.hasOffset()) {
            this.mOffset = theSlice.getOffset();
        }
        if (theSlice.hasLimit()) {
            this.mLimit = theSlice.getLimit();
        }
        theSlice.visitChildren(this);
    }

    @Override
    public void meet(ExtensionElem theExtensionElem) throws Exception {
        this.mExtensions.put(theExtensionElem.getName(), theExtensionElem.getExpr());
    }

    @Override
    public void meet(ProjectionElemList theProjectionElemList) throws Exception {
        if (!theProjectionElemList.getElements().isEmpty()) {
            this.mProjection.add(theProjectionElemList.clone());
        }
        theProjectionElemList.visitChildren(this);
    }

    @Override
    public void meet(OrderElem theOrderElem) {
        this.mOrdering.add(theOrderElem);
    }

    @Override
    public void meet(Distinct theDistinct) throws Exception {
        this.mDistinct = true;
        theDistinct.getArg().visit(this);
    }

    @Override
    public void meet(Reduced theReduced) throws Exception {
        this.mReduced = true;
        theReduced.visitChildren(this);
    }
}

