/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.paths;

import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclUnsupportedException;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.paths.AlternativePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.paths.SequencePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.SimplePath;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeWrapper;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;

public class ZeroOrOnePath
extends Path {
    private final Path path;

    public ZeroOrOnePath(Resource id, Resource path, ShapeSource shapeSource) {
        super(id);
        this.path = Path.buildPath(shapeSource, path);
    }

    public ZeroOrOnePath(Resource id, Path path) {
        super(id);
        this.path = path;
    }

    public String toString() {
        return "ZeroOrOnePath{ " + String.valueOf(this.path) + " }";
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.ZERO_OR_ONE_PATH, (Value)this.path.getId(), new Resource[0]);
        this.path.toModel(this.path.getId(), null, model, cycleDetection);
    }

    @Override
    public PlanNode getAllAdded(ConnectionsGroup connectionsGroup, Resource[] dataGraph, PlanNodeWrapper planNodeWrapper) {
        throw new ShaclUnsupportedException();
    }

    @Override
    public PlanNode getAnyAdded(ConnectionsGroup connectionsGroup, Resource[] dataGraph, PlanNodeWrapper planNodeWrapper) {
        return this.getAllAdded(connectionsGroup, dataGraph, planNodeWrapper);
    }

    @Override
    public boolean isSupported() {
        return false;
    }

    @Override
    public String toSparqlPathString() {
        assert (this.path.toSparqlPathString().equals(this.path.toSparqlPathString().trim()));
        if (this.path instanceof SimplePath || this.path instanceof AlternativePath || this.path instanceof SequencePath) {
            return this.path.toSparqlPathString() + "?";
        }
        return "(" + this.path.toSparqlPathString() + ")?";
    }

    @Override
    public SparqlFragment getTargetQueryFragment(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider, Set<String> inheritedVarNames) {
        throw new ShaclUnsupportedException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZeroOrOnePath that = (ZeroOrOnePath)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

