/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql;

import java.util.List;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTDatasetClause;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTIRI;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTModify;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTOperation;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTOperationContainer;

@InternalUseOnly
public class DatasetDeclProcessor {
    public static Dataset process(ASTOperationContainer qc) throws MalformedQueryException {
        List<ASTDatasetClause> datasetClauses;
        SimpleDataset dataset = null;
        ASTOperation op = qc.getOperation();
        if (op != null && !(datasetClauses = op.getDatasetClauseList()).isEmpty()) {
            dataset = new SimpleDataset();
            for (ASTDatasetClause dc : datasetClauses) {
                ASTIRI astIri = dc.jjtGetChild(ASTIRI.class);
                try {
                    IRI uri = RDF4J.NIL;
                    if (astIri != null) {
                        uri = SimpleValueFactory.getInstance().createIRI(astIri.getValue());
                    }
                    boolean withClause = false;
                    if (op instanceof ASTModify && dc.equals(((ASTModify)op).getWithClause())) {
                        withClause = true;
                        dataset.setDefaultInsertGraph(uri);
                        dataset.addDefaultRemoveGraph(uri);
                    }
                    if (withClause && datasetClauses.size() != 1) continue;
                    if (dc.isNamed()) {
                        dataset.addNamedGraph(uri);
                        continue;
                    }
                    dataset.addDefaultGraph(uri);
                }
                catch (IllegalArgumentException e) {
                    throw new MalformedQueryException(e.getMessage(), e);
                }
            }
        }
        return dataset;
    }
}

