/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.config;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.sail.config.AbstractSailImplConfig;
import org.eclipse.rdf4j.sail.config.DelegatingSailImplConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailConfigSchema;
import org.eclipse.rdf4j.sail.config.SailConfigUtil;
import org.eclipse.rdf4j.sail.config.SailImplConfig;

public abstract class AbstractDelegatingSailImplConfig
extends AbstractSailImplConfig
implements DelegatingSailImplConfig {
    private SailImplConfig delegate;

    public AbstractDelegatingSailImplConfig() {
    }

    public AbstractDelegatingSailImplConfig(String type) {
        super(type);
    }

    public AbstractDelegatingSailImplConfig(String type, SailImplConfig delegate) {
        this(type);
        this.setDelegate(delegate);
    }

    @Override
    public SailImplConfig getDelegate() {
        return this.delegate;
    }

    public void setDelegate(SailImplConfig delegate) {
        this.delegate = delegate;
    }

    @Override
    public void validate() throws SailConfigException {
        super.validate();
        if (this.delegate == null) {
            throw new SailConfigException("No delegate specified for " + this.getType() + " Sail");
        }
        this.delegate.validate();
    }

    @Override
    public Resource export(Model m) {
        if (Configurations.useLegacyConfig()) {
            return this.exportLegacy(m);
        }
        Resource implNode = super.export(m);
        if (this.delegate != null) {
            Resource delegateNode = this.delegate.export(m);
            m.add(implNode, CONFIG.delegate, (Value)delegateNode, new Resource[0]);
        }
        return implNode;
    }

    private Resource exportLegacy(Model m) {
        Resource implNode = super.export(m);
        if (this.delegate != null) {
            Resource delegateNode = this.delegate.export(m);
            m.add(implNode, SailConfigSchema.DELEGATE, (Value)delegateNode, new Resource[0]);
        }
        return implNode;
    }

    @Override
    public void parse(Model m, Resource implNode) throws SailConfigException {
        super.parse(m, implNode);
        try {
            Configurations.getResourceValue((Model)m, (Resource)implNode, (IRI)CONFIG.delegate, (IRI)SailConfigSchema.DELEGATE).ifPresent(delegate -> this.setDelegate(SailConfigUtil.parseRepositoryImpl(m, delegate)));
        }
        catch (ModelException e) {
            throw new SailConfigException(e.getMessage(), e);
        }
    }
}

