/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.uri;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import no.hasmac.jsonld.StringUtils;
import no.hasmac.jsonld.uri.UriUtils;

public final class UriResolver {
    private UriResolver() {
    }

    public static String resolve(URI base, String relative) {
        if (base == null) {
            return relative;
        }
        return UriResolver.resolve(base, UriUtils.create(relative));
    }

    public static String resolve(URI base, URI relative) {
        if (relative == null) {
            return base != null ? base.toString() : null;
        }
        if (base == null) {
            return relative.toString();
        }
        String[] components = UriResolver.resolveAsComponents(base, relative);
        return UriUtils.recompose(components[0], components[1], components[2], components[3], components[4]);
    }

    public static URI resolveAsUri(URI base, String relative) {
        if (StringUtils.isBlank(relative)) {
            return base;
        }
        if (base == null) {
            return UriUtils.create(relative);
        }
        return UriResolver.resolveAsUri(base, UriUtils.create(relative));
    }

    public static URI resolveAsUri(URI base, URI relative) {
        if (relative == null) {
            return base;
        }
        if (base == null) {
            return relative;
        }
        String[] components = UriResolver.resolveAsComponents(base, relative);
        try {
            if (components[0] != null && components[1] == null) {
                return new URI(components[0], components[2].trim().isEmpty() ? "." : components[2], components[4]);
            }
            return new URI(components[0], components[1], components[2], components[3], components[4]);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String[] resolveAsComponents(URI base, URI relative) {
        String basePath = base.getPath();
        String baseAuthority = base.getAuthority();
        String componentPath = relative.getPath();
        if (baseAuthority == null && base.getSchemeSpecificPart().startsWith("///")) {
            baseAuthority = "";
        }
        if (basePath == null && base.getSchemeSpecificPart() != null) {
            basePath = base.getSchemeSpecificPart();
        }
        if (componentPath == null && relative.getSchemeSpecificPart() != null) {
            componentPath = relative.getSchemeSpecificPart();
        }
        String[] target = new String[5];
        target[4] = relative.getFragment();
        if (relative.getScheme() != null && StringUtils.isNotBlank(relative.getScheme())) {
            target[0] = relative.getScheme();
            target[1] = relative.getAuthority();
            target[2] = UriResolver.removeDotSegments(componentPath);
            target[3] = relative.getQuery();
        } else {
            if (relative.getAuthority() != null && StringUtils.isNotBlank(relative.getAuthority())) {
                target[1] = relative.getAuthority();
                target[2] = UriResolver.removeDotSegments(componentPath);
                target[3] = relative.getQuery();
            } else {
                if (componentPath != null && StringUtils.isNotBlank(componentPath)) {
                    target[2] = componentPath.startsWith("/") ? UriResolver.removeDotSegments(componentPath) : (basePath != null && StringUtils.isNotBlank(basePath) ? UriResolver.removeDotSegments(UriResolver.merge(basePath, componentPath)) : "/".concat(UriResolver.removeDotSegments(componentPath)));
                    target[3] = relative.getQuery();
                } else {
                    target[2] = basePath;
                    target[3] = UriUtils.isDefined(relative.getQuery()) ? relative.getQuery() : base.getQuery();
                }
                target[1] = baseAuthority;
            }
            target[0] = base.getScheme();
        }
        return target;
    }

    private static String removeDotSegments(String path) {
        if (UriUtils.isNotDefined(path)) {
            return null;
        }
        if (!path.contains(".")) {
            return path;
        }
        String input = path;
        ArrayDeque<String> output = new ArrayDeque<String>();
        while (StringUtils.isNotBlank(input)) {
            if (input.startsWith("../")) {
                input = input.substring(3);
                continue;
            }
            if (input.startsWith("./")) {
                input = input.substring(2);
                continue;
            }
            if (input.startsWith("/./")) {
                input = input.substring(2);
                continue;
            }
            if ("/.".equals(input)) {
                input = "/";
                continue;
            }
            if (input.startsWith("/../")) {
                input = input.substring(3);
                if (output.isEmpty()) continue;
                output.removeLast();
                continue;
            }
            if ("/..".equals(input)) {
                input = "/";
                if (output.isEmpty()) continue;
                output.removeLast();
                continue;
            }
            if ("..".equals(input) || ".".equals(input)) {
                input = "";
                continue;
            }
            int nextSlashIndex = input.indexOf(47, 1);
            if (nextSlashIndex != -1) {
                output.addLast(input.substring(0, nextSlashIndex));
                input = input.substring(nextSlashIndex);
                continue;
            }
            output.addLast(input);
            input = "";
        }
        return String.join((CharSequence)"", output);
    }

    private static String merge(String basePath, String path) {
        if (UriUtils.isNotDefined(basePath)) {
            return "/".concat(path);
        }
        int rightMostSlash = basePath.lastIndexOf(47);
        if (rightMostSlash == -1) {
            return path;
        }
        return basePath.substring(0, rightMostSlash + 1).concat(path);
    }
}

