/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.list.primitive;

import java.util.Comparator;
import java.util.Random;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.block.comparator.primitive.ShortComparator;
import org.eclipse.collections.api.block.function.primitive.ShortIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.ImmutableShortList;
import org.eclipse.collections.api.list.primitive.ShortList;
import org.eclipse.collections.api.tuple.primitive.ShortObjectPair;
import org.eclipse.collections.api.tuple.primitive.ShortShortPair;

public interface MutableShortList
extends MutableShortCollection,
ShortList {
    public void addAtIndex(int var1, short var2);

    public boolean addAllAtIndex(int var1, short ... var2);

    public boolean addAllAtIndex(int var1, ShortIterable var2);

    public short removeAtIndex(int var1);

    public short set(int var1, short var2);

    default public void swap(int index1, int index2) {
        short value = this.get(index1);
        this.set(index1, this.get(index2));
        this.set(index2, value);
    }

    @Override
    public MutableShortList select(ShortPredicate var1);

    @Override
    public MutableShortList reject(ShortPredicate var1);

    @Override
    public MutableShortList with(short var1);

    @Override
    public MutableShortList without(short var1);

    @Override
    public MutableShortList withAll(ShortIterable var1);

    @Override
    public MutableShortList withoutAll(ShortIterable var1);

    @Override
    default public MutableShortList tap(ShortProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    public <V> MutableList<V> collect(ShortToObjectFunction<? extends V> var1);

    default public <V> MutableList<V> collectWithIndex(ShortIntToObjectFunction<? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((short each) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.value(each, n);
        });
    }

    public MutableShortList reverseThis();

    @Override
    public MutableShortList toReversed();

    @Override
    public MutableShortList distinct();

    public MutableShortList sortThis();

    default public MutableShortList sortThis(ShortComparator comparator) {
        throw new UnsupportedOperationException("sortThis(ShortComparator comparator) is not supported on " + this.getClass());
    }

    default public <T> MutableShortList sortThisBy(ShortToObjectFunction<T> function) {
        return this.sortThisBy(function, Comparator.naturalOrder());
    }

    default public <T> MutableShortList sortThisBy(ShortToObjectFunction<T> function, Comparator<? super T> comparator) {
        return this.sortThis((i1, i2) -> comparator.compare((Object)function.valueOf(i1), (Object)function.valueOf(i2)));
    }

    default public MutableShortList shuffleThis() {
        return this.shuffleThis(new Random());
    }

    default public MutableShortList shuffleThis(Random rnd) {
        for (int j = this.size() - 1; j > 0; --j) {
            int k = rnd.nextInt(j + 1);
            short selected = this.get(j);
            this.set(j, this.get(k));
            this.set(k, selected);
        }
        return this;
    }

    @Override
    public MutableShortList asUnmodifiable();

    @Override
    public MutableShortList asSynchronized();

    @Override
    public ImmutableShortList toImmutable();

    @Override
    public MutableShortList subList(int var1, int var2);

    default public MutableList<ShortShortPair> zipShort(ShortIterable iterable) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    default public <T> MutableList<ShortObjectPair<T>> zip(Iterable<T> list) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    @Override
    default public MutableShortList newEmpty() {
        throw new UnsupportedOperationException("Implement in concrete classes.");
    }
}

