/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.SolrException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionStream
extends TupleStream {
    private TupleStream stream;
    private Exception openException;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ExceptionStream(TupleStream stream) {
        this.stream = stream;
    }

    @Override
    public List<TupleStream> children() {
        return null;
    }

    @Override
    public void open() {
        try {
            this.stream.open();
        }
        catch (Exception e) {
            this.openException = e;
        }
    }

    @Override
    public Tuple read() {
        if (this.openException != null) {
            SolrException.log(log, this.openException);
            return Tuple.EXCEPTION(this.openException.getMessage(), true);
        }
        try {
            return this.stream.read();
        }
        catch (Exception e) {
            SolrException.log(log, e);
            return Tuple.EXCEPTION(e.getMessage(), true);
        }
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName("non-expressible").withImplementingClass(this.getClass().getName()).withExpressionType("stream-source").withExpression("non-expressible");
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.stream.getStreamSort();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.stream.setStreamContext(context);
    }
}

