/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated;

import java.util.Optional;
import org.eclipse.rdf4j.collection.factory.api.CollectionFactory;
import org.eclipse.rdf4j.federated.cache.SourceSelectionCacheFactory;
import org.eclipse.rdf4j.federated.evaluation.concurrent.TaskWrapper;

public class FedXConfig {
    public static FedXConfig DEFAULT_CONFIG = new FedXConfig();
    private int joinWorkerThreads = 20;
    private int unionWorkerThreads = 20;
    private int leftJoinWorkerThreads = 10;
    private int boundJoinBlockSize = 25;
    private int enforceMaxQueryTime = 30;
    private boolean enableServiceAsBoundJoin = true;
    private boolean enableOptionalAsBindJoin = true;
    private boolean enableMonitoring = false;
    private boolean isLogQueryPlan = false;
    private boolean isLogQueries = false;
    private boolean debugQueryPlan = false;
    private boolean includeInferredDefault = true;
    private String sourceSelectionCacheSpec = null;
    private SourceSelectionCacheFactory sourceSelectionCacheFactory = null;
    private TaskWrapper taskWrapper = null;
    private String prefixDeclarations = null;
    private int consumingIterationMax = 1000;

    public FedXConfig withDebugQueryPlan(boolean flag) {
        this.debugQueryPlan = flag;
        return this;
    }

    public FedXConfig withLogQueries(boolean flag) {
        this.isLogQueries = flag;
        return this;
    }

    public FedXConfig withEnforceMaxQueryTime(int enforceMaxQueryTime) {
        this.enforceMaxQueryTime = enforceMaxQueryTime;
        return this;
    }

    public FedXConfig withIncludeInferredDefault(boolean flag) {
        this.includeInferredDefault = flag;
        return this;
    }

    public FedXConfig withEnableMonitoring(boolean flag) {
        this.enableMonitoring = flag;
        return this;
    }

    public FedXConfig withBoundJoinBlockSize(int boundJoinBlockSize) {
        this.boundJoinBlockSize = boundJoinBlockSize;
        return this;
    }

    public FedXConfig withJoinWorkerThreads(int joinWorkerThreads) {
        this.joinWorkerThreads = joinWorkerThreads;
        return this;
    }

    public FedXConfig withLeftJoinWorkerThreads(int leftJoinWorkerThreads) {
        this.leftJoinWorkerThreads = leftJoinWorkerThreads;
        return this;
    }

    public FedXConfig withUnionWorkerThreads(int unionWorkerThreads) {
        this.unionWorkerThreads = unionWorkerThreads;
        return this;
    }

    public FedXConfig withPrefixDeclarations(String prefixFile) {
        this.prefixDeclarations = prefixFile;
        return this;
    }

    public FedXConfig withLogQueryPlan(boolean flag) {
        this.isLogQueryPlan = flag;
        return this;
    }

    public FedXConfig withEnableServiceAsBoundJoin(boolean flag) {
        this.enableServiceAsBoundJoin = flag;
        return this;
    }

    public FedXConfig withEnableOptionalAsBindJoin(boolean flag) {
        this.enableOptionalAsBindJoin = flag;
        return this;
    }

    public FedXConfig withSourceSelectionCacheSpec(String cacheSpec) {
        this.sourceSelectionCacheSpec = cacheSpec;
        return this;
    }

    public FedXConfig withSourceSelectionCacheFactory(SourceSelectionCacheFactory factory) {
        this.sourceSelectionCacheFactory = factory;
        return this;
    }

    public FedXConfig withTaskWrapper(TaskWrapper taskWrapper) {
        this.taskWrapper = taskWrapper;
        return this;
    }

    public int getJoinWorkerThreads() {
        return this.joinWorkerThreads;
    }

    public int getUnionWorkerThreads() {
        return this.unionWorkerThreads;
    }

    public int getLeftJoinWorkerThreads() {
        return this.leftJoinWorkerThreads;
    }

    public int getBoundJoinBlockSize() {
        return this.boundJoinBlockSize;
    }

    public boolean getEnableServiceAsBoundJoin() {
        return this.enableServiceAsBoundJoin;
    }

    public boolean isEnableOptionalAsBindJoin() {
        return this.enableOptionalAsBindJoin;
    }

    public int getEnforceMaxQueryTime() {
        return this.enforceMaxQueryTime;
    }

    public boolean getIncludeInferredDefault() {
        return this.includeInferredDefault;
    }

    public boolean isEnableMonitoring() {
        return this.enableMonitoring;
    }

    public boolean isLogQueryPlan() {
        return this.isLogQueryPlan;
    }

    public boolean isLogQueries() {
        return this.isLogQueries;
    }

    public String getPrefixDeclarations() {
        return this.prefixDeclarations;
    }

    public String getSourceSelectionCacheSpec() {
        return this.sourceSelectionCacheSpec;
    }

    public SourceSelectionCacheFactory getSourceSelectionCacheFactory() {
        return this.sourceSelectionCacheFactory;
    }

    public boolean isDebugQueryPlan() {
        return this.debugQueryPlan;
    }

    public Optional<TaskWrapper> getTaskWrapper() {
        return Optional.ofNullable(this.taskWrapper);
    }

    public FedXConfig withConsumingIterationMax(int max) {
        this.consumingIterationMax = max;
        return this;
    }

    public int getConsumingIterationMax() {
        return this.consumingIterationMax;
    }

    @Deprecated(forRemoval=true)
    public FedXConfig withCollectionFactory(CollectionFactory cf) {
        return this;
    }
}

