/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.util;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.GetStatementOptional;
import org.eclipse.rdf4j.model.util.RDFCollections;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.util.Repositories;

public class Connections {
    public static void consumeRDFCollection(RepositoryConnection conn, Resource head, Consumer<Statement> collectionConsumer, Resource ... contexts) throws RepositoryException {
        GetStatementOptional statementSupplier = (s, p, o, c) -> Connections.getStatement(conn, s, p, o, c);
        Function exceptionSupplier = Repositories::repositoryException;
        RDFCollections.extract(statementSupplier, head, collectionConsumer, exceptionSupplier, contexts);
    }

    public static <C extends Collection<Statement>> C getRDFCollection(RepositoryConnection conn, Resource head, C statementCollection, Resource ... contexts) throws RepositoryException {
        Objects.requireNonNull(statementCollection, "statementCollection may not be null");
        Connections.consumeRDFCollection(conn, head, st -> statementCollection.add(st), contexts);
        return statementCollection;
    }

    public static Optional<Statement> getStatement(RepositoryConnection conn, Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        try (RepositoryResult<Statement> stmts = conn.getStatements(subject, predicate, object, contexts);){
            Statement st = stmts.hasNext() ? stmts.next() : null;
            Optional<Statement> optional = Optional.ofNullable(st);
            return optional;
        }
    }
}

