/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql;

import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.GEOF;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.FunctionArguments;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.SpatialSupport;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;

public class Relate
implements Function {
    public String getURI() {
        return GEOF.RELATE.stringValue();
    }

    public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 3) {
            throw new ValueExprEvaluationException(this.getURI() + " requires exactly 3 arguments, got " + args.length);
        }
        SpatialContext geoContext = SpatialSupport.getSpatialContext();
        Shape geom1 = FunctionArguments.getShape(this, args[0], geoContext);
        Shape geom2 = FunctionArguments.getShape(this, args[1], geoContext);
        String pattern = FunctionArguments.getString(this, args[2]);
        boolean result = SpatialSupport.getSpatialAlgebra().relate(geom1, geom2, pattern);
        return valueFactory.createLiteral(result);
    }
}

