/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.string;

import java.util.Optional;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtility;

public class UpperCase
implements Function {
    @Override
    public String getURI() {
        return FN.UPPER_CASE.toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("UCASE requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            if (QueryEvaluationUtility.isStringLiteral(literal)) {
                String lexicalValue = literal.getLabel().toUpperCase();
                Optional language = literal.getLanguage();
                if (language.isPresent()) {
                    return valueFactory.createLiteral(lexicalValue, (String)language.get());
                }
                if (QueryEvaluationUtility.isSimpleLiteral(literal)) {
                    return valueFactory.createLiteral(lexicalValue, (CoreDatatype)CoreDatatype.XSD.STRING);
                }
                return valueFactory.createLiteral(lexicalValue);
            }
            throw new ValueExprEvaluationException("unexpected input value for function: " + String.valueOf(args[0]));
        }
        throw new ValueExprEvaluationException("unexpected input value for function: " + String.valueOf(args[0]));
    }
}

