/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.command.Close;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryReadOnlyException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;

public class Drop
extends ConsoleCommand {
    private final Close close;

    @Override
    public String getName() {
        return "drop";
    }

    @Override
    public String getHelpShort() {
        return "Drops a repository";
    }

    @Override
    public String getHelpLong() {
        return "Usage:\ndrop <repositoryID>   Drops the repository with the specified id\n";
    }

    public Drop(ConsoleIO consoleIO, ConsoleState state, Close close) {
        super(consoleIO, state);
        this.close = close;
    }

    @Override
    public void execute(String ... tokens) {
        if (tokens.length < 2) {
            this.writeln(this.getHelpLong());
        } else {
            String repoID = tokens[1];
            try {
                this.dropRepository(repoID);
            }
            catch (RepositoryConfigException e) {
                this.writeError("Unable to drop repository '" + repoID, e);
            }
            catch (RepositoryReadOnlyException e) {
                try {
                    this.execute(tokens);
                }
                catch (RepositoryException e2) {
                    this.writeError("Failed to restart system", e2);
                }
            }
            catch (RepositoryException e) {
                this.writeError("Failed to update configuration in system repository", e);
            }
        }
    }

    private void dropRepository(String repoID) throws RepositoryException, RepositoryConfigException {
        boolean proceed = this.askProceed("WARNING: you are about to drop repository '" + repoID + "'.", true);
        if (proceed && !this.state.getManager().isSafeToRemove(repoID)) {
            proceed = this.askProceed("WARNING: dropping this repository may break another that is proxying it.", false);
        }
        if (proceed) {
            boolean isRemoved;
            if (repoID.equals(this.state.getRepositoryID())) {
                this.close.closeRepository(false);
            }
            if (isRemoved = this.state.getManager().removeRepository(repoID)) {
                this.writeInfo("Dropped repository '" + repoID + "'");
            } else {
                this.writeInfo("Unknown repository '" + repoID + "'");
            }
        } else {
            this.writeln("Drop aborted");
        }
    }
}

