/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.processor;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.Optional;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.JsonLdErrorCode;
import no.hasmac.jsonld.JsonLdOptions;
import no.hasmac.jsonld.context.ActiveContext;
import no.hasmac.jsonld.document.Document;
import no.hasmac.jsonld.expansion.Expansion;
import no.hasmac.jsonld.json.JsonProvider;
import no.hasmac.jsonld.json.JsonUtils;
import no.hasmac.jsonld.loader.DocumentLoaderOptions;

public final class ExpansionProcessor {
    ExpansionProcessor() {
    }

    public static JsonArray expand(URI input, JsonLdOptions options) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document loader is null. Cannot fetch [" + String.valueOf(input) + "].");
        }
        DocumentLoaderOptions loaderOptions = new DocumentLoaderOptions();
        loaderOptions.setExtractAllScripts(options.isExtractAllScripts());
        Document remoteDocument = options.getDocumentLoader().loadDocument(input, loaderOptions);
        if (remoteDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED);
        }
        return ExpansionProcessor.expand(remoteDocument, options, false);
    }

    public static JsonArray expand(Document input, JsonLdOptions options, boolean frameExpansion) throws JsonLdError {
        JsonObject object;
        JsonValue expanded;
        Optional<JsonStructure> contextValue;
        if (input == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "RemoteDocument is null.");
        }
        JsonStructure jsonStructure = input.getJsonContent().orElseThrow(() -> new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document is not pased JSON."));
        URI baseUri = null;
        URI baseUrl = null;
        if (input.getDocumentUrl() != null) {
            baseUri = baseUrl = input.getDocumentUrl();
        }
        if (baseUrl == null) {
            baseUrl = options.getBase();
        }
        if (options.getBase() != null) {
            baseUri = options.getBase();
        }
        ActiveContext activeContext = new ActiveContext(baseUri, baseUrl, options);
        if (options.getExpandContext() != null && (contextValue = options.getExpandContext().getJsonContent()).isPresent()) {
            activeContext = ExpansionProcessor.updateContext(activeContext, (JsonValue)contextValue.get(), baseUrl);
        }
        if (input.getContextUrl() != null) {
            activeContext = activeContext.newContext().create((JsonValue)JsonProvider.instance().createValue(input.getContextUrl().toString()), input.getContextUrl());
        }
        if (JsonUtils.isObject(expanded = Expansion.with(activeContext, (JsonValue)jsonStructure, null, baseUrl).frameExpansion(frameExpansion).ordered(options.isOrdered()).compute()) && (object = expanded.asJsonObject()).size() == 1 && object.containsKey((Object)"@graph")) {
            expanded = (JsonValue)object.get((Object)"@graph");
        }
        if (JsonUtils.isNull(expanded)) {
            return JsonValue.EMPTY_JSON_ARRAY;
        }
        return JsonUtils.toJsonArray(expanded);
    }

    private static ActiveContext updateContext(ActiveContext activeContext, JsonValue expandedContext, URI baseUrl) throws JsonLdError {
        if (JsonUtils.isArray(expandedContext)) {
            JsonValue value;
            if (expandedContext.asJsonArray().size() == 1 && JsonUtils.containsKey(value = (JsonValue)expandedContext.asJsonArray().iterator().next(), "@context")) {
                return activeContext.newContext().create((JsonValue)value.asJsonObject().get((Object)"@context"), baseUrl);
            }
            return activeContext.newContext().create(expandedContext, baseUrl);
        }
        if (JsonUtils.containsKey(expandedContext, "@context")) {
            return activeContext.newContext().create((JsonValue)expandedContext.asJsonObject().get((Object)"@context"), baseUrl);
        }
        return activeContext.newContext().create((JsonValue)JsonProvider.instance().createArrayBuilder().add(expandedContext).build(), baseUrl);
    }
}

