/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.util;

import java.util.Comparator;
import java.util.Optional;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtility;

public class ValueComparator
implements Comparator<Value> {
    private boolean strict = true;

    @Override
    public int compare(Value o1, Value o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        boolean b1 = o1.isBNode();
        boolean b2 = o2.isBNode();
        if (b1 && b2) {
            return this.compareBNodes((BNode)o1, (BNode)o2);
        }
        if (b1) {
            return -1;
        }
        if (b2) {
            return 1;
        }
        boolean iri1 = o1.isIRI();
        boolean iri2 = o2.isIRI();
        if (iri1 && iri2) {
            return this.compareIRIs((IRI)o1, (IRI)o2);
        }
        if (iri1) {
            return -1;
        }
        if (iri2) {
            return 1;
        }
        boolean l1 = o1.isLiteral();
        boolean l2 = o2.isLiteral();
        if (l1 && l2) {
            return this.compareLiterals((Literal)o1, (Literal)o2);
        }
        if (l1) {
            return -1;
        }
        if (l2) {
            return 1;
        }
        return this.compareTriples((Triple)o1, (Triple)o2);
    }

    public void setStrict(boolean flag) {
        this.strict = flag;
    }

    public boolean isStrict() {
        return this.strict;
    }

    private int compareBNodes(BNode leftBNode, BNode rightBNode) {
        return leftBNode.getID().compareTo(rightBNode.getID());
    }

    private int compareIRIs(IRI leftIRI, IRI rightIRI) {
        return leftIRI.toString().compareTo(rightIRI.toString());
    }

    private int compareLiterals(Literal leftLit, Literal rightLit) {
        if (!QueryEvaluationUtility.isPlainLiteral(leftLit) && !QueryEvaluationUtility.isPlainLiteral(rightLit)) {
            QueryEvaluationUtility.Order order = this.compareNonPlainLiterals(leftLit, rightLit);
            if (order.isValid()) {
                return order.asInt();
            }
            if (order == QueryEvaluationUtility.Order.illegalArgument) {
                throw new IllegalStateException();
            }
        }
        return this.comparePlainLiterals(leftLit, rightLit);
    }

    private QueryEvaluationUtility.Order compareNonPlainLiterals(Literal leftLit, Literal rightLit) {
        QueryEvaluationUtility.Order order = QueryEvaluationUtility.compareLiterals(leftLit, rightLit, this.strict);
        if (order == QueryEvaluationUtility.Order.notEqual) {
            return QueryEvaluationUtility.Order.smaller;
        }
        return order;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int comparePlainLiterals(Literal leftLit, Literal rightLit) {
        int result;
        IRI leftDatatype = leftLit.getDatatype();
        IRI rightDatatype = rightLit.getDatatype();
        if (leftDatatype != null) {
            CoreDatatype.XSD rightXmlDatatype;
            if (rightDatatype == null) return 1;
            CoreDatatype.XSD leftXmlDatatype = leftLit.getCoreDatatype().asXSDDatatypeOrNull();
            result = this.compareDatatypes(leftXmlDatatype, rightXmlDatatype = rightLit.getCoreDatatype().asXSDDatatypeOrNull(), leftDatatype, rightDatatype);
            if (result != 0) {
                return result;
            }
        } else if (rightDatatype != null) {
            return -1;
        }
        Optional leftLanguage = leftLit.getLanguage();
        Optional rightLanguage = rightLit.getLanguage();
        if (leftLanguage.isPresent()) {
            if (!rightLanguage.isPresent()) return 1;
            result = ((String)leftLanguage.get()).compareTo((String)rightLanguage.get());
            if (result == 0) return leftLit.getLabel().compareTo(rightLit.getLabel());
            return result;
        }
        if (!rightLanguage.isPresent()) return leftLit.getLabel().compareTo(rightLit.getLabel());
        return -1;
    }

    private int compareDatatypes(CoreDatatype.XSD leftDatatype, CoreDatatype.XSD rightDatatype, IRI leftDatatypeIRI, IRI rightDatatypeIRI) {
        if (leftDatatype != null && leftDatatype == rightDatatype) {
            return 0;
        }
        if (leftDatatype != null && leftDatatype.isNumericDatatype()) {
            if (rightDatatype != null && rightDatatype.isNumericDatatype()) {
                return leftDatatype.compareTo((Enum)rightDatatype);
            }
            return -1;
        }
        if (rightDatatype != null && rightDatatype.isNumericDatatype()) {
            return 1;
        }
        if (leftDatatype != null && leftDatatype.isCalendarDatatype()) {
            if (rightDatatype != null && rightDatatype.isCalendarDatatype()) {
                return leftDatatype.compareTo((Enum)rightDatatype);
            }
            return -1;
        }
        if (rightDatatype != null && rightDatatype.isCalendarDatatype()) {
            return 1;
        }
        if (leftDatatype != null && rightDatatype != null) {
            return leftDatatype.compareTo((Enum)rightDatatype);
        }
        return this.compareIRIs(leftDatatypeIRI, rightDatatypeIRI);
    }

    private int compareTriples(Triple leftTriple, Triple rightTriple) {
        int c = this.compare((Value)leftTriple.getSubject(), (Value)rightTriple.getSubject());
        if (c == 0 && (c = this.compare((Value)leftTriple.getPredicate(), (Value)rightTriple.getPredicate())) == 0) {
            c = this.compare(leftTriple.getObject(), rightTriple.getObject());
        }
        return c;
    }
}

