/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableByteDoubleMapFactory;
import org.eclipse.collections.api.map.primitive.ByteDoubleMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteDoubleMap;
import org.eclipse.collections.impl.factory.primitive.ByteDoubleMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteDoubleEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteDoubleHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteDoubleSingletonMap;

public enum ImmutableByteDoubleMapFactoryImpl implements ImmutableByteDoubleMapFactory
{
    INSTANCE;


    public ImmutableByteDoubleMap empty() {
        return ImmutableByteDoubleEmptyMap.INSTANCE;
    }

    public ImmutableByteDoubleMap of() {
        return this.empty();
    }

    public ImmutableByteDoubleMap with() {
        return this.empty();
    }

    public ImmutableByteDoubleMap of(byte key, double value) {
        return this.with(key, value);
    }

    public ImmutableByteDoubleMap with(byte key, double value) {
        return new ImmutableByteDoubleSingletonMap(key, value);
    }

    public ImmutableByteDoubleMap ofAll(ByteDoubleMap map) {
        return this.withAll(map);
    }

    public ImmutableByteDoubleMap withAll(ByteDoubleMap map) {
        if (map instanceof ImmutableByteDoubleMap) {
            return (ImmutableByteDoubleMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            byte key = map.keysView().byteIterator().next();
            return new ImmutableByteDoubleSingletonMap(key, map.get(key));
        }
        return new ImmutableByteDoubleHashMap(map);
    }

    public <T> ImmutableByteDoubleMap from(Iterable<T> iterable, ByteFunction<? super T> keyFunction, DoubleFunction<? super T> valueFunction) {
        return ByteDoubleMaps.mutable.from(iterable, keyFunction, valueFunction).toImmutable();
    }
}

