/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.parallel;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.multimap.set.UnsortedSetMultimap;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.impl.lazy.parallel.AbstractParallelIterable;
import org.eclipse.collections.impl.lazy.parallel.Batch;
import org.eclipse.collections.impl.lazy.parallel.list.DistinctBatch;
import org.eclipse.collections.impl.lazy.parallel.set.AbstractParallelUnsortedSetIterable;
import org.eclipse.collections.impl.lazy.parallel.set.UnsortedSetBatch;
import org.eclipse.collections.impl.map.mutable.ConcurrentHashMap;
import org.eclipse.collections.impl.multimap.set.UnifiedSetMultimap;

@Beta
public class ParallelDistinctIterable<T>
extends AbstractParallelUnsortedSetIterable<T, UnsortedSetBatch<T>> {
    private final AbstractParallelIterable<T, ? extends Batch<T>> delegate;

    public ParallelDistinctIterable(AbstractParallelIterable<T, ? extends Batch<T>> delegate) {
        this.delegate = delegate;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.delegate.getExecutorService();
    }

    @Override
    public int getBatchSize() {
        return this.delegate.getBatchSize();
    }

    @Override
    public LazyIterable<UnsortedSetBatch<T>> split() {
        ConcurrentHashMap distinct = new ConcurrentHashMap();
        return this.delegate.split().collect((Function & Serializable)batch -> new DistinctBatch(batch, distinct));
    }

    @Override
    public ParallelUnsortedSetIterable<T> asUnique() {
        return this;
    }

    public void forEach(Procedure<? super T> procedure) {
        ConcurrentHashMap distinct = new ConcurrentHashMap();
        this.delegate.forEach((Procedure & Serializable)each -> {
            if (distinct.put(each, true) == null) {
                procedure.value(each);
            }
        });
    }

    public boolean anySatisfy(Predicate<? super T> predicate) {
        return this.delegate.anySatisfy(new DistinctAndPredicate(predicate));
    }

    public boolean allSatisfy(Predicate<? super T> predicate) {
        return this.delegate.allSatisfy(new DistinctOrPredicate(predicate));
    }

    public T detect(Predicate<? super T> predicate) {
        return (T)this.delegate.detect(new DistinctAndPredicate(predicate));
    }

    public Object[] toArray() {
        return this.delegate.toList().distinct().toArray();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.delegate.toList().distinct().toArray((Object[])array);
    }

    @Override
    public <V> UnsortedSetMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return (UnsortedSetMultimap)this.delegate.toSet().groupBy(function, new UnifiedSetMultimap());
    }

    @Override
    public <V> UnsortedSetMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return (UnsortedSetMultimap)this.delegate.toSet().groupByEach(function, new UnifiedSetMultimap());
    }

    @Override
    public <V> MapIterable<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return this.delegate.toSet().groupByUniqueKey(function);
    }

    private static final class DistinctOrPredicate<T>
    implements Predicate<T> {
        private final ConcurrentHashMap<T, Boolean> distinct = new ConcurrentHashMap();
        private final Predicate<? super T> predicate;

        private DistinctOrPredicate(Predicate<? super T> predicate) {
            this.predicate = predicate;
        }

        public boolean accept(T each) {
            return this.distinct.put(each, true) != null || this.predicate.accept(each);
        }
    }

    private static final class DistinctAndPredicate<T>
    implements Predicate<T> {
        private final ConcurrentHashMap<T, Boolean> distinct = new ConcurrentHashMap();
        private final Predicate<? super T> predicate;

        private DistinctAndPredicate(Predicate<? super T> predicate) {
            this.predicate = predicate;
        }

        public boolean accept(T each) {
            return this.distinct.put(each, true) == null && this.predicate.accept(each);
        }
    }
}

